/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.store.BatchingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.io.Funnel;
import org.neo4j.unsafe.impl.batchimport.store.io.JobMonitor;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;
import org.neo4j.unsafe.impl.batchimport.store.io.WriteQueue;

public class IoQueue
implements BatchingWindowPoolFactory.WriterFactory {
    private final ExecutorService executor;
    private final JobMonitor jobMonitor = new JobMonitor();
    private final BatchingWindowPoolFactory.WriterFactory delegateFactory;

    public IoQueue(int maxIOThreads, BatchingWindowPoolFactory.WriterFactory delegateFactory) {
        this(Executors.newFixedThreadPool(maxIOThreads, new NamedThreadFactory("IoQueue I/O thread")), delegateFactory);
    }

    IoQueue(ExecutorService executor, BatchingWindowPoolFactory.WriterFactory delegateFactory) {
        this.executor = executor;
        this.delegateFactory = delegateFactory;
    }

    @Override
    public BatchingWindowPoolFactory.Writer create(StoreChannel channel, Monitor monitor) {
        BatchingWindowPoolFactory.Writer writer = this.delegateFactory.create(channel, monitor);
        WriteQueue queue = new WriteQueue(this.executor, this.jobMonitor);
        return new Funnel(writer, queue);
    }

    @Override
    public void awaitEverythingWritten() {
        long endTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
        while (this.jobMonitor.hasActiveJobs()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (System.currentTimeMillis() <= endTime) continue;
            throw new RuntimeException("Didn't finish within designated time");
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        this.awaitEverythingWritten();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

