/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractTransactionManager
implements TransactionManager,
Lifecycle {
    public abstract void doRecovery() throws Throwable;

    public abstract TransactionState getTransactionState();

    public abstract int getEventIdentifier();

    public void begin(ForceMode forceMode) throws NotSupportedException, SystemException {
        this.begin();
    }

    public ForceMode getForceMode() {
        return ForceMode.forced;
    }

    public Throwable getRecoveryError() {
        return null;
    }

    public void assertInTransaction() {
        try {
            if (this.getTransaction() == null) {
                throw new NotInTransactionException();
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Unable to determine transaction state", e);
        }
    }
}

