/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public class StoreVersionCheck {
    private final FileSystemAbstraction fs;

    public StoreVersionCheck(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Outcome, String> hasVersion(File storeFile, String expectedVersion) {
        Channel fileChannel = null;
        byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
        try {
            if (!this.fs.fileExists(storeFile)) {
                Pair<Outcome, Object> pair = Pair.of(Outcome.missingStoreFile, null);
                return pair;
            }
            fileChannel = this.fs.open(storeFile, "r");
            if (fileChannel.size() < (long)expectedVersionBytes.length) {
                Pair<Outcome, Object> pair = Pair.of(Outcome.storeVersionNotFound, null);
                return pair;
            }
            String actualVersion = this.readVersion((StoreChannel)fileChannel, expectedVersionBytes.length);
            if (!actualVersion.startsWith(this.typeDescriptor(expectedVersion))) {
                Pair<Outcome, String> pair = Pair.of(Outcome.storeVersionNotFound, actualVersion);
                return pair;
            }
            if (expectedVersion.equals(actualVersion)) return Pair.of(Outcome.ok, null);
            Pair<Outcome, String> pair = Pair.of(Outcome.unexpectedUpgradingStoreVersion, actualVersion);
            return pair;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String typeDescriptor(String expectedVersion) {
        int spaceIndex = expectedVersion.indexOf(32);
        if (spaceIndex == -1) {
            throw new IllegalArgumentException("Unexpected version " + expectedVersion);
        }
        return expectedVersion.substring(0, spaceIndex);
    }

    private String readVersion(StoreChannel fileChannel, int bytesToRead) throws IOException {
        fileChannel.position(fileChannel.size() - (long)bytesToRead);
        byte[] foundVersionBytes = new byte[bytesToRead];
        fileChannel.read(ByteBuffer.wrap(foundVersionBytes));
        return UTF8.decode(foundVersionBytes);
    }

    public static enum Outcome {
        ok(true),
        missingStoreFile(false),
        storeVersionNotFound(false),
        unexpectedUpgradingStoreVersion(false);

        private final boolean success;

        private Outcome(boolean success) {
            this.success = success;
        }

        public boolean isSuccessful() {
            return this.success;
        }
    }
}

