/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV0;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandReaderV1;

public interface XaCommandReaderFactory {
    public static final XaCommandReaderFactory DEFAULT = new XaCommandReaderFactory(){

        @Override
        public XaCommandReader newInstance(byte logEntryVersion, ByteBuffer scratch) {
            switch (logEntryVersion) {
                case 0: {
                    return new PhysicalLogNeoXaCommandReaderV0(scratch);
                }
                case -1: {
                    return new PhysicalLogNeoXaCommandReaderV1(scratch);
                }
            }
            throw new IllegalArgumentException("Unknown log entry version " + logEntryVersion);
        }
    };

    public XaCommandReader newInstance(byte var1, ByteBuffer var2);
}

