/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.LinkedList;
import org.neo4j.kernel.impl.locking.community.LockException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public abstract class LockableWindow
implements PersistenceWindow {
    private final StoreChannel fileChannel;
    private Thread lockingThread = null;
    private final LinkedList<LockElement> waitingThreadList = new LinkedList();
    private boolean locked;
    private int marked = 0;
    protected boolean closed;
    private boolean isDirty = false;

    LockableWindow(StoreChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    StoreChannel getFileChannel() {
        return this.fileChannel;
    }

    protected final void writeOutAndClose() {
        this.force();
        this.close();
    }

    synchronized boolean markAsInUse() {
        if (this.closed) {
            return false;
        }
        ++this.marked;
        return true;
    }

    synchronized void lock(OperationType operationType) {
        Thread currentThread = Thread.currentThread();
        LockElement le = null;
        while (this.locked && this.lockingThread != currentThread) {
            if (le == null) {
                le = new LockElement(currentThread);
            }
            this.waitingThreadList.addFirst(le);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        this.locked = true;
        this.lockingThread = currentThread;
        if (le != null) {
            le.movedOn = true;
        }
        --this.marked;
        if (operationType == OperationType.WRITE) {
            this.isDirty = true;
        }
    }

    synchronized boolean isDirty() {
        return this.isDirty;
    }

    synchronized void setClean() {
        this.isDirty = false;
    }

    synchronized void unLock() {
        Thread currentThread = Thread.currentThread();
        if (!this.locked) {
            throw new LockException(currentThread + " doesn't have window lock on " + this);
        }
        this.locked = false;
        this.lockingThread = null;
        while (!this.waitingThreadList.isEmpty()) {
            LockElement le = this.waitingThreadList.removeLast();
            if (le.movedOn) continue;
            le.thread.interrupt();
            break;
        }
    }

    private boolean isFree(boolean assumingOwnerUnlockedIt) {
        return assumingOwnerUnlockedIt ? this.marked == 0 : this.marked == 0 && !this.locked;
    }

    synchronized boolean writeOutAndCloseIfFree(boolean readOnly) {
        if (this.isFree(this.lockingThread == Thread.currentThread())) {
            if (!readOnly) {
                this.writeOutAndClose();
            }
            return true;
        }
        return false;
    }

    void acceptContents(PersistenceRow dpw) {
        throw new UnsupportedOperationException("Should not be called on " + this + " which is a " + this.getClass());
    }

    private static class LockElement {
        private Thread thread;
        private boolean movedOn = false;

        LockElement(Thread thread) {
            this.thread = thread;
        }
    }
}

