/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class IndexDefineCommand
extends XaCommand {
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private final Map<String, Byte> indexNameIdRange;
    private final Map<String, Byte> keyIdRange;
    private final Map<Byte, String> idToIndexName;
    private final Map<Byte, String> idToKey;

    public IndexDefineCommand() {
        this.indexNameIdRange = new HashMap<String, Byte>();
        this.keyIdRange = new HashMap<String, Byte>();
        this.idToIndexName = new HashMap<Byte, String>();
        this.idToKey = new HashMap<Byte, String>();
    }

    public IndexDefineCommand(Map<String, Byte> indexNames, Map<String, Byte> keys) {
        this.indexNameIdRange = indexNames;
        this.keyIdRange = keys;
        this.idToIndexName = MapUtil.reverse(indexNames);
        this.idToKey = MapUtil.reverse(keys);
    }

    private static String getFromMap(Map<Byte, String> map, byte id) {
        String result = map.get(id);
        if (result == null) {
            throw new IllegalArgumentException("" + id);
        }
        return result;
    }

    public IndexCommand create(String indexName, Class<?> entityType, Map<String, String> config) {
        return new IndexCommand.CreateCommand(this.indexNameId(indexName), IndexDefineCommand.entityTypeId(entityType), config);
    }

    public IndexCommand add(String indexName, Class<?> entityType, long entityId, String key, Object value) {
        return new IndexCommand.AddCommand(this.indexNameId(indexName), IndexDefineCommand.entityTypeId(entityType), entityId, this.keyId(key), value);
    }

    public IndexCommand addRelationship(String indexName, Class<?> entityType, long entityId, String key, Object value, long startNode, long endNode) {
        return new IndexCommand.AddRelationshipCommand(this.indexNameId(indexName), IndexDefineCommand.entityTypeId(entityType), entityId, this.keyId(key), value, startNode, endNode);
    }

    public IndexCommand remove(String indexName, Class<?> entityType, long entityId, String key, Object value) {
        return new IndexCommand.RemoveCommand(this.indexNameId(indexName), IndexDefineCommand.entityTypeId(entityType), entityId, key != null ? this.keyId(key) : (byte)0, value);
    }

    public IndexCommand delete(String indexName, Class<?> entityType) {
        return new IndexCommand.DeleteCommand(this.indexNameId(indexName), IndexDefineCommand.entityTypeId(entityType));
    }

    public String getIndexName(byte id) {
        return IndexDefineCommand.getFromMap(this.idToIndexName, id);
    }

    public String getKey(byte id) {
        return IndexDefineCommand.getFromMap(this.idToKey, id);
    }

    public static byte entityTypeId(Class<?> entityType) {
        return entityType.equals(Relationship.class) ? (byte)1 : 0;
    }

    public static Class<? extends PropertyContainer> entityType(byte id) {
        switch (id) {
            case 0: {
                return Node.class;
            }
            case 1: {
                return Relationship.class;
            }
        }
        throw new IllegalArgumentException("" + id);
    }

    private byte indexNameId(String indexName) {
        return this.id(indexName, this.indexNameIdRange, this.nextIndexNameId, this.idToIndexName);
    }

    private byte keyId(String key) {
        return this.id(key, this.keyIdRange, this.nextKeyId, this.idToKey);
    }

    private byte id(String key, Map<String, Byte> idRange, AtomicInteger nextId, Map<Byte, String> reverse) {
        Byte id = idRange.get(key);
        if (id == null) {
            id = (byte)nextId.incrementAndGet();
            idRange.put(key, id);
            reverse.put(id, key);
        }
        return id;
    }

    public void writeToFile(LogBuffer buffer) throws IOException {
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        IndexDefineCommand.writeMap(this.indexNameIdRange, buffer);
        IndexDefineCommand.writeMap(this.keyIdRange, buffer);
    }

    static Map<String, Byte> readMap(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        Byte size = IoPrimitiveUtils.readByte(channel, buffer);
        if (size == null) {
            return null;
        }
        HashMap<String, Byte> result = new HashMap<String, Byte>();
        for (int i = 0; i < size; ++i) {
            String key = IoPrimitiveUtils.read2bLengthAndString(channel, buffer);
            Byte id = IoPrimitiveUtils.readByte(channel, buffer);
            if (key == null || id == null) {
                return null;
            }
            result.put(key, id);
        }
        return result;
    }

    private static void writeMap(Map<String, Byte> map, LogBuffer buffer) throws IOException {
        buffer.put((byte)map.size());
        for (Map.Entry<String, Byte> entry : map.entrySet()) {
            IoPrimitiveUtils.write2bLengthAndString(buffer, entry.getKey());
            buffer.put(entry.getValue());
        }
    }

    public int hashCode() {
        int result = this.nextIndexNameId != null ? this.nextIndexNameId.hashCode() : 0;
        result = 31 * result + (this.nextKeyId != null ? this.nextKeyId.hashCode() : 0);
        result = 31 * result + (this.indexNameIdRange != null ? this.indexNameIdRange.hashCode() : 0);
        result = 31 * result + (this.keyIdRange != null ? this.keyIdRange.hashCode() : 0);
        result = 31 * result + (this.idToIndexName != null ? this.idToIndexName.hashCode() : 0);
        result = 31 * result + (this.idToKey != null ? this.idToKey.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        IndexDefineCommand other = (IndexDefineCommand)obj;
        return this.indexNameIdRange.equals(other.indexNameIdRange) && this.keyIdRange.equals(other.keyIdRange);
    }
}

