/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.cache.SizeOfObject;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyChainVerifier;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.util.ArrayMap;

public abstract class Primitive
implements SizeOfObject {
    protected static final DefinedProperty[] NO_PROPERTIES = new DefinedProperty[0];

    Primitive(boolean newPrimitive) {
        if (newPrimitive) {
            this.setEmptyProperties();
        }
    }

    public abstract long getId();

    public Iterator<DefinedProperty> getProperties(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener, PropertyChainVerifier chainVerifier) {
        return this.ensurePropertiesLoaded(loader, updateListener, chainVerifier);
    }

    public Property getProperty(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener, int key, PropertyChainVerifier chainVerifier) {
        this.ensurePropertiesLoaded(loader, updateListener, chainVerifier);
        return this.getCachedProperty(key);
    }

    public PrimitiveLongIterator getPropertyKeys(CacheLoader<Iterator<DefinedProperty>> cacheLoader, CacheUpdateListener updateListener, PropertyChainVerifier chainVerifier) {
        this.ensurePropertiesLoaded(cacheLoader, updateListener, chainVerifier);
        return this.getCachedPropertyKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<DefinedProperty> ensurePropertiesLoaded(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener, PropertyChainVerifier chainVerifier) {
        if (!this.hasLoadedProperties()) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (!this.hasLoadedProperties()) {
                    try {
                        Iterator<DefinedProperty> loadedProperties = loader.load(this.getId());
                        this.setProperties(loadedProperties, chainVerifier);
                        updateListener.newSize(this, this.sizeOfObjectInBytesIncludingOverhead());
                    }
                    catch (EntityNotFoundException | InvalidRecordException e) {
                        throw new NotFoundException(this + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
        return this.getCachedProperties();
    }

    protected abstract Iterator<DefinedProperty> getCachedProperties();

    protected abstract Property getCachedProperty(int var1);

    protected abstract PrimitiveLongIterator getCachedPropertyKeys();

    protected abstract boolean hasLoadedProperties();

    protected abstract void setEmptyProperties();

    protected abstract void setProperties(Iterator<DefinedProperty> var1, PropertyChainVerifier var2);

    protected abstract DefinedProperty getPropertyForIndex(int var1);

    protected abstract void commitPropertyMaps(ArrayMap<Integer, DefinedProperty> var1, ArrayMap<Integer, DefinedProperty> var2, long var3);

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public abstract boolean equals(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePropertiesLoaded(NodeManager nodeManager) {
        if (!this.hasLoadedProperties()) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (!this.hasLoadedProperties()) {
                    try {
                        this.setProperties(this.loadProperties(nodeManager), nodeManager.getPropertyChainVerifier());
                    }
                    catch (InvalidRecordException e) {
                        throw new NotFoundException(this.asProxy(nodeManager) + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
    }

    protected abstract Iterator<DefinedProperty> loadProperties(NodeManager var1);

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        DefinedProperty property;
        this.ensurePropertiesLoaded(nodeManager);
        Token index = nodeManager.getPropertyKeyTokenOrNull(key);
        if (index != null && (property = this.getPropertyForIndex(index.id())) != null) {
            return property.value();
        }
        return null;
    }

    public abstract WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement var1, boolean var2);

    abstract PropertyContainer asProxy(NodeManager var1);
}

