/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;

public class AlreadyConstrainedException
extends SchemaKernelException {
    private static final String NO_CONTEXT_FORMAT = "Already constrained %s.";
    private static final String CONSTRAINT_CONTEXT_FORMAT = "Label '%s' and property '%s' already have a unique constraint defined on them.";
    private static final String INDEX_CONTEXT_FORMAT = "Label '%s' and property '%s' have a unique constraint defined on them, so an index is already created that matches this.";
    private final UniquenessConstraint constraint;
    private final SchemaKernelException.OperationContext context;

    public AlreadyConstrainedException(UniquenessConstraint constraint, SchemaKernelException.OperationContext context) {
        super(Status.Schema.ConstraintAlreadyExists, AlreadyConstrainedException.constructUserMessage(context, null, constraint));
        this.constraint = constraint;
        this.context = context;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, UniquenessConstraint constraint) {
        switch (context) {
            case INDEX_CREATION: {
                return AlreadyConstrainedException.messageWithLabelAndPropertyName(tokenNameLookup, INDEX_CONTEXT_FORMAT, constraint.label(), constraint.propertyKeyId());
            }
            case CONSTRAINT_CREATION: {
                return AlreadyConstrainedException.messageWithLabelAndPropertyName(tokenNameLookup, CONSTRAINT_CONTEXT_FORMAT, constraint.label(), constraint.propertyKeyId());
            }
        }
        return String.format(NO_CONTEXT_FORMAT, constraint);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return AlreadyConstrainedException.constructUserMessage(this.context, tokenNameLookup, this.constraint);
    }
}

