/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.kernel.impl.util.collection.ContinuableArrayCursor;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.IdRangeInput;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.staging.TicketedProcessing;

public class EntityDataGenerator<T>
extends InputIterator.Adapter<T> {
    private final String sourceDescription = ((Object)((Object)this)).getClass().getSimpleName();
    private final TicketedProcessing<IdRangeInput.Range, Void, T[]> processing;
    private long cursor;
    private final ContinuableArrayCursor<T> itemCursor;

    public EntityDataGenerator(Function<IdRangeInput.Range, T[]> generator, long count) {
        BiFunction<IdRangeInput.Range, Void, Object[]> processor = (batch, ignore) -> (Object[])generator.apply((IdRangeInput.Range)batch);
        this.processing = new TicketedProcessing(((Object)((Object)this)).getClass().getName(), Runtime.getRuntime().availableProcessors(), processor, () -> null);
        this.processing.slurp(IdRangeInput.idRangeInput((long)count, (int)Configuration.DEFAULT.batchSize()), true);
        this.itemCursor = new ContinuableArrayCursor(() -> this.processing.next());
    }

    protected T fetchNextOrNull() {
        if (this.itemCursor.next()) {
            ++this.cursor;
            return (T)this.itemCursor.get();
        }
        return null;
    }

    public String sourceDescription() {
        return this.sourceDescription;
    }

    public long lineNumber() {
        return this.cursor;
    }

    public long position() {
        return 0L;
    }

    public void close() {
        super.close();
        this.processing.close();
    }

    public int processors(int delta) {
        return this.processing.processors(delta);
    }
}

