/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.token.api.TokenHolder;

public class LuceneFulltextIndex
extends AbstractLuceneIndex<FulltextIndexReader>
implements Closeable {
    private final Analyzer analyzer;
    private final String identifier;
    private final EntityType type;
    private final TokenHolder propertyKeyTokenHolder;
    private final String[] propertyNames;
    private final File transactionsFolder;
    private final IndexDescriptor descriptor;

    LuceneFulltextIndex(PartitionedIndexStorage storage, IndexPartitionFactory partitionFactory, IndexDescriptor descriptor, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames) {
        super(storage, partitionFactory, descriptor);
        this.descriptor = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.identifier = descriptor.getName();
        this.type = descriptor.schema().entityType();
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        File indexFolder = storage.getIndexFolder();
        this.transactionsFolder = new File(indexFolder, indexFolder.getName() + ".tx");
    }

    public void open() throws IOException {
        super.open();
        this.indexStorage.prepareFolder(this.transactionsFolder);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.indexStorage.cleanupFolder(this.transactionsFolder);
    }

    public String toString() {
        return "LuceneFulltextIndex{analyzer=" + this.analyzer.getClass().getSimpleName() + ", identifier='" + this.identifier + "', type=" + this.type + ", descriptor=" + this.descriptor.userDescription(TokenNameLookup.idTokenNameLookup) + "}";
    }

    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected FulltextIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        return this.createPartitionedReader((List)partitions);
    }

    protected FulltextIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List searchers = LuceneFulltextIndex.acquireSearchers(partitions);
        return new FulltextIndexReader(searchers, this.propertyKeyTokenHolder, this.getDescriptor(), this.analyzer, this.propertyNames);
    }
}

