/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.neo4j.annotations.service.Service;
import org.neo4j.service.NamedService;

@Service
public abstract class AnalyzerProvider
implements NamedService {
    private final String name;

    protected AnalyzerProvider(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public abstract Analyzer createAnalyzer();

    public String description() {
        return "";
    }

    public List<String> stopwords() {
        Analyzer analyzer = this.createAnalyzer();
        if (analyzer instanceof StopwordAnalyzerBase) {
            StopwordAnalyzerBase stopwordAnalyzer = (StopwordAnalyzerBase)analyzer;
            CharArraySet stopwords = stopwordAnalyzer.getStopwordSet();
            return stopwords.stream().map(obj -> new String((char[])obj)).collect(Collectors.toList());
        }
        return List.of();
    }

    public static CharArraySet cleanStopWordSet(CharArraySet stopSet) {
        CharArraySet result = new CharArraySet(stopSet.size(), false);
        stopSet.stream().map(cs -> new String((char[])cs).trim()).filter(s -> !s.isBlank() && !s.contains("#") && !s.contains(" ")).forEach(arg_0 -> ((CharArraySet)result).add(arg_0));
        return result;
    }
}

