/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.result;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;

public class JSONSerializer {
    private ObjectMapper mapper = new ObjectMapper();

    public ArrayNode toJSON(Iterable<Map<String, Object>> result) {
        ArrayNode root = this.mapper.createArrayNode();
        for (Map<String, Object> stringObjectMap : result) {
            ObjectNode entry = root.objectNode();
            for (Map.Entry<String, Object> stringObjectEntry : stringObjectMap.entrySet()) {
                if (stringObjectEntry.getValue() instanceof Path) {
                    entry.put(stringObjectEntry.getKey(), stringObjectEntry.getValue().toString());
                    continue;
                }
                if (stringObjectEntry.getValue() instanceof Node) {
                    Node node = (Node)stringObjectEntry.getValue();
                    ObjectNode nodeNode = entry.objectNode();
                    nodeNode.put("_id", node.getId());
                    for (String propertyName : node.getPropertyKeys()) {
                        this.addProperty(nodeNode, propertyName, node.getProperty(propertyName));
                    }
                    entry.put(stringObjectEntry.getKey(), (JsonNode)nodeNode);
                    continue;
                }
                this.addProperty(entry, stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
            root.add((JsonNode)entry);
        }
        return root;
    }

    private void addProperty(ObjectNode node, String name, Object value) {
        if (value instanceof String) {
            node.put(name, value.toString());
        } else if (value instanceof Long) {
            Long number = (Long)value;
            node.put(name, number);
        } else if (value instanceof Integer) {
            Integer number = (Integer)value;
            node.put(name, number);
        } else {
            throw new IllegalArgumentException("Unknown value type:" + value.getClass());
        }
    }
}

