/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Direction;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.Query;

public abstract class MatchExpression
implements AsString,
Serializable,
Cloneable {
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class FunctionPath<T extends FunctionPath>
    extends MatchExpression {
        public Identifier pathName;
        public String function;
        public Identifier from;
        public Identifier to;
        public Direction direction = Direction.BOTH;
        public Integer minHops;
        public Integer maxHops;

        public T out() {
            this.direction = Direction.OUT;
            return (T)this;
        }

        public T in() {
            this.direction = Direction.IN;
            return (T)this;
        }

        public T both() {
            this.direction = Direction.BOTH;
            return (T)this;
        }

        public T from(String from) {
            return this.from(CypherQuery.identifier(from));
        }

        public T from(Identifier from) {
            Query.checkNull(from, "From");
            this.from = from;
            return (T)this;
        }

        public T to(String to) {
            return this.to(CypherQuery.identifier(to));
        }

        public T to(Identifier to) {
            Query.checkNull(to, "To");
            this.to = to;
            return (T)this;
        }

        public T hops(Integer minHops, Integer maxHops) {
            if (minHops != null && minHops < 0) {
                throw new IllegalArgumentException("Minimum number of hops must be over zero");
            }
            if (maxHops != null && maxHops < 0) {
                throw new IllegalArgumentException("Maximum number of hops must be over zero");
            }
            this.minHops = minHops;
            this.maxHops = maxHops;
            return (T)this;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.pathName.asString(builder);
            builder.append("=");
            builder.append(this.function).append('(');
            builder.append('(');
            if (this.from != null) {
                this.from.asString(builder);
            }
            builder.append(')');
            builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
            if (this.minHops != null || this.maxHops != null) {
                builder.append('[');
                if (this.minHops != null || this.maxHops != null) {
                    builder.append('*');
                    if (this.minHops != null) {
                        builder.append(this.minHops);
                    }
                    builder.append("..");
                    if (this.maxHops != null) {
                        builder.append(this.maxHops);
                    }
                }
                builder.append(']');
            }
            builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
            builder.append('(');
            if (this.to != null) {
                this.to.asString(builder);
            }
            builder.append(')');
            builder.append(')');
        }
    }

    public static class Link<T extends Link>
    extends AbstractPath<T> {
        public AbstractPath leftPath;

        @Override
        public void asString(StringBuilder builder) {
            this.leftPath.asString(builder);
            super.asString(builder);
        }
    }

    public static class Path<T extends Path>
    extends AbstractPath<T> {
        public Identifier pathName;
        public Identifier from;

        @Override
        public void asString(StringBuilder builder) {
            if (this.pathName != null) {
                this.pathName.asString(builder);
                builder.append('=');
            }
            builder.append('(');
            if (this.from != null) {
                this.from.asString(builder);
            }
            builder.append(')');
            super.asString(builder);
        }

        public T from(String from) {
            return this.from(CypherQuery.identifier(from));
        }

        public T from(Identifier from) {
            Query.checkNull(from, "From");
            this.from = from;
            return (T)this;
        }
    }

    public static class AbstractPath<T extends AbstractPath>
    extends MatchExpression {
        public Identifier to;
        public Direction direction = Direction.BOTH;
        public Identifier as;
        public Expression[] relationships = new Expression[0];
        public boolean optional;
        public Integer minHops;
        public Integer maxHops;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
            if (this.as != null || this.relationships.length > 0 || this.optional || this.minHops != null || this.maxHops != null) {
                builder.append('[');
                if (this.as != null) {
                    this.as.asString(builder);
                }
                if (this.optional) {
                    builder.append('?');
                }
                if (this.relationships.length > 0) {
                    builder.append(':');
                    for (int i = 0; i < this.relationships.length; ++i) {
                        if (i > 0) {
                            builder.append("|");
                        }
                        this.relationships[i].asString(builder);
                    }
                }
                if (this.minHops != null || this.maxHops != null) {
                    builder.append('*');
                    if (this.minHops != null) {
                        builder.append(this.minHops);
                    }
                    builder.append("..");
                    if (this.maxHops != null) {
                        builder.append(this.maxHops);
                    }
                }
                builder.append(']');
            }
            builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
            builder.append('(');
            if (this.to != null) {
                this.to.asString(builder);
            }
            builder.append(')');
        }

        public T out(String ... relationship) {
            this.direction = Direction.OUT;
            this.relationships = CypherQuery.identifiers(relationship);
            return (T)this;
        }

        public T in(String ... relationship) {
            this.direction = Direction.IN;
            this.relationships = CypherQuery.identifiers(relationship);
            return (T)this;
        }

        public T both(String ... relationship) {
            this.direction = Direction.BOTH;
            this.relationships = CypherQuery.identifiers(relationship);
            return (T)this;
        }

        public T as(String name) {
            return this.as(CypherQuery.identifier(name));
        }

        public T as(Identifier name) {
            Query.checkNull(name, "Name");
            this.as = name;
            return (T)this;
        }

        public T optional() {
            this.optional = true;
            return (T)this;
        }

        public T hops(Integer minHops, Integer maxHops) {
            if (minHops != null && minHops < 0) {
                throw new IllegalArgumentException("Minimum number of hops must be over zero");
            }
            if (maxHops != null && maxHops < 0) {
                throw new IllegalArgumentException("Maximum number of hops must be over zero");
            }
            this.minHops = minHops;
            this.maxHops = maxHops;
            return (T)this;
        }

        public T to(String to) {
            return this.to(CypherQuery.identifier(to));
        }

        public T to(Identifier to) {
            Query.checkNull(to, "To");
            this.to = to;
            return (T)this;
        }

        public Link link() {
            Link link = new Link();
            link.leftPath = this;
            return link;
        }
    }
}

