/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypherdsl.Execute;
import org.neo4j.cypherdsl.ExecuteWithParameters;
import org.neo4j.cypherdsl.Limit;
import org.neo4j.cypherdsl.Match;
import org.neo4j.cypherdsl.OrderBy;
import org.neo4j.cypherdsl.ReturnNext;
import org.neo4j.cypherdsl.Skip;
import org.neo4j.cypherdsl.Where;
import org.neo4j.cypherdsl.query.BinaryPredicateExpression;
import org.neo4j.cypherdsl.query.BooleanExpression;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.FunctionExpression;
import org.neo4j.cypherdsl.query.Has;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.IsNotNull;
import org.neo4j.cypherdsl.query.IsNull;
import org.neo4j.cypherdsl.query.IterablePredicateExpression;
import org.neo4j.cypherdsl.query.Literal;
import org.neo4j.cypherdsl.query.MatchExpression;
import org.neo4j.cypherdsl.query.NumberProperty;
import org.neo4j.cypherdsl.query.Order;
import org.neo4j.cypherdsl.query.OrderByExpression;
import org.neo4j.cypherdsl.query.Parameter;
import org.neo4j.cypherdsl.query.PredicateExpression;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.Regexp;
import org.neo4j.cypherdsl.query.ReturnExpression;
import org.neo4j.cypherdsl.query.StartExpression;
import org.neo4j.cypherdsl.query.StringProperty;
import org.neo4j.cypherdsl.query.WhereExpression;

public class CypherQuery {
    protected Query query;

    public static Match start(StartExpression ... startExpressions) {
        CypherQuery query = new CypherQuery();
        return query.starts(startExpressions);
    }

    public static CypherQuery newQuery(Query query) {
        return new CypherQuery(query);
    }

    public CypherQuery() {
        this.query = new Query();
    }

    private CypherQuery(Query query) {
        try {
            this.query = (Query)query.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Query was not cloneable");
        }
    }

    public static Parameter param(String name) {
        Query.checkEmpty(name, "Name");
        Parameter parameter = new Parameter();
        parameter.name = name;
        return parameter;
    }

    public static Literal literal(Object value) {
        Query.checkNull(value, "Value");
        Literal literal = new Literal();
        literal.value = value;
        return literal;
    }

    public static Identifier identifier(String name) {
        Query.checkEmpty(name, "Identifier");
        Identifier identifier = new Identifier();
        identifier.name = name;
        return identifier;
    }

    public static StringProperty string(String name) {
        Query.checkEmpty(name, "Name");
        StringProperty property = new StringProperty();
        property.name = CypherQuery.identifier(name);
        return property;
    }

    public static NumberProperty number(String name) {
        Query.checkEmpty(name, "Name");
        NumberProperty property = new NumberProperty();
        property.name = CypherQuery.identifier(name);
        return property;
    }

    public static Literal[] literals(Object ... values) {
        Literal[] literals = new Literal[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            literals[i] = CypherQuery.literal(value);
        }
        return literals;
    }

    public static Identifier[] identifiers(String ... values) {
        Identifier[] identifiers = new Identifier[values.length];
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            identifiers[i] = CypherQuery.identifier(value);
        }
        return identifiers;
    }

    public static Parameter[] parameters(String ... names) {
        Parameter[] parameters = new Parameter[names.length];
        for (int i = 0; i < names.length; ++i) {
            String value = names[i];
            parameters[i] = CypherQuery.param(value);
        }
        return parameters;
    }

    public static Literal[] literals(long ... values) {
        Literal[] literals = new Literal[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long value = values[i];
            literals[i] = CypherQuery.literal(value);
        }
        return literals;
    }

    public static BooleanExpression.And and(PredicateExpression ... expressions) {
        Query.checkNull(expressions, "Expressions");
        BooleanExpression.And and = new BooleanExpression.And();
        and.expressions = expressions;
        return and;
    }

    public static BooleanExpression.Or or(PredicateExpression ... expressions) {
        Query.checkNull(expressions, "Expressions");
        BooleanExpression.Or or = new BooleanExpression.Or();
        or.expressions = expressions;
        return or;
    }

    public static BooleanExpression.Not not(PredicateExpression expression) {
        Query.checkNull(expression, "Expression");
        BooleanExpression.Not not = new BooleanExpression.Not();
        not.expression = expression;
        return not;
    }

    public static BinaryPredicateExpression eq(Object left, Object right) {
        return CypherQuery.binaryPredicate("=", left, right);
    }

    public static BinaryPredicateExpression gt(Object left, Object right) {
        return CypherQuery.binaryPredicate(">", left, right);
    }

    public static BinaryPredicateExpression lt(Object left, Object right) {
        return CypherQuery.binaryPredicate("<", left, right);
    }

    public static BinaryPredicateExpression gte(Object left, Object right) {
        return CypherQuery.binaryPredicate(">=", left, right);
    }

    public static BinaryPredicateExpression lte(Object left, Object right) {
        return CypherQuery.binaryPredicate(">=", left, right);
    }

    public static BinaryPredicateExpression ne(Object left, Object right) {
        return CypherQuery.binaryPredicate("<>", left, right);
    }

    private static BinaryPredicateExpression binaryPredicate(String operator, Object left, Object right) {
        Query.checkNull(left, "Left expression");
        Query.checkNull(right, "Right expression");
        BinaryPredicateExpression binaryPredicateExpression = new BinaryPredicateExpression();
        binaryPredicateExpression.operator = operator;
        binaryPredicateExpression.left = left instanceof Expression ? (Expression)left : CypherQuery.literal(left);
        binaryPredicateExpression.right = right instanceof Expression ? (Expression)right : CypherQuery.literal(right);
        return binaryPredicateExpression;
    }

    public static Regexp regexp(Expression property, Expression regexp) {
        return CypherQuery.regexp(property, regexp, true);
    }

    public static Regexp regexp(Expression property, Expression regexp, boolean caseSensitive) {
        Regexp regularExpression = new Regexp();
        regularExpression.caseSensitive = caseSensitive;
        regularExpression.left = property;
        regularExpression.regexp = regexp;
        return regularExpression;
    }

    public Has has(Expression expression) {
        Has has = new Has();
        has.expression = expression;
        return has;
    }

    public IsNull isNull(Expression expression) {
        IsNull isNull = new IsNull();
        isNull.expression = expression;
        return isNull;
    }

    public IsNotNull isNotNull(Expression expression) {
        IsNotNull isNotNull = new IsNotNull();
        isNotNull.expression = expression;
        return isNotNull;
    }

    protected Match starts(StartExpression ... startExpression) {
        Collections.addAll(this.query.startExpressions, startExpression);
        return new Grammar();
    }

    protected Match starts(Iterable<StartExpression> startExpression) {
        for (StartExpression expression : startExpression) {
            this.query.startExpressions.add(expression);
        }
        return new Grammar();
    }

    public static StartExpression.StartNodes node(String name, long ... id) {
        return CypherQuery.node(CypherQuery.identifier(name), id);
    }

    public static StartExpression.StartNodes node(Identifier name, long ... id) {
        Query.checkNull(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        StartExpression.StartNodes startNodes = new StartExpression.StartNodes();
        startNodes.name = name;
        startNodes.nodes = CypherQuery.literals(id);
        return startNodes;
    }

    public static StartExpression.StartNodes node(String name, String parameter) {
        return CypherQuery.node(CypherQuery.identifier(name), parameter);
    }

    public static StartExpression.StartNodes node(Identifier name, String parameter) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(parameter, "Parameters");
        StartExpression.StartNodes startNodes = new StartExpression.StartNodes();
        startNodes.name = name;
        startNodes.nodes = CypherQuery.parameters(parameter);
        return startNodes;
    }

    public static StartExpression.StartNodes allNodes(String name) {
        return CypherQuery.allNodes(CypherQuery.identifier(name));
    }

    public static StartExpression.StartNodes allNodes(Identifier name) {
        Query.checkNull(name, "Name");
        StartExpression.StartNodes startNodes = new StartExpression.StartNodes();
        startNodes.name = name;
        startNodes.nodes = new Expression[]{new StartExpression.AllNodes()};
        return startNodes;
    }

    public static StartExpression.StartNodesLookup lookup(String name, String indexName, String key, String value) {
        return CypherQuery.lookup(CypherQuery.identifier(name), CypherQuery.identifier(indexName), CypherQuery.identifier(key), CypherQuery.literal(value));
    }

    public static StartExpression.StartNodesLookup lookup(Identifier name, Identifier indexName, Identifier key, Literal value) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(indexName, "Index");
        StartExpression.StartNodesLookup startNodesLookup = new StartExpression.StartNodesLookup();
        startNodesLookup.name = name;
        startNodesLookup.index = indexName;
        startNodesLookup.key = key;
        startNodesLookup.value = value;
        return startNodesLookup;
    }

    public static StartExpression.StartNodesQuery query(String name, String indexName, String query) {
        return CypherQuery.query(CypherQuery.identifier(name), CypherQuery.identifier(indexName), query);
    }

    public static StartExpression.StartNodesQuery query(Identifier name, Identifier indexName, String query) {
        Query.checkNull(name, "Name");
        Query.checkNull(indexName, "Index");
        Query.checkEmpty(query, "Query");
        StartExpression.StartNodesQuery startNodesQuery = new StartExpression.StartNodesQuery();
        startNodesQuery.name = name;
        startNodesQuery.index = indexName;
        startNodesQuery.query = query;
        return startNodesQuery;
    }

    public static StartExpression.StartRelationships relationship(String name, long ... id) {
        return CypherQuery.relationship(CypherQuery.identifier(name), id);
    }

    public static StartExpression.StartRelationships relationship(Identifier name, long ... id) {
        Query.checkNull(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        StartExpression.StartRelationships startRelationships = new StartExpression.StartRelationships();
        startRelationships.name = name;
        startRelationships.relationships = CypherQuery.literals(id);
        return startRelationships;
    }

    public static StartExpression.StartRelationshipsParameters relationship(String name, String parameter) {
        return CypherQuery.relationship(CypherQuery.identifier(name), parameter);
    }

    public static StartExpression.StartRelationshipsParameters relationship(Identifier name, String parameter) {
        Query.checkNull(name, "Name");
        Query.checkEmpty(parameter, "Parameter");
        StartExpression.StartRelationshipsParameters startRelationships = new StartExpression.StartRelationshipsParameters();
        startRelationships.name = name;
        startRelationships.parameter = parameter;
        return startRelationships;
    }

    public static StartExpression.StartRelationshipsIndex relationshipLookup(String name, String indexName, String key, String value) {
        return CypherQuery.relationshipLookup(CypherQuery.identifier(name), CypherQuery.identifier(indexName), CypherQuery.identifier(key), CypherQuery.literal(value));
    }

    public static StartExpression.StartRelationshipsIndex relationshipLookup(Identifier name, Identifier indexName, Identifier key, Literal value) {
        Query.checkNull(name, "Name");
        Query.checkNull(indexName, "Index");
        Query.checkNull(key, "Key");
        Query.checkNull(value, "Value");
        StartExpression.StartRelationshipsIndex startRelationshipsIndex = new StartExpression.StartRelationshipsIndex();
        startRelationshipsIndex.name = name;
        startRelationshipsIndex.index = indexName;
        startRelationshipsIndex.key = key;
        startRelationshipsIndex.value = value;
        return startRelationshipsIndex;
    }

    public static MatchExpression.Path path() {
        return new MatchExpression.Path();
    }

    public static MatchExpression.Path path(String name) {
        return CypherQuery.path(CypherQuery.identifier(name));
    }

    public static MatchExpression.Path path(Identifier name) {
        Query.checkNull(name, "Name");
        MatchExpression.Path path = new MatchExpression.Path();
        path.pathName = name;
        return path;
    }

    public static MatchExpression.FunctionPath shortestPath(String name) {
        return CypherQuery.shortestPath(CypherQuery.identifier(name));
    }

    public static MatchExpression.FunctionPath shortestPath(Identifier name) {
        Query.checkNull(name, "Name");
        MatchExpression.FunctionPath functionPath = new MatchExpression.FunctionPath();
        functionPath.function = "shortestPath";
        functionPath.pathName = name;
        return functionPath;
    }

    public static MatchExpression.FunctionPath allShortestPaths(String name) {
        return CypherQuery.allShortestPaths(CypherQuery.identifier(name));
    }

    public static MatchExpression.FunctionPath allShortestPaths(Identifier name) {
        Query.checkNull(name, "Name");
        MatchExpression.FunctionPath functionPath = new MatchExpression.FunctionPath();
        functionPath.function = "allShortestPaths";
        functionPath.pathName = name;
        return functionPath;
    }

    public static WhereExpression.WhereRelationship relationship() {
        return new WhereExpression.WhereRelationship();
    }

    public static WhereExpression.WhereIn in(Expression expression, Expression ... elements) {
        Query.checkNull(expression, "Expression");
        WhereExpression.WhereIn in = new WhereExpression.WhereIn();
        in.expression = expression;
        in.elements = elements;
        return in;
    }

    public static ReturnExpression<ReturnExpression> exp(Expression expression) {
        ReturnExpression<ReturnExpression> returnExpression = new ReturnExpression<ReturnExpression>();
        returnExpression.expression = expression;
        return returnExpression;
    }

    public static ReturnExpression.ReturnAggregate count() {
        ReturnExpression.ReturnAggregate returnAggregate = new ReturnExpression.ReturnAggregate();
        returnAggregate.function = "count";
        return returnAggregate;
    }

    public static FunctionExpression count(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "count";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static FunctionExpression sum(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "sum";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static FunctionExpression avg(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "avg";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static FunctionExpression max(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "max";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static FunctionExpression min(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "min";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static FunctionExpression collect(Expression expression) {
        Query.checkNull(expression, "Expression");
        FunctionExpression returnAggregate = new FunctionExpression();
        returnAggregate.name = "collect";
        returnAggregate.expression = expression;
        return returnAggregate;
    }

    public static OrderByExpression order(Expression expression) {
        Query.checkNull(expression, "Expression");
        OrderByExpression orderBy = new OrderByExpression();
        orderBy.expression = expression;
        return orderBy;
    }

    public static OrderByExpression order(Expression expression, Order order) {
        Query.checkNull(expression, "Name");
        Query.checkNull((Object)order, "Order");
        OrderByExpression orderBy = new OrderByExpression();
        orderBy.expression = expression;
        orderBy.order = order;
        return orderBy;
    }

    public static IterablePredicateExpression all(String name, Expression iterable, PredicateExpression predicateExpression) {
        return CypherQuery.all(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static IterablePredicateExpression all(Identifier name, Expression iterable, PredicateExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        IterablePredicateExpression expression = new IterablePredicateExpression();
        expression.function = "all";
        expression.name = name;
        expression.iterable = iterable;
        expression.predicate = predicateExpression;
        return expression;
    }

    public static IterablePredicateExpression any(String name, Expression iterable, PredicateExpression predicateExpression) {
        return CypherQuery.any(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static IterablePredicateExpression any(Identifier name, Expression iterable, PredicateExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        IterablePredicateExpression expression = new IterablePredicateExpression();
        expression.function = "any";
        expression.name = name;
        expression.iterable = iterable;
        expression.predicate = predicateExpression;
        return expression;
    }

    public static IterablePredicateExpression none(String name, Expression iterable, PredicateExpression predicateExpression) {
        return CypherQuery.none(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static IterablePredicateExpression none(Identifier name, Expression iterable, PredicateExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        IterablePredicateExpression expression = new IterablePredicateExpression();
        expression.function = "none";
        expression.name = name;
        expression.iterable = iterable;
        expression.predicate = predicateExpression;
        return expression;
    }

    public static IterablePredicateExpression single(String name, Expression iterable, PredicateExpression predicateExpression) {
        return CypherQuery.single(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static IterablePredicateExpression single(Identifier name, Expression iterable, PredicateExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        IterablePredicateExpression expression = new IterablePredicateExpression();
        expression.function = "single";
        expression.name = name;
        expression.iterable = iterable;
        expression.predicate = predicateExpression;
        return expression;
    }

    public static FunctionExpression length(Expression iterableExpression) {
        Query.checkNull(iterableExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "length";
        function.expression = iterableExpression;
        return function;
    }

    public static FunctionExpression type(Expression relationshipExpression) {
        Query.checkNull(relationshipExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "type";
        function.expression = relationshipExpression;
        return function;
    }

    public static FunctionExpression id(Expression propertyContainerExpression) {
        Query.checkNull(propertyContainerExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "id";
        function.expression = propertyContainerExpression;
        return function;
    }

    public static FunctionExpression coalesce(Expression ... expressions) {
        if (expressions.length < 1) {
            throw new IllegalArgumentException("At least one expression must be provided to coalesce function");
        }
        FunctionExpression coalesce = new FunctionExpression();
        coalesce.name = "coalesce";
        FunctionExpression.Expressions expressions1 = new FunctionExpression.Expressions();
        expressions1.expressions = expressions;
        coalesce.expression = expressions1;
        return coalesce;
    }

    public static FunctionExpression head(Expression collectionExpression) {
        Query.checkNull(collectionExpression, "Expression");
        FunctionExpression head = new FunctionExpression();
        head.name = "head";
        head.expression = collectionExpression;
        return head;
    }

    public static FunctionExpression last(Expression collectionExpression) {
        Query.checkNull(collectionExpression, "Expression");
        FunctionExpression last = new FunctionExpression();
        last.name = "last";
        last.expression = collectionExpression;
        return last;
    }

    public static FunctionExpression nodes(Expression pathExpression) {
        Query.checkNull(pathExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "nodes";
        function.expression = pathExpression;
        return function;
    }

    public static FunctionExpression relationships(Expression pathExpression) {
        Query.checkNull(pathExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "relationships";
        function.expression = pathExpression;
        return function;
    }

    public static FunctionExpression tail(Expression pathExpression) {
        Query.checkNull(pathExpression, "Expression");
        FunctionExpression function = new FunctionExpression();
        function.name = "tail";
        function.expression = pathExpression;
        return function;
    }

    public static FunctionExpression.Extract extract(String name, Expression iterable, Expression expression) {
        return CypherQuery.extract(CypherQuery.identifier(name), iterable, expression);
    }

    public static FunctionExpression.Extract extract(Identifier name, Expression iterable, Expression expression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(expression, "Expression");
        FunctionExpression.Extract extract = new FunctionExpression.Extract();
        extract.name = name;
        extract.iterable = iterable;
        extract.expression = expression;
        return extract;
    }

    public static FunctionExpression.Filter filter(String name, Expression iterable, PredicateExpression predicateExpression) {
        return CypherQuery.filter(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static FunctionExpression.Filter filter(Identifier name, Expression iterable, PredicateExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        FunctionExpression.Filter filter = new FunctionExpression.Filter();
        filter.name = name;
        filter.iterable = iterable;
        filter.predicate = predicateExpression;
        return filter;
    }

    public static FunctionExpression abs(Expression numericalExpression) {
        FunctionExpression function = new FunctionExpression();
        function.name = "abs";
        function.expression = numericalExpression;
        return function;
    }

    public static FunctionExpression round(Expression numericalExpression) {
        FunctionExpression function = new FunctionExpression();
        function.name = "round";
        function.expression = numericalExpression;
        return function;
    }

    public static FunctionExpression sqrt(Expression numericalExpression) {
        FunctionExpression function = new FunctionExpression();
        function.name = "sqrt";
        function.expression = numericalExpression;
        return function;
    }

    public static FunctionExpression sign(Expression numericalExpression) {
        FunctionExpression function = new FunctionExpression();
        function.name = "sign";
        function.expression = numericalExpression;
        return function;
    }

    public String toString() {
        return this.query.toString();
    }

    protected class ExecuteWithParams
    implements ExecuteWithParameters {
        private Query query;
        private Map<String, Object> parameters = new HashMap<String, Object>();

        public ExecuteWithParams(Query query) {
            this.query = query;
        }

        @Override
        public Query toQuery() {
            return this.query;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.query.asString(builder);
        }

        public String toString() {
            return this.query.toString();
        }
    }

    protected class Grammar
    implements Match,
    ReturnNext,
    OrderBy,
    Skip,
    Limit,
    Execute {
        protected Grammar() {
        }

        @Override
        public Match match(MatchExpression ... expression) {
            Collections.addAll(CypherQuery.this.query.matchExpressions, expression);
            return this;
        }

        @Override
        public Match match(Iterable<MatchExpression> expressions) {
            for (MatchExpression expression : expressions) {
                CypherQuery.this.query.matchExpressions.add(expression);
            }
            return this;
        }

        @Override
        public Where where(PredicateExpression expression) {
            Query.checkNull(expression, "Expression");
            CypherQuery.this.query.whereExpressions.add(expression);
            return this;
        }

        @Override
        public ReturnNext returns(Expression ... returnExpressions) {
            for (Expression expression : returnExpressions) {
                if (expression instanceof ReturnExpression) {
                    CypherQuery.this.query.returnExpressions.add((ReturnExpression)expression);
                    continue;
                }
                CypherQuery.this.query.returnExpressions.add(CypherQuery.exp(expression));
            }
            return this;
        }

        @Override
        public ReturnNext returns(Iterable<Expression> returnExpressions) {
            for (Expression expression : returnExpressions) {
                if (expression instanceof ReturnExpression) {
                    CypherQuery.this.query.returnExpressions.add((ReturnExpression)expression);
                    continue;
                }
                CypherQuery.this.query.returnExpressions.add(CypherQuery.exp(expression));
            }
            return this;
        }

        @Override
        public OrderBy orderBy(Expression ... orderByExpressions) {
            for (Expression byExpression : orderByExpressions) {
                if (byExpression instanceof OrderByExpression) {
                    CypherQuery.this.query.orderByExpressions.add((OrderByExpression)byExpression);
                    continue;
                }
                CypherQuery.this.query.orderByExpressions.add(CypherQuery.order(byExpression));
            }
            return this;
        }

        @Override
        public OrderBy orderBy(Iterable<Expression> orderByExpressions) {
            for (Expression byExpression : orderByExpressions) {
                if (byExpression instanceof OrderByExpression) {
                    CypherQuery.this.query.orderByExpressions.add((OrderByExpression)byExpression);
                    continue;
                }
                CypherQuery.this.query.orderByExpressions.add(CypherQuery.order(byExpression));
            }
            return this;
        }

        @Override
        public Limit skip(int skip) {
            if (skip < 0) {
                throw new IllegalArgumentException("Skip may not be below zero");
            }
            CypherQuery.this.query.skip = skip;
            return this;
        }

        @Override
        public Execute limit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("Limit may not be below zero");
            }
            CypherQuery.this.query.limit = limit;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            CypherQuery.this.query.asString(builder);
        }

        @Override
        public Query toQuery() {
            return CypherQuery.this.query;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            ExecuteWithParams withParams = new ExecuteWithParams(CypherQuery.this.query);
            return withParams.parameter(name, value);
        }

        public String toString() {
            return CypherQuery.this.toString();
        }
    }
}

