/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.query.AsString;

public class Expression {
    public static Parameter param(String name) {
        Parameter parameter = new Parameter();
        parameter.name = name;
        return parameter;
    }

    public static Literal literal(Object value) {
        Literal literal = new Literal();
        literal.value = value;
        return literal;
    }

    public static Identifier identifier(String name) {
        Identifier identifier = new Identifier();
        identifier.name = name;
        return identifier;
    }

    public static Literal[] literals(Object[] values) {
        Literal[] literals = new Literal[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            Literal literal = new Literal();
            literal.value = value;
            literals[i] = literal;
        }
        return literals;
    }

    public static Parameter[] parameters(String[] names) {
        Parameter[] parameters = new Parameter[names.length];
        for (int i = 0; i < names.length; ++i) {
            String value = names[i];
            Parameter parameter = new Parameter();
            parameter.name = value;
            parameters[i] = parameter;
        }
        return parameters;
    }

    public static Literal[] literals(long[] values) {
        Literal[] literals = new Literal[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long value = values[i];
            Literal literal = new Literal();
            literal.value = value;
            literals[i] = literal;
        }
        return literals;
    }

    public static class Identifier
    implements AsString {
        String name;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name);
        }
    }

    public static class Literal
    extends Value {
        public Object value;

        @Override
        public void asString(StringBuilder builder) {
            if (this.value instanceof String) {
                builder.append("\"").append(this.value.toString()).append("\"");
            } else {
                builder.append(this.value.toString());
            }
        }
    }

    public static class Parameter
    extends Value {
        public String name;

        @Override
        public void asString(StringBuilder builder) {
            builder.append('{').append(this.name).append('}');
        }
    }

    public static abstract class Value
    implements AsString {
    }
}

