/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDateTime;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonJavaScript;
import org.mongodb.kbson.BsonJavaScriptWithScope;
import org.mongodb.kbson.BsonMaxKey;
import org.mongodb.kbson.BsonMinKey;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonNumber;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonSymbol;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonUndefined;
import org.mongodb.kbson.serialization.Bson;
import org.mongodb.kbson.serialization.BsonValueSerializer;

@Serializable(with=BsonValueSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b7\u0018\u0000 O2\u00020\u0001:\u0001OB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204J\u0006\u00106\u001a\u000204J\u0006\u00107\u001a\u000204J\u0006\u00108\u001a\u000204J\u0006\u00109\u001a\u000204J\u0006\u0010:\u001a\u000204J\u0006\u0010;\u001a\u000204J\u0006\u0010<\u001a\u000204J\u0006\u0010=\u001a\u000204J\u0006\u0010>\u001a\u000204J\u0006\u0010?\u001a\u000204J\u0006\u0010@\u001a\u000204J\u0006\u0010A\u001a\u000204J\u0006\u0010B\u001a\u000204J\u0006\u0010C\u001a\u000204J\u0006\u0010D\u001a\u000204J\u0006\u0010E\u001a\u000204J\u0006\u0010F\u001a\u000204J\u0006\u0010G\u001a\u000204J\u0006\u0010H\u001a\u000204J\u0006\u0010I\u001a\u000204J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u0004H\u0002J\u0006\u0010M\u001a\u00020NR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0013\b\n\f\u0016\u0018\u001a\u001c$&\u000e\u0010\u0012(*,.02\u0014\u00a8\u0006P"}, d2={"Lorg/mongodb/kbson/BsonValue;", "", "()V", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "asArray", "Lorg/mongodb/kbson/BsonArray;", "asBinary", "Lorg/mongodb/kbson/BsonBinary;", "asBoolean", "Lorg/mongodb/kbson/BsonBoolean;", "asBsonMaxKey", "Lorg/mongodb/kbson/BsonMaxKey;", "asBsonMinKey", "Lorg/mongodb/kbson/BsonMinKey;", "asBsonNull", "Lorg/mongodb/kbson/BsonNull;", "asBsonUndefined", "Lorg/mongodb/kbson/BsonUndefined;", "asDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "asDateTime", "Lorg/mongodb/kbson/BsonDateTime;", "asDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "asDocument", "Lorg/mongodb/kbson/BsonDocument;", "asDouble", "Lorg/mongodb/kbson/BsonDouble;", "asInt32", "Lorg/mongodb/kbson/BsonInt32;", "asInt64", "Lorg/mongodb/kbson/BsonInt64;", "asJavaScript", "Lorg/mongodb/kbson/BsonJavaScript;", "asJavaScriptWithScope", "Lorg/mongodb/kbson/BsonJavaScriptWithScope;", "asNumber", "Lorg/mongodb/kbson/BsonNumber;", "asObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "asRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "asString", "Lorg/mongodb/kbson/BsonString;", "asSymbol", "Lorg/mongodb/kbson/BsonSymbol;", "asTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "isArray", "", "isBinary", "isBoolean", "isDBPointer", "isDateTime", "isDecimal128", "isDocument", "isDouble", "isInt32", "isInt64", "isJavaScript", "isJavaScriptWithScope", "isMaxKey", "isMinKey", "isNull", "isNumber", "isObjectId", "isRegularExpression", "isString", "isSymbol", "isTimestamp", "isUndefined", "throwIfInvalidType", "", "expectedType", "toJson", "", "Companion", "kbson_debug"})
public abstract class BsonValue {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private BsonValue() {
    }

    @NotNull
    public abstract BsonType getBsonType();

    public final boolean isNull() {
        return this instanceof BsonNull;
    }

    public final boolean isDocument() {
        return this instanceof BsonDocument;
    }

    public final boolean isArray() {
        return this instanceof BsonArray;
    }

    public final boolean isString() {
        return this instanceof BsonString;
    }

    public final boolean isNumber() {
        return this.isInt32() || this.isInt64() || this.isDouble();
    }

    public final boolean isInt32() {
        return this instanceof BsonInt32;
    }

    public final boolean isInt64() {
        return this instanceof BsonInt64;
    }

    public final boolean isDecimal128() {
        return this instanceof BsonDecimal128;
    }

    public final boolean isDouble() {
        return this instanceof BsonDouble;
    }

    public final boolean isBoolean() {
        return this instanceof BsonBoolean;
    }

    public final boolean isObjectId() {
        return this instanceof BsonObjectId;
    }

    public final boolean isDBPointer() {
        return this instanceof BsonDBPointer;
    }

    public final boolean isTimestamp() {
        return this instanceof BsonTimestamp;
    }

    public final boolean isBinary() {
        return this instanceof BsonBinary;
    }

    public final boolean isDateTime() {
        return this instanceof BsonDateTime;
    }

    public final boolean isSymbol() {
        return this instanceof BsonSymbol;
    }

    public final boolean isRegularExpression() {
        return this instanceof BsonRegularExpression;
    }

    public final boolean isJavaScript() {
        return this instanceof BsonJavaScript;
    }

    public final boolean isJavaScriptWithScope() {
        return this instanceof BsonJavaScriptWithScope;
    }

    public final boolean isMaxKey() {
        return this instanceof BsonMaxKey;
    }

    public final boolean isMinKey() {
        return this instanceof BsonMinKey;
    }

    public final boolean isUndefined() {
        return this instanceof BsonUndefined;
    }

    @NotNull
    public final BsonDocument asDocument() {
        this.throwIfInvalidType(BsonType.DOCUMENT);
        return (BsonDocument)this;
    }

    @NotNull
    public final BsonArray asArray() {
        this.throwIfInvalidType(BsonType.ARRAY);
        return (BsonArray)this;
    }

    @NotNull
    public final BsonString asString() {
        this.throwIfInvalidType(BsonType.STRING);
        return (BsonString)this;
    }

    @NotNull
    public final BsonNumber asNumber() {
        if (this.getBsonType() != BsonType.INT32 && this.getBsonType() != BsonType.INT64 && this.getBsonType() != BsonType.DOUBLE) {
            throw new BsonInvalidOperationException(Intrinsics.stringPlus((String)"Value expected to be of a numerical BSON type is of unexpected type ", (Object)((Object)this.getBsonType())), null, 2, null);
        }
        return (BsonNumber)this;
    }

    @NotNull
    public final BsonInt32 asInt32() {
        this.throwIfInvalidType(BsonType.INT32);
        return (BsonInt32)this;
    }

    @NotNull
    public final BsonInt64 asInt64() {
        this.throwIfInvalidType(BsonType.INT64);
        return (BsonInt64)this;
    }

    @NotNull
    public final BsonDecimal128 asDecimal128() {
        this.throwIfInvalidType(BsonType.DECIMAL128);
        return (BsonDecimal128)this;
    }

    @NotNull
    public final BsonDouble asDouble() {
        this.throwIfInvalidType(BsonType.DOUBLE);
        return (BsonDouble)this;
    }

    @NotNull
    public final BsonBoolean asBoolean() {
        this.throwIfInvalidType(BsonType.BOOLEAN);
        return (BsonBoolean)this;
    }

    @NotNull
    public final BsonObjectId asObjectId() {
        this.throwIfInvalidType(BsonType.OBJECT_ID);
        return (BsonObjectId)this;
    }

    @NotNull
    public final BsonDBPointer asDBPointer() {
        this.throwIfInvalidType(BsonType.DB_POINTER);
        return (BsonDBPointer)this;
    }

    @NotNull
    public final BsonTimestamp asTimestamp() {
        this.throwIfInvalidType(BsonType.TIMESTAMP);
        return (BsonTimestamp)this;
    }

    @NotNull
    public final BsonBinary asBinary() {
        this.throwIfInvalidType(BsonType.BINARY);
        return (BsonBinary)this;
    }

    @NotNull
    public final BsonDateTime asDateTime() {
        this.throwIfInvalidType(BsonType.DATE_TIME);
        return (BsonDateTime)this;
    }

    @NotNull
    public final BsonSymbol asSymbol() {
        this.throwIfInvalidType(BsonType.SYMBOL);
        return (BsonSymbol)this;
    }

    @NotNull
    public final BsonRegularExpression asRegularExpression() {
        this.throwIfInvalidType(BsonType.REGULAR_EXPRESSION);
        return (BsonRegularExpression)this;
    }

    @NotNull
    public final BsonJavaScript asJavaScript() {
        this.throwIfInvalidType(BsonType.JAVASCRIPT);
        return (BsonJavaScript)this;
    }

    @NotNull
    public final BsonJavaScriptWithScope asJavaScriptWithScope() {
        this.throwIfInvalidType(BsonType.JAVASCRIPT_WITH_SCOPE);
        return (BsonJavaScriptWithScope)this;
    }

    @NotNull
    public final BsonNull asBsonNull() {
        this.throwIfInvalidType(BsonType.NULL);
        return (BsonNull)this;
    }

    @NotNull
    public final BsonMinKey asBsonMinKey() {
        this.throwIfInvalidType(BsonType.MIN_KEY);
        return (BsonMinKey)this;
    }

    @NotNull
    public final BsonMaxKey asBsonMaxKey() {
        this.throwIfInvalidType(BsonType.MAX_KEY);
        return (BsonMaxKey)this;
    }

    @NotNull
    public final BsonUndefined asBsonUndefined() {
        this.throwIfInvalidType(BsonType.UNDEFINED);
        return (BsonUndefined)this;
    }

    @NotNull
    public final String toJson() {
        return Bson.INSTANCE.toJson(this);
    }

    private final void throwIfInvalidType(BsonType expectedType) {
        if (this.getBsonType() != expectedType) {
            throw new BsonInvalidOperationException("Value expected to be of type " + (Object)((Object)expectedType) + " is of unexpected type " + (Object)((Object)this.getBsonType()), null, 2, null);
        }
    }

    public /* synthetic */ BsonValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/mongodb/kbson/BsonValue$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/BsonValue;", "kbson_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<BsonValue> serializer() {
            return BsonValueSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

