/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.internal.CurrentTime;
import org.mongodb.kbson.serialization.BsonDateTimeSerializer;

@Serializable(with=BsonDateTimeSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/mongodb/kbson/BsonDateTime;", "Lorg/mongodb/kbson/BsonValue;", "", "()V", "value", "", "(J)V", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "getValue", "()J", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "kbson_debug"})
public final class BsonDateTime
extends BsonValue
implements Comparable<BsonDateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;

    public BsonDateTime(long value) {
        super(null);
        this.value = value;
    }

    public final long getValue() {
        return this.value;
    }

    public BsonDateTime() {
        this(CurrentTime.INSTANCE.getCurrentTimeInMillis());
    }

    @Override
    @NotNull
    public BsonType getBsonType() {
        return BsonType.DATE_TIME;
    }

    @Override
    public int compareTo(@NotNull BsonDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.value, (long)other.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        BsonDateTime cfr_ignored_0 = (BsonDateTime)other;
        return this.value == ((BsonDateTime)other).value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        return "BsonDateTime(value=" + this.value + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/mongodb/kbson/BsonDateTime$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/BsonDateTime;", "kbson_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<BsonDateTime> serializer() {
            return BsonDateTimeSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

