/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.serialization.deserializers.body.BodyDTODeserializer;
import org.mockserver.serialization.deserializers.body.BodyWithContentTypeDTODeserializer;
import org.mockserver.serialization.deserializers.collections.CookiesDeserializer;
import org.mockserver.serialization.deserializers.collections.HeadersDeserializer;
import org.mockserver.serialization.deserializers.collections.ParametersDeserializer;
import org.mockserver.serialization.deserializers.condition.TimeToLiveDTODeserializer;
import org.mockserver.serialization.deserializers.condition.VerificationTimesDTODeserializer;
import org.mockserver.serialization.deserializers.string.NottableStringDeserializer;
import org.mockserver.serialization.serializers.body.BinaryBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.BinaryBodySerializer;
import org.mockserver.serialization.serializers.body.JsonBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonBodySerializer;
import org.mockserver.serialization.serializers.body.JsonPathBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonPathBodySerializer;
import org.mockserver.serialization.serializers.body.JsonSchemaBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonSchemaBodySerializer;
import org.mockserver.serialization.serializers.body.LogEventBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.LogEventBodySerializer;
import org.mockserver.serialization.serializers.body.ParameterBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.ParameterBodySerializer;
import org.mockserver.serialization.serializers.body.RegexBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.RegexBodySerializer;
import org.mockserver.serialization.serializers.body.StringBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.StringBodySerializer;
import org.mockserver.serialization.serializers.body.XPathBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XPathBodySerializer;
import org.mockserver.serialization.serializers.body.XmlBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XmlBodySerializer;
import org.mockserver.serialization.serializers.body.XmlSchemaBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XmlSchemaBodySerializer;
import org.mockserver.serialization.serializers.collections.CookiesSerializer;
import org.mockserver.serialization.serializers.collections.HeadersSerializer;
import org.mockserver.serialization.serializers.collections.ParametersSerializer;
import org.mockserver.serialization.serializers.condition.VerificationTimesDTOSerializer;
import org.mockserver.serialization.serializers.condition.VerificationTimesSerializer;
import org.mockserver.serialization.serializers.log.LogEntrySerializer;
import org.mockserver.serialization.serializers.request.HttpRequestDTOSerializer;
import org.mockserver.serialization.serializers.request.HttpRequestSerializer;
import org.mockserver.serialization.serializers.response.HttpResponseDTOSerializer;
import org.mockserver.serialization.serializers.response.HttpResponseSerializer;
import org.mockserver.serialization.serializers.response.TimeToLiveDTOSerializer;
import org.mockserver.serialization.serializers.response.TimesDTOSerializer;
import org.mockserver.serialization.serializers.response.TimesSerializer;
import org.mockserver.serialization.serializers.string.NottableStringSerializer;

public class ObjectMapperFactory {
    private static ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper(new JsonSerializer[0]);

    public static ObjectMapper createObjectMapper(JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapper(new JsonSerializer[0]);
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapper(additionJsonSerializers);
    }

    private static ObjectMapper buildObjectMapper(JsonSerializer ... additionJsonSerializers) {
        ObjectMapper objectMapper = new ObjectMapper();
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT));
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL));
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY));
        SimpleModule module = new SimpleModule();
        ObjectMapperFactory.addDeserializers(module);
        ObjectMapperFactory.addSerializers(module, additionJsonSerializers);
        objectMapper.registerModule(module);
        return objectMapper;
    }

    private static void addDeserializers(SimpleModule module) {
        List<JsonDeserializer> jsonDeserializers = Arrays.asList(new TimeToLiveDTODeserializer(), new BodyDTODeserializer(), new BodyWithContentTypeDTODeserializer(), new VerificationTimesDTODeserializer(), new NottableStringDeserializer(), new HeadersDeserializer(), new ParametersDeserializer(), new CookiesDeserializer());
        for (JsonDeserializer jsonDeserializer : jsonDeserializers) {
            Class<?> type = jsonDeserializer.handledType();
            module.addDeserializer(type, jsonDeserializer);
        }
    }

    private static void addSerializers(SimpleModule module, JsonSerializer[] additionJsonSerializers) {
        List<JsonSerializer> jsonSerializers = Arrays.asList(new TimesSerializer(), new TimesDTOSerializer(), new TimeToLiveDTOSerializer(), new HttpRequestSerializer(), new HttpRequestDTOSerializer(), new BinaryBodySerializer(), new BinaryBodyDTOSerializer(), new JsonBodySerializer(), new JsonBodyDTOSerializer(), new JsonSchemaBodySerializer(), new JsonSchemaBodyDTOSerializer(), new JsonPathBodySerializer(), new JsonPathBodyDTOSerializer(), new ParameterBodySerializer(), new ParameterBodyDTOSerializer(), new RegexBodySerializer(), new RegexBodyDTOSerializer(), new StringBodySerializer(), new StringBodyDTOSerializer(), new XmlBodySerializer(), new XmlBodyDTOSerializer(), new XmlSchemaBodySerializer(), new XmlSchemaBodyDTOSerializer(), new XPathBodySerializer(), new XPathBodyDTOSerializer(), new LogEventBodySerializer(), new LogEventBodyDTOSerializer(), new VerificationTimesDTOSerializer(), new VerificationTimesSerializer(), new NottableStringSerializer(), new HttpResponseSerializer(), new HttpResponseDTOSerializer(), new HeadersSerializer(), new ParametersSerializer(), new CookiesSerializer(), new LogEntrySerializer());
        HashMap jsonSerializersByType = new HashMap();
        for (JsonSerializer jsonSerializer : jsonSerializers) {
            jsonSerializersByType.put(jsonSerializer.handledType(), jsonSerializer);
        }
        for (JsonSerializer additionJsonSerializer : additionJsonSerializers) {
            jsonSerializersByType.put(additionJsonSerializer.handledType(), additionJsonSerializer);
        }
        for (Map.Entry entry : jsonSerializersByType.entrySet()) {
            module.addSerializer((Class)entry.getKey(), (JsonSerializer)entry.getValue());
        }
    }
}

