/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.dashboard.DashboardHandler;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.PortBinding;
import org.mockserver.netty.proxy.connect.HttpConnectHandler;
import org.mockserver.netty.responsewriter.NettyResponseWriter;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.serialization.PortBindingSerializer;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf("PROXYING");
    public static final AttributeKey<Set<String>> LOCAL_HOST_HEADERS = AttributeKey.valueOf("LOCAL_HOST_HEADERS");
    private MockServerLogger mockServerLogger;
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer;
    private LifeCycle server;
    private ActionHandler actionHandler;
    private DashboardHandler dashboardHandler = new DashboardHandler();

    public MockServerHandler(LifeCycle server, HttpStateHandler httpStateHandler, ActionHandler actionHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.portBindingSerializer = new PortBindingSerializer(this.mockServerLogger);
        this.actionHandler = actionHandler;
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(PROXYING).get() != null) {
            return ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    private static Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(LOCAL_HOST_HEADERS) != null && ctx.channel().attr(LOCAL_HOST_HEADERS).get() != null) {
            return ctx.channel().attr(LOCAL_HOST_HEADERS).get();
        }
        return new HashSet<String>();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block19: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(this.mockServerLogger, ctx, this.httpStateHandler.getScheduler());
            try {
                ConfigurationProperties.addSubjectAlternativeName(request.getFirstHeader(HttpHeaderNames.HOST.toString()));
                if (this.httpStateHandler.handle(request, responseWriter, false)) break block19;
                if (request.matches("PUT", "/mockserver/status", "/status") || StringUtils.isNotBlank(ConfigurationProperties.livenessHttpGetPath()) && request.matches("GET", ConfigurationProperties.livenessHttpGetPath())) {
                    ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getLocalPorts())), "application/json");
                    break block19;
                }
                if (request.matches("PUT", "/mockserver/bind", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    if (requestedPortBindings == null) break block19;
                    try {
                        List<Integer> actualPortBindings = this.server.bindServerPorts(requestedPortBindings.getPorts());
                        ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block19;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create("text", "plain").toString());
                            break block19;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/mockserver/stop", "/stop")) {
                    ctx.writeAndFlush(HttpResponse.response().withStatusCode(HttpResponseStatus.OK.code()));
                    new Thread(() -> this.server.stop()).start();
                } else if (request.getMethod().getValue().equals("GET") && request.getPath().getValue().startsWith("/mockserver/dashboard")) {
                    this.dashboardHandler.renderDashboard(ctx, request);
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    String username = ConfigurationProperties.proxyAuthenticationUsername();
                    String password = ConfigurationProperties.proxyAuthenticationPassword();
                    if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(password) && !request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + Base64.encode(Unpooled.copiedBuffer(username + ':' + password, StandardCharsets.UTF_8), false).toString(StandardCharsets.US_ASCII))) {
                        ctx.writeAndFlush(HttpResponse.response().withStatusCode(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code()).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), "Basic realm=\"" + StringEscapeUtils.escapeJava(ConfigurationProperties.proxyAuthenticationRealm()) + "\", charset=\"UTF-8\""));
                    } else {
                        ctx.channel().attr(PROXYING).set(Boolean.TRUE);
                        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
                        if (StringUtils.isNotBlank(request.getPath().getValue())) {
                            this.server.getScheduler().submit(() -> ConfigurationProperties.addSubjectAlternativeName(request.getPath().getValue()));
                        }
                        ctx.pipeline().addLast(new HttpConnectHandler(this.server, this.mockServerLogger, request.getPath().getValue(), -1));
                        ctx.pipeline().remove(this);
                        ctx.fireChannelRead(request);
                    }
                } else {
                    try {
                        this.actionHandler.processAction(request, responseWriter, ctx, MockServerHandler.getLocalAddresses(ctx), MockServerHandler.isProxyingRequest(ctx), false);
                    }
                    catch (Throwable throwable) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("exception processing:{}").setArguments(request).setThrowable(throwable));
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("exception processing:{}error:{}").setArguments(request, iae.getMessage()));
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create("text", "plain").toString());
            }
            catch (Exception ex) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("exception processing " + request).setThrowable(ex));
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.BAD_REQUEST.code()).withBody(ex.getMessage()), true);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

