/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.ObjectWithJsonToString;

public class NottableString
extends ObjectWithJsonToString
implements Comparable<NottableString> {
    private static final char NOT_CHAR = '!';
    private final String value;
    private final boolean isBlank;
    private final Boolean not;
    private final int hashCode;
    private final String json;
    private Pattern pattern;
    private Pattern lowercasePattern;

    private NottableString(String value, Boolean not) {
        this.value = value;
        this.isBlank = StringUtils.isBlank(value);
        this.not = not != null ? not : Boolean.FALSE;
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = this.not != false ? '!' + this.value : this.value;
    }

    private NottableString(String value) {
        this.isBlank = StringUtils.isBlank(value);
        if (!this.isBlank && value.charAt(0) == '!') {
            this.value = value.substring(1);
            this.not = Boolean.TRUE;
        } else {
            this.value = value;
            this.not = Boolean.FALSE;
        }
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = this.not != false ? '!' + this.value : this.value;
    }

    public static List<NottableString> deserializeNottableStrings(String ... strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static List<NottableString> deserializeNottableStrings(List<String> strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static String serialiseNottableString(NottableString nottableString) {
        return nottableString.toString();
    }

    public static List<String> serialiseNottableString(Collection<NottableString> nottableStrings) {
        LinkedList<String> strings = new LinkedList<String>();
        for (NottableString nottableString : nottableStrings) {
            strings.add(nottableString.toString());
        }
        return strings;
    }

    public static NottableString string(String value, Boolean not) {
        return new NottableString(value, not);
    }

    public static NottableString string(String value) {
        return new NottableString(value);
    }

    public static NottableString not(String value) {
        return new NottableString(value, Boolean.TRUE);
    }

    public static List<NottableString> strings(String ... values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public static List<NottableString> strings(Collection<String> values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public boolean isNot() {
        return this.not;
    }

    NottableString capitalize() {
        Object[] split = (this.value + "_").split("-");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.capitalize(split[i]);
        }
        return new NottableString(StringUtils.substringBeforeLast(Joiner.on("-").join(split), "_"), this.not);
    }

    public NottableString lowercase() {
        return new NottableString(this.value.toLowerCase(), this.not);
    }

    public boolean equalsIgnoreCase(Object other) {
        return this.equals(other, true);
    }

    private boolean equals(Object other, boolean ignoreCase) {
        if (other instanceof String) {
            if (ignoreCase) {
                return this.not.booleanValue() != ((String)other).equalsIgnoreCase(this.value);
            }
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            boolean reverse;
            NottableString that = (NottableString)other;
            if (that.getValue() == null) {
                return this.value == null;
            }
            boolean bl = reverse = that.not != this.not && (that.not != false || this.not != false);
            if (ignoreCase) {
                return reverse != that.getValue().equalsIgnoreCase(this.value);
            }
            return reverse != that.getValue().equals(this.value);
        }
        return false;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public boolean matches(String input) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getValue());
        }
        return this.pattern.matcher(input).matches();
    }

    public boolean matchesIgnoreCase(String input) {
        if (this.lowercasePattern == null) {
            this.lowercasePattern = Pattern.compile(this.getValue().toLowerCase());
        }
        return this.lowercasePattern.matcher(input.toLowerCase()).matches();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            NottableString that = (NottableString)other;
            if (that.getValue() == null) {
                return this.value == null;
            }
            boolean reverse = that.not != this.not && (that.not != false || this.not != false);
            return reverse != that.getValue().equals(this.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.json;
    }

    @Override
    public int compareTo(NottableString other) {
        return other.getValue().compareTo(this.getValue());
    }
}

