/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;
import org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class XmlStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "diffBuilder"};
    private final MockServerLogger mockServerLogger;
    private DiffBuilder diffBuilder;
    private NottableString matcher = NottableString.string("THIS SHOULD NEVER MATCH");

    XmlStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this(mockServerLogger, NottableString.string(matcher));
    }

    XmlStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.matcher = matcher;
            this.diffBuilder = DiffBuilder.compare(Input.fromString(this.matcher.getValue())).ignoreComments().ignoreWhitespace().normalizeWhitespace().checkForSimilar();
        }
        catch (Exception e) {
            mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("error while creating xml string matcher for [" + matcher + "]" + e.getMessage()).setThrowable(e));
        }
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = false;
        if (this.diffBuilder != null) {
            try {
                Diff diff = this.diffBuilder.withTest(Input.fromString(matched.getValue())).withDifferenceEvaluator(new PlaceholderDifferenceEvaluator()).build();
                boolean bl = result = !diff.hasDifferences();
                if (!result) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xml match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, diff.toString()));
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xml match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, e.getMessage()));
            }
        }
        return this.matcher.isNot() == (this.not == result);
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank(this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

