/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.slf4j.event.Level;

public class XPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "stringToXmlDocumentParser", "xpathExpression"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private final StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();
    private XPathExpression xpathExpression = null;

    XPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotBlank(matcher)) {
            try {
                this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
            }
            catch (XPathExpressionException e) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + e.getMessage()).setArguments(e));
            }
        }
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        boolean alreadyLoggedMatchFailure = false;
        if (this.xpathExpression == null) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xpath match failed expected:{}found:{}failed because:{}").setArguments("null", matched, "xpath matcher was null"));
            alreadyLoggedMatchFailure = true;
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = (Boolean)this.xpathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(matched, (matchedInException, exception) -> this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xpath match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, exception.getMessage()).setThrowable(exception))), XPathConstants.BOOLEAN);
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xpath match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, throwable.getMessage()).setThrowable(throwable));
                alreadyLoggedMatchFailure = true;
            }
        }
        if (!result && !alreadyLoggedMatchFailure) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xpath match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, "xpath did not evaluate to truthy"));
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank(this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

