/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.dashboard.model.DashboardLogEntryDTO;
import org.mockserver.dashboard.serializers.DashboardLogEntryDTOSerializer;
import org.mockserver.dashboard.serializers.ThrowableSerializer;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.ui.MockServerLogListener;
import org.mockserver.ui.MockServerMatcherListener;
import org.mockserver.ui.MockServerMatcherNotifier;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class DashboardWebSocketServerHandler
extends ChannelInboundHandlerAdapter
implements MockServerLogListener,
MockServerMatcherListener {
    private static final Predicate<DashboardLogEntryDTO> requestLogPredicate = input -> input.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST;
    private static final Predicate<DashboardLogEntryDTO> requestResponseLogPredicate = input -> input.getType() == LogEntry.LogMessageType.EXPECTATION_RESPONSE || input.getType() == LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE || input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final Predicate<DashboardLogEntryDTO> recordedExpectationLogPredicate = input -> input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET = AttributeKey.valueOf("CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI = "/_mockserver_ui_websocket";
    private static final int UI_UPDATE_ITEM_LIMIT = 50;
    private static ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private final boolean sslEnabledUpstream;
    private final HttpStateHandler httpStateHandler;
    private HttpRequestSerializer httpRequestSerializer;
    private WebSocketServerHandshaker handshaker;
    private final Map<ChannelHandlerContext, HttpRequest> clientRegistry = new CircularHashMap<ChannelHandlerContext, HttpRequest>(100);
    private MockServerMatcher mockServerMatcher;
    private MockServerEventLog mockServerEventLog;
    private ThreadPoolExecutor scheduler;
    private ScheduledExecutorService throttleExecutorService;
    private Semaphore semaphore;

    public DashboardWebSocketServerHandler(HttpStateHandler httpStateHandler, boolean sslEnabledUpstream) {
        this.httpStateHandler = httpStateHandler;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.sslEnabledUpstream = sslEnabledUpstream;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception creating scheduler " + throwable.getMessage()).setThrowable(throwable));
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.throttleExecutorService != null) {
            this.throttleExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).set(true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get() != null && ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get().booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        if (this.mockServerEventLog == null) {
            this.mockServerEventLog = this.httpStateHandler.getMockServerLog();
            this.mockServerEventLog.registerListener(this);
            this.mockServerMatcher = this.httpStateHandler.getMockServerMatcher();
            this.mockServerMatcher.registerListener(this);
        }
        String webSocketURL = (this.sslEnabledUpstream ? "wss" : "ws") + "://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI;
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("upgraded dashboard connection to support web sockets on url{}").setArguments(webSocketURL));
        this.handshaker = new WebSocketServerHandshakerFactory(webSocketURL, null, true, Integer.MAX_VALUE).newHandshaker(httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), httpRequest, (HttpHeaders)new DefaultHttpHeaders(), ctx.channel().newPromise()).addListener(future -> this.clientRegistry.put(ctx, HttpRequest.request()));
        }
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper(new DashboardLogEntryDTOSerializer(), new ThrowableSerializer());
        }
        if (this.httpRequestSerializer == null) {
            this.httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
        }
        if (this.semaphore == null) {
            this.semaphore = new Semaphore(1);
        }
        if (this.throttleExecutorService == null) {
            this.throttleExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (this.scheduler == null) {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        this.throttleExecutorService.scheduleAtFixedRate(() -> {
            if (this.semaphore.availablePermits() == 0) {
                this.semaphore.release(1);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener(future -> this.clientRegistry.remove(ctx));
        } else if (frame instanceof TextWebSocketFrame) {
            try {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(((TextWebSocketFrame)frame).text());
                this.clientRegistry.put(ctx, httpRequest);
                this.sendUpdate(httpRequest, ctx);
            }
            catch (IllegalArgumentException iae) {
                this.sendMessage(ctx, ImmutableMap.of("error", iae.getMessage()));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write(new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(frame.getClass().getName() + " frame types not supported");
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, ImmutableMap<String, Object> message) {
        if (this.semaphore.tryAcquire()) {
            this.scheduler.submit(() -> {
                try {
                    ctx.writeAndFlush(new TextWebSocketFrame(objectMapper.writeValueAsString(message)));
                }
                catch (JsonProcessingException jpe) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception will serialising UI data " + jpe.getMessage()).setThrowable(jpe));
                }
            });
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("web socket server caught exception").setThrowable(cause));
        }
        ctx.close();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.mockServerMatcher != null) {
            this.mockServerMatcher.unregisterListener(this);
        }
        if (this.mockServerEventLog != null) {
            this.mockServerEventLog.unregisterListener(this);
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void updated(MockServerEventLog mockServerLog) {
        for (Map.Entry<ChannelHandlerContext, HttpRequest> registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate(registryEntry.getValue(), registryEntry.getKey());
        }
    }

    @Override
    public void updated(MockServerMatcher mockServerMatcher, MockServerMatcherNotifier.Cause cause) {
        for (Map.Entry<ChannelHandlerContext, HttpRequest> registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate(registryEntry.getValue(), registryEntry.getKey());
        }
    }

    private void sendUpdate(HttpRequest httpRequest, ChannelHandlerContext channelHandlerContext) {
        this.mockServerEventLog.retrieveLogEntriesInReverse(httpRequest, logEntry -> true, DashboardLogEntryDTO::new, reverseLogEventsStream -> {
            ArrayList recordedExpectations = new ArrayList();
            ArrayList recordedRequests = new ArrayList();
            ArrayList recordedRequestResponses = new ArrayList();
            ArrayList logMessages = new ArrayList();
            reverseLogEventsStream.forEach(logEntryDTO -> {
                if (recordedExpectationLogPredicate.test((DashboardLogEntryDTO)logEntryDTO) && recordedExpectations.size() < 50) {
                    recordedExpectations.add(ImmutableMap.of("key", logEntryDTO.getId(), "value", new Expectation(logEntryDTO.getHttpRequest(), Times.once(), TimeToLive.unlimited(), 0).thenRespond(logEntryDTO.getHttpResponse())));
                }
                if (requestLogPredicate.test((DashboardLogEntryDTO)logEntryDTO) && recordedRequests.size() < 50) {
                    HttpRequest[] httpRequests = logEntryDTO.getHttpRequests();
                    for (int i = 0; i < httpRequests.length; ++i) {
                        recordedRequests.add(ImmutableMap.of("key", logEntryDTO.getId() + i, "value", httpRequests[i]));
                    }
                }
                if (requestResponseLogPredicate.test((DashboardLogEntryDTO)logEntryDTO) && recordedRequestResponses.size() < 50) {
                    recordedRequestResponses.add(logEntryDTO);
                }
                if (logMessages.size() < 50) {
                    logMessages.add(logEntryDTO);
                }
            });
            this.sendMessage(channelHandlerContext, ImmutableMap.of("activeExpectations", this.mockServerMatcher.retrieveActiveExpectations(httpRequest).stream().limit(50L).map(expectation -> ImmutableMap.of("key", expectation.getId(), "value", expectation)).collect(Collectors.toList()), "recordedExpectations", recordedExpectations, "recordedRequests", recordedRequests, "recordedRequestResponses", recordedRequestResponses, "logMessages", logMessages));
        });
    }
}

