/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.client.SocketConnectionException;
import org.mockserver.model.HttpResponse;

@ChannelHandler.Sharable
public class HttpClientConnectionHandler
extends ChannelDuplexHandler {
    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get();
        if (responseFuture != null && !responseFuture.isDone()) {
            responseFuture.completeExceptionally(new SocketConnectionException("Channel handler removed before valid response has been received"));
        }
        super.handlerRemoved(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get();
        if (!responseFuture.isDone()) {
            responseFuture.completeExceptionally(cause);
        }
        super.exceptionCaught(ctx, cause);
    }
}

