/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.service.grizzlyclient;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.util.ProxyUtils;
import java.net.ProxySelector;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mockserver.model.Book;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.service.BookService;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BookServiceGrizzlyHttpClient
implements BookService {
    @Resource
    private Environment environment;
    private Integer port;
    private String host;
    private ObjectMapper objectMapper;
    private AsyncHttpClient asyncHttpClient;

    @PostConstruct
    private void initialise() {
        this.port = (Integer)this.environment.getProperty("bookService.port", Integer.class);
        this.host = this.environment.getProperty("bookService.host", "localhost");
        this.objectMapper = this.createObjectMapper();
        this.asyncHttpClient = this.createHttpClient();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NUMBERS_FOR_ENUMS, false);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        return objectMapper;
    }

    private AsyncHttpClient createHttpClient() {
        AsyncHttpClientConfig.Builder clientConfigBuilder = new AsyncHttpClientConfig.Builder();
        if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            clientConfigBuilder.setProxyServerSelector(ProxyUtils.createProxyServerSelector((ProxySelector)HttpProxy.proxySelector()));
        }
        return new AsyncHttpClient(clientConfigBuilder.build());
    }

    public Book[] getAllBooks() {
        try {
            ListenableFuture responseFuture = this.asyncHttpClient.prepareGet("http://" + this.host + ":" + this.port + "/get_books").execute();
            return (Book[])this.objectMapper.readValue(((Response)responseFuture.get()).getResponseBodyAsBytes(), Book[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve all books", e);
        }
    }

    public Book getBook(String id) {
        try {
            ListenableFuture responseFuture = this.asyncHttpClient.prepareGet("http://" + this.host + ":" + this.port + "/get_book?id=" + id).execute();
            return (Book)this.objectMapper.readValue(((Response)responseFuture.get()).getResponseBodyAsBytes(), Book.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve a book with id [" + id + "]", e);
        }
    }
}

