/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocket;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.OkHttpClient;

public final class Pods {
    private Pods() {
    }

    public static final LocalPortForward forwardPort(OkHttpClient httpClient, Listable<? extends PodList> pods, int remotePort) throws MalformedURLException {
        return Pods.forwardPort(httpClient, pods, remotePort, 0);
    }

    public static final LocalPortForward forwardPort(OkHttpClient httpClient, Listable<? extends PodList> pods, int remotePort, int localPort) throws MalformedURLException {
        LocalPortForward returnValue = null;
        if (httpClient != null && pods instanceof OperationSupport) {
            String urlBase = ((OperationSupport)pods).getNamespacedUrl().toExternalForm();
            assert (urlBase != null);
            Pod readyPod = Pods.getFirstReadyPod(pods);
            if (readyPod != null) {
                String name = readyPod.getMetadata().getName();
                assert (name != null);
                URL url = new URL(urlBase + "/" + name);
                PortForwarderWebsocket portForwarderWebsocket = new PortForwarderWebsocket(httpClient);
                returnValue = localPort <= 0 ? portForwarderWebsocket.forward(url, remotePort) : portForwarderWebsocket.forward(url, remotePort, localPort);
            }
        }
        return returnValue;
    }

    public static final Boolean isReady(Pod pod) {
        Boolean returnValue = null;
        if (pod != null) {
            returnValue = Pods.isReady(pod.getStatus());
        }
        return returnValue;
    }

    public static final Boolean isReady(PodStatus podStatus) {
        Boolean returnValue = null;
        if (podStatus != null) {
            returnValue = Pods.isReady(podStatus.getConditions());
        }
        return returnValue;
    }

    public static final Boolean isReady(Iterable<? extends PodCondition> podConditions) {
        Boolean returnValue = null;
        if (podConditions != null) {
            block10: for (PodCondition podCondition : podConditions) {
                String conditionStatus;
                String conditionType;
                if (podCondition == null || !"Ready".equals(conditionType = podCondition.getType())) continue;
                switch (conditionStatus = podCondition.getStatus()) {
                    case "True": {
                        if (Boolean.FALSE.equals(returnValue)) {
                            returnValue = null;
                            continue block10;
                        }
                        returnValue = Boolean.TRUE;
                        continue block10;
                    }
                    case "False": {
                        if (Boolean.TRUE.equals(returnValue)) {
                            returnValue = null;
                            continue block10;
                        }
                        returnValue = Boolean.FALSE;
                        continue block10;
                    }
                    case "Unknown": {
                        returnValue = null;
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unexpected value for PodCondition of type Ready: " + conditionStatus);
            }
        }
        return returnValue;
    }

    public static final Pod getFirstReadyPod(Iterable<? extends Pod> pods) {
        Pod returnValue = null;
        if (pods != null) {
            for (Pod pod : pods) {
                if (!Boolean.TRUE.equals(Pods.isReady(pod))) continue;
                returnValue = pod;
                break;
            }
        }
        return returnValue;
    }

    public static final Pod getFirstReadyPod(PodList podList) {
        Pod returnValue = null;
        if (podList != null) {
            returnValue = Pods.getFirstReadyPod(podList.getItems());
        }
        return returnValue;
    }

    public static final Pod getFirstReadyPod(Listable<? extends PodList> podsResource) {
        Pod returnValue = null;
        if (podsResource != null) {
            returnValue = Pods.getFirstReadyPod((PodList)podsResource.list());
        }
        return returnValue;
    }
}

