/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.impl.StandardReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class PrepareResultPacket
implements Completion,
Prepare {
    static final ColumnDecoder CONSTANT_PARAMETER;
    private static final Logger logger;
    private final ColumnDecoder[] parameters;
    protected int statementId;
    private ColumnDecoder[] columns;

    public PrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        int i;
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new ColumnDecoder[numParams];
        this.columns = new ColumnDecoder[numColumns];
        if (numParams > 0) {
            for (i = 0; i < numParams; ++i) {
                this.parameters[i] = CONSTANT_PARAMETER;
                reader.skipPacket();
            }
            if (!context.isEofDeprecated()) {
                reader.skipPacket();
            }
        }
        if (numColumns > 0) {
            for (i = 0; i < numColumns; ++i) {
                this.columns[i] = context.getColumnDecoderFunction().apply(new StandardReadableByteBuf(reader.readPacket(trace)));
            }
            if (!context.isEofDeprecated()) {
                reader.skipPacket();
            }
        }
    }

    @Override
    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    @Override
    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    @Override
    public ColumnDecoder[] getParameters() {
        return this.parameters;
    }

    @Override
    public ColumnDecoder[] getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(ColumnDecoder[] columns) {
        this.columns = columns;
    }

    static {
        logger = Loggers.getLogger(PrepareResultPacket.class);
        byte[] bytes = new byte[]{3, 100, 101, 102, 0, 0, 0, 1, 63, 0, 0, 12, 63, 0, 0, 0, 0, 0, 6, -128, 0, 0, 0, 0};
        CONSTANT_PARAMETER = ColumnDecoder.decode(new StandardReadableByteBuf(bytes, bytes.length));
    }
}

