/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.ParameterMetaData;
import org.mariadb.jdbc.SimpleParameterMetaData;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.result.ResultSetMetaData;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.BulkExecutePacket;
import org.mariadb.jdbc.message.client.PreparePacket;
import org.mariadb.jdbc.message.client.QueryWithParametersPacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.util.ClientParser;
import org.mariadb.jdbc.util.ParameterList;

public class ClientPreparedStatement
extends BasePreparedStatement {
    private final ClientParser parser;

    public ClientPreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(sql, con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        boolean noBackslashEscapes = (con.getContext().getServerStatus() & 0x200) > 0;
        this.parser = ClientParser.parameterParts(sql, noBackslashEscapes);
        this.isInsertDuplicate = this.parser.isInsertDuplicate();
        this.isCommandInsert = this.parser.isInsert() && this.isInsertDuplicate == false;
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    protected String preSqlCmd() {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR ";
        }
        return null;
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        this.lock.lock();
        try {
            QueryWithParametersPacket query = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, this.parameters, this.localInfileInputStream);
            this.results = this.con.getClient().execute(query, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
            this.lock.unlock();
        }
    }

    private boolean executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        this.checkIfInsertCommand();
        Configuration conf = this.con.getContext().getConf();
        if (this.con.getContext().hasServerCapability(0x400000000L) && (this.isCommandInsert.booleanValue() && (conf.useBulkStmts() || conf.useBulkStmtsForInserts()) || !this.isCommandInsert.booleanValue() && conf.useBulkStmts()) && this.batchParameters.size() > 1 && this.autoGeneratedKeys != 1) {
            this.executeBatchBulk();
            return this.isCommandInsert;
        }
        boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
        if (possibleLoadLocal) {
            String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
            boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
        }
        if (possibleLoadLocal) {
            this.executeBatchStd();
        } else {
            this.executeBatchPipeline();
        }
        return false;
    }

    private void executeBatchBulk() throws SQLException {
        String cmd = this.escapeTimeout(this.sql);
        try {
            if (this.prepareResult == null) {
                ClientMessage[] packets = new ClientMessage[]{new PreparePacket(cmd), new BulkExecutePacket(null, this.batchParameters, cmd, null)};
                List<Completion> res = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
                this.results = res.get(0) instanceof PrepareResultPacket ? res.subList(1, res.size()) : res;
            } else {
                this.results = this.con.getClient().execute(new BulkExecutePacket(this.prepareResult, this.batchParameters, cmd, null), this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
            }
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(Collections.emptyList(), this.batchParameters.size(), bue);
        }
    }

    private void executeBatchPipeline() throws SQLException {
        ClientMessage[] packets = new ClientMessage[this.batchParameters.size()];
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            packets[i] = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), null);
        }
        try {
            this.results = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private void executeBatchStd() throws SQLException {
        try {
            this.results = new ArrayList();
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                this.results.addAll(this.con.getClient().execute(new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), this.localInfileInputStream), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false));
            }
        }
        catch (SQLException bue) {
            BatchUpdateException exception = this.exceptionFactory().createBatchUpdate(this.results, this.batchParameters.size(), bue);
            this.results = null;
            this.localInfileInputStream = null;
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parser.getParamCount(); ++i) {
            if (this.parameters.containsKey(i)) continue;
            throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.canUseServerTimeout && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            try {
                this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
            }
            catch (SQLException e) {
                return new SimpleParameterMetaData(this.exceptionFactory(), this.parser.getParamCount());
            }
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            int i;
            boolean wasBulkInsert = this.executeInternalPreparedBatch();
            int[] updates = new int[this.batchParameters.size()];
            if (wasBulkInsert) {
                int numberOfResult = 0;
                for (int i2 = 0; i2 < this.results.size(); ++i2) {
                    numberOfResult += (int)((OkPacket)this.results.get(i2)).getAffectedRows();
                }
                if (numberOfResult == updates.length) {
                    Arrays.fill(updates, 1);
                    this.currResult = (Completion)this.results.remove(0);
                    int[] nArray = updates;
                    return nArray;
                }
            }
            if (this.results.size() != this.batchParameters.size()) {
                for (i = 0; i < this.batchParameters.size(); ++i) {
                    updates[i] = -2;
                }
            } else {
                for (i = 0; i < updates.length; ++i) {
                    updates[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
                }
            }
            this.currResult = (Completion)this.results.remove(0);
            int[] nArray = updates;
            return nArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            boolean wasBulkInsert = this.executeInternalPreparedBatch();
            long[] updates = new long[this.results.size()];
            if (wasBulkInsert) {
                int numberOfResult = 0;
                for (int i = 0; i < this.results.size(); ++i) {
                    numberOfResult += (int)((OkPacket)this.results.get(i)).getAffectedRows();
                }
                if (numberOfResult == updates.length) {
                    Arrays.fill(updates, 1L);
                    this.currResult = (Completion)this.results.remove(0);
                    long[] lArray = updates;
                    return lArray;
                }
            }
            for (int i = 0; i < this.results.size(); ++i) {
                updates[i] = ((OkPacket)this.results.get(i)).getAffectedRows();
            }
            this.currResult = (Completion)this.results.remove(0);
            long[] lArray = updates;
            return lArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.lock.lock();
            try {
                this.prepareResult.close(this.con.getClient());
            }
            finally {
                this.lock.unlock();
            }
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    @Override
    public String toString() {
        return "ClientPreparedStatement{" + super.toString() + '}';
    }
}

