/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.sql.SQLException;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.util.Options;

public class OffsetTimeParameter
implements Cloneable,
ParameterHolder {
    private OffsetTime time;
    private boolean fractionalSeconds;

    public OffsetTimeParameter(OffsetTime offsetTime, ZoneId serverZoneId, boolean fractionalSeconds, Options options) throws SQLException {
        ZoneId zoneId;
        ZoneId zoneId2 = zoneId = options.useLegacyDatetimeCode ? ZoneOffset.systemDefault() : serverZoneId;
        if (zoneId instanceof ZoneOffset) {
            throw new SQLException("cannot set OffsetTime, since server time zone is set to '" + serverZoneId.toString() + "' (check server variables time_zone and system_time_zone)");
        }
        this.time = offsetTime.withOffsetSameInstant((ZoneOffset)zoneId);
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.fractionalSeconds ? "HH:mm:ss.SSSSSS" : "HH:mm:ss", Locale.ENGLISH);
        pos.write(39);
        pos.write(formatter.format(this.time).getBytes());
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 15;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        if (this.fractionalSeconds) {
            pos.write(12);
            pos.write(0);
            pos.writeInt(0);
            pos.write((byte)this.time.getHour());
            pos.write((byte)this.time.getMinute());
            pos.write((byte)this.time.getSecond());
            pos.writeInt(this.time.getNano() / 1000);
        } else {
            pos.write(8);
            pos.write(0);
            pos.writeInt(0);
            pos.write((byte)this.time.getHour());
            pos.write((byte)this.time.getMinute());
            pos.write((byte)this.time.getSecond());
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TIME;
    }

    @Override
    public String toString() {
        return "'" + this.time.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

