/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.Collection;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.spi.BuilderInfo;

public class BuilderType {
    private final Type builder;
    private final Type owningType;
    private final Type buildingType;
    private final ExecutableElement builderCreationMethod;
    private final Collection<ExecutableElement> buildMethods;

    private BuilderType(Type builder, Type owningType, Type buildingType, ExecutableElement builderCreationMethod, Collection<ExecutableElement> buildMethods) {
        this.builder = builder;
        this.owningType = owningType;
        this.buildingType = buildingType;
        this.builderCreationMethod = builderCreationMethod;
        this.buildMethods = buildMethods;
    }

    public Type getBuilder() {
        return this.builder;
    }

    public Type getOwningType() {
        return this.owningType;
    }

    public Type getBuildingType() {
        return this.buildingType;
    }

    public ExecutableElement getBuilderCreationMethod() {
        return this.builderCreationMethod;
    }

    public Collection<ExecutableElement> getBuildMethods() {
        return this.buildMethods;
    }

    public static BuilderType create(BuilderInfo builderInfo, Type typeToBuild, TypeFactory typeFactory, TypeUtils typeUtils) {
        if (builderInfo == null) {
            return null;
        }
        Type builder = typeFactory.getType(builderInfo.getBuilderCreationMethod().getReturnType());
        ExecutableElement builderCreationMethod = builderInfo.getBuilderCreationMethod();
        TypeMirror builderCreationOwner = builderCreationMethod.getEnclosingElement().asType();
        Type owner = typeUtils.isSameType(builderCreationOwner, typeToBuild.getTypeMirror()) ? typeToBuild : (typeUtils.isSameType(builder.getTypeMirror(), builderCreationOwner) ? builder : typeFactory.getType(builderCreationOwner));
        if (builderInfo.getBuilderCreationMethod().getKind() == ElementKind.CONSTRUCTOR) {
            builder = owner;
        }
        return new BuilderType(builder, owner, typeToBuild, builderCreationMethod, builderInfo.getBuildMethods());
    }
}

