/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;

public class ParameterBinding {
    private final Type type;
    private final String variableName;
    private final SourceRHS sourceRHS;
    private final Collection<BindingType> bindingTypes;

    private ParameterBinding(Type parameterType, String variableName, Collection<BindingType> bindingTypes, SourceRHS sourceRHS) {
        this.type = parameterType;
        this.variableName = variableName;
        this.bindingTypes = bindingTypes;
        this.sourceRHS = sourceRHS;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public boolean isSourceParameter() {
        return this.bindingTypes.contains((Object)BindingType.PARAMETER);
    }

    public boolean isTargetType() {
        return this.bindingTypes.contains((Object)BindingType.TARGET_TYPE);
    }

    public boolean isMappingTarget() {
        return this.bindingTypes.contains((Object)BindingType.MAPPING_TARGET);
    }

    public boolean isMappingContext() {
        return this.bindingTypes.contains((Object)BindingType.CONTEXT);
    }

    public boolean isForSourceRhs() {
        return this.bindingTypes.contains((Object)BindingType.SOURCE_RHS);
    }

    public boolean isSourcePropertyName() {
        return this.bindingTypes.contains((Object)BindingType.SOURCE_PROPERTY_NAME);
    }

    public boolean isTargetPropertyName() {
        return this.bindingTypes.contains((Object)BindingType.TARGET_PROPERTY_NAME);
    }

    public Type getType() {
        return this.type;
    }

    public SourceRHS getSourceRHS() {
        return this.sourceRHS;
    }

    public Set<Type> getImportTypes() {
        if (this.isTargetType()) {
            return this.type.getImportTypes();
        }
        if (this.sourceRHS != null) {
            return this.sourceRHS.getImportTypes();
        }
        return Collections.emptySet();
    }

    public static ParameterBinding fromParameter(Parameter parameter) {
        EnumSet<BindingType> bindingTypes = EnumSet.of(BindingType.PARAMETER);
        if (parameter.isMappingTarget()) {
            bindingTypes.add(BindingType.MAPPING_TARGET);
        }
        if (parameter.isTargetType()) {
            bindingTypes.add(BindingType.TARGET_TYPE);
        }
        if (parameter.isMappingContext()) {
            bindingTypes.add(BindingType.CONTEXT);
        }
        if (parameter.isSourcePropertyName()) {
            bindingTypes.add(BindingType.SOURCE_PROPERTY_NAME);
        }
        if (parameter.isTargetPropertyName()) {
            bindingTypes.add(BindingType.TARGET_PROPERTY_NAME);
        }
        return new ParameterBinding(parameter.getType(), parameter.getName(), bindingTypes, null);
    }

    public static List<ParameterBinding> fromParameters(List<Parameter> parameters) {
        ArrayList<ParameterBinding> result = new ArrayList<ParameterBinding>(parameters.size());
        for (Parameter param : parameters) {
            result.add(ParameterBinding.fromParameter(param));
        }
        return result;
    }

    public static ParameterBinding fromTypeAndName(Type parameterType, String parameterName) {
        return new ParameterBinding(parameterType, parameterName, Collections.emptySet(), null);
    }

    public static ParameterBinding forTargetTypeBinding(Type classTypeOf) {
        return new ParameterBinding(classTypeOf, null, Collections.singleton(BindingType.TARGET_TYPE), null);
    }

    public static ParameterBinding forTargetPropertyNameBinding(Type classTypeOf) {
        return new ParameterBinding(classTypeOf, null, Collections.singleton(BindingType.TARGET_PROPERTY_NAME), null);
    }

    public static ParameterBinding forSourcePropertyNameBinding(Type classTypeOf) {
        return new ParameterBinding(classTypeOf, null, Collections.singleton(BindingType.SOURCE_PROPERTY_NAME), null);
    }

    public static ParameterBinding forMappingTargetBinding(Type resultType) {
        return new ParameterBinding(resultType, null, Collections.singleton(BindingType.MAPPING_TARGET), null);
    }

    public static ParameterBinding forSourceTypeBinding(Type sourceType) {
        return new ParameterBinding(sourceType, null, Collections.singleton(BindingType.SOURCE_TYPE), null);
    }

    public static ParameterBinding fromSourceRHS(SourceRHS sourceRHS) {
        return new ParameterBinding(sourceRHS.getSourceType(), null, Collections.singleton(BindingType.SOURCE_RHS), sourceRHS);
    }

    static enum BindingType {
        PARAMETER,
        FROM_TYPE_AND_NAME,
        TARGET_TYPE,
        TARGET_PROPERTY_NAME,
        SOURCE_PROPERTY_NAME,
        MAPPING_TARGET,
        CONTEXT,
        SOURCE_TYPE,
        SOURCE_RHS;

    }
}

