/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class JavadocGem
implements Gem {
    private final GemValue<String> value;
    private final GemValue<List<String>> authors;
    private final GemValue<String> deprecated;
    private final GemValue<String> since;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private JavadocGem(BuilderImpl builder) {
        this.value = builder.value;
        this.authors = builder.authors;
        this.deprecated = builder.deprecated;
        this.since = builder.since;
        this.isValid = this.value != null && this.value.isValid() && this.authors != null && this.authors.isValid() && this.deprecated != null && this.deprecated.isValid() && this.since != null && this.since.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<String> value() {
        return this.value;
    }

    public GemValue<List<String>> authors() {
        return this.authors;
    }

    public GemValue<String> deprecated() {
        return this.deprecated;
    }

    public GemValue<String> since() {
        return this.since;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static JavadocGem instanceOn(Element element) {
        return JavadocGem.build(element, new BuilderImpl());
    }

    public static JavadocGem instanceOn(AnnotationMirror mirror) {
        return JavadocGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.Javadoc".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return JavadocGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("value".equals(methodName)) {
                builder.setValue(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if ("authors".equals(methodName)) {
                builder.setAuthors(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if ("deprecated".equals(methodName)) {
                builder.setDeprecated(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if (!"since".equals(methodName)) continue;
            builder.setSince(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<JavadocGem> {
        private GemValue<String> value;
        private GemValue<List<String>> authors;
        private GemValue<String> deprecated;
        private GemValue<String> since;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setValue(GemValue<String> value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder setAuthors(GemValue<List<String>> authors) {
            this.authors = authors;
            return this;
        }

        @Override
        public Builder setDeprecated(GemValue<String> deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Override
        public Builder setSince(GemValue<String> since) {
            this.since = since;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public JavadocGem build() {
            return new JavadocGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setValue(GemValue<String> var1);

        public Builder setAuthors(GemValue<List<String>> var1);

        public Builder setDeprecated(GemValue<String> var1);

        public Builder setSince(GemValue<String> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

