/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.gem.NullValueCheckStrategyGem;
import org.mapstruct.ap.internal.gem.NullValuePropertyMappingStrategyGem;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.assignment.ExistingInstanceSetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.NewInstanceSetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapperForCollectionsAndMapsWithNullCheck;
import org.mapstruct.ap.internal.model.assignment.UpdateWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;

public class CollectionAssignmentBuilder {
    private MappingBuilderContext ctx;
    private Method method;
    private Accessor targetReadAccessor;
    private Type targetType;
    private String targetPropertyName;
    private AccessorType targetAccessorType;
    private Assignment assignment;
    private SourceRHS sourceRHS;
    private NullValueCheckStrategyGem nvcs;
    private NullValuePropertyMappingStrategyGem nvpms;

    public CollectionAssignmentBuilder mappingBuilderContext(MappingBuilderContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public CollectionAssignmentBuilder method(Method method) {
        this.method = method;
        return this;
    }

    public CollectionAssignmentBuilder targetReadAccessor(Accessor targetReadAccessor) {
        this.targetReadAccessor = targetReadAccessor;
        return this;
    }

    public CollectionAssignmentBuilder targetType(Type targetType) {
        this.targetType = targetType;
        return this;
    }

    public CollectionAssignmentBuilder targetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
        return this;
    }

    public CollectionAssignmentBuilder targetAccessorType(AccessorType targetAccessorType) {
        this.targetAccessorType = targetAccessorType;
        return this;
    }

    public CollectionAssignmentBuilder assignment(Assignment assignment) {
        this.assignment = assignment;
        return this;
    }

    public CollectionAssignmentBuilder rightHandSide(SourceRHS sourceRHS) {
        this.sourceRHS = sourceRHS;
        return this;
    }

    public CollectionAssignmentBuilder nullValueCheckStrategy(NullValueCheckStrategyGem nvcs) {
        this.nvcs = nvcs;
        return this;
    }

    public CollectionAssignmentBuilder nullValuePropertyMappingStrategy(NullValuePropertyMappingStrategyGem nvpms) {
        this.nvpms = nvpms;
        return this;
    }

    public Assignment build() {
        boolean targetImmutable;
        Assignment result = this.assignment;
        CollectionMappingStrategyGem cms = this.method.getOptions().getMapper().getCollectionMappingStrategy();
        boolean bl = targetImmutable = cms == CollectionMappingStrategyGem.TARGET_IMMUTABLE || this.targetReadAccessor == null;
        if (this.targetAccessorType == AccessorType.SETTER || this.targetAccessorType.isFieldAssignment()) {
            if (result.isCallingUpdateMethod() && !targetImmutable) {
                if (this.targetReadAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                }
                MethodReference factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.targetType, SelectionParameters.forSourceRHS(this.sourceRHS), this.ctx);
                result = new UpdateWrapper(result, this.method.getThrownTypes(), factoryMethod, this.targetAccessorType.isFieldAssignment(), this.targetType, true, this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_NULL && !this.targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT);
            } else if (this.method.isUpdateMethod() && !targetImmutable) {
                result = new ExistingInstanceSetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.nvcs, this.nvpms, this.ctx.getTypeFactory(), this.targetAccessorType.isFieldAssignment());
            } else if (this.method.isUpdateMethod() && this.nvpms == NullValuePropertyMappingStrategyGem.IGNORE) {
                result = new SetterWrapperForCollectionsAndMapsWithNullCheck(result, this.method.getThrownTypes(), this.targetType, this.ctx.getTypeFactory(), this.targetAccessorType.isFieldAssignment());
            } else if (this.setterWrapperNeedsSourceNullCheck(result) && this.canBeMappedOrDirectlyAssigned(result)) {
                result = new SetterWrapperForCollectionsAndMapsWithNullCheck(result, this.method.getThrownTypes(), this.targetType, this.ctx.getTypeFactory(), this.targetAccessorType.isFieldAssignment());
            } else if (this.canBeMappedOrDirectlyAssigned(result)) {
                result = new SetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.targetAccessorType.isFieldAssignment());
            } else if (this.hasNoArgsConstructor()) {
                result = new NewInstanceSetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.ctx.getTypeFactory(), this.targetAccessorType.isFieldAssignment());
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_SUITABLE_COLLECTION_OR_MAP_CONSTRUCTOR, this.targetType);
            }
        } else {
            if (targetImmutable) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_WRITE_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
            }
            result = new GetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.targetAccessorType.isFieldAssignment());
        }
        return result;
    }

    private boolean canBeMappedOrDirectlyAssigned(Assignment result) {
        return result.getType() != Assignment.AssignmentType.DIRECT || this.hasCopyConstructor() || this.targetType.isEnumSet();
    }

    private boolean setterWrapperNeedsSourceNullCheck(Assignment rhs) {
        if (rhs.getSourcePresenceCheckerReference() != null) {
            return true;
        }
        if (this.nvcs == NullValueCheckStrategyGem.ALWAYS) {
            return true;
        }
        return rhs.getType().isDirect();
    }

    private boolean hasCopyConstructor() {
        return this.checkConstructorForPredicate(this::hasCopyConstructor);
    }

    private boolean hasNoArgsConstructor() {
        return this.checkConstructorForPredicate(this::hasNoArgsConstructor);
    }

    private boolean checkConstructorForPredicate(Predicate<Element> predicate) {
        if (this.targetType.isCollectionOrMapType()) {
            TypeElement sourceElement;
            if ("java.util".equals(this.targetType.getPackageName())) {
                return true;
            }
            TypeElement typeElement = sourceElement = this.targetType.getImplementationType() != null ? this.targetType.getImplementationType().getTypeElement() : this.targetType.getTypeElement();
            if (sourceElement != null) {
                for (Element element : sourceElement.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !predicate.test(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasNoArgsConstructor(Element element) {
        return ((ExecutableElement)element).getParameters().isEmpty();
    }

    private boolean hasCopyConstructor(Element element) {
        if (element instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)element;
            return ee.getParameters().size() == 1 && this.ctx.getTypeUtils().isAssignable(this.targetType.getTypeMirror(), ee.getParameters().get(0).asType());
        }
        return false;
    }
}

