/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.spring.registration;

import java.lang.reflect.Method;
import org.kasource.web.websocket.WebSocketEventListener;
import org.kasource.web.websocket.WebSocketMessageListener;
import org.kasource.web.websocket.annotations.WebSocketBinaryListener;
import org.kasource.web.websocket.annotations.WebSocketListener;
import org.kasource.web.websocket.annotations.WebSocketTextListener;
import org.kasource.web.websocket.listener.WebSocketEventMethod;
import org.kasource.web.websocket.listener.WebSocketListenerMethod;
import org.kasource.web.websocket.spring.SpringWebSocketFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WebSocketListenerPostBeanProcessor
implements BeanPostProcessor {
    @Autowired
    private SpringWebSocketFactory factory;

    public Object postProcessAfterInitialization(Object object, String beanName) throws BeansException {
        if (object.getClass().isAnnotationPresent(WebSocketListener.class)) {
            boolean interfaceImplementationFound = false;
            if (object instanceof WebSocketMessageListener) {
                this.registerListener((WebSocketMessageListener)object);
                interfaceImplementationFound = true;
            }
            if (object instanceof WebSocketEventListener) {
                this.registerListener((WebSocketEventListener)object);
                interfaceImplementationFound = true;
            }
            if (!interfaceImplementationFound) {
                throw new FatalBeanException("bean " + beanName + " of class " + object.getClass() + " must implement either " + WebSocketMessageListener.class + " or " + WebSocketEventListener.class + " to annotated with @WebSocketListener");
            }
        }
        this.inspectMethodAnnotations(object);
        return object;
    }

    public Object postProcessBeforeInitialization(Object object, String beanName) throws BeansException {
        return object;
    }

    private void inspectMethodAnnotations(Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            if (method.isAnnotationPresent(WebSocketBinaryListener.class)) {
                this.registerListener(object, method, method.getAnnotation(WebSocketBinaryListener.class).value());
                continue;
            }
            if (method.isAnnotationPresent(WebSocketTextListener.class)) {
                this.registerListener(object, method, method.getAnnotation(WebSocketTextListener.class).value());
                continue;
            }
            if (!method.isAnnotationPresent(org.kasource.web.websocket.annotations.WebSocketEventListener.class)) continue;
            this.registerListener(object, method, method.getAnnotation(org.kasource.web.websocket.annotations.WebSocketEventListener.class));
        }
    }

    private void registerListener(Object object, Method method, String socketName) {
        this.factory.listenTo(socketName, (WebSocketMessageListener)new WebSocketListenerMethod(object, method));
    }

    private void registerListener(WebSocketMessageListener listener) {
        WebSocketListener annotation = listener.getClass().getAnnotation(WebSocketListener.class);
        this.factory.listenTo(annotation.value(), listener);
    }

    private void registerListener(WebSocketEventListener listener) {
        WebSocketListener annotation = listener.getClass().getAnnotation(WebSocketListener.class);
        this.factory.listenTo(annotation.value(), listener);
    }

    private void registerListener(Object object, Method method, org.kasource.web.websocket.annotations.WebSocketEventListener annotation) {
        this.factory.listenTo(annotation.value(), (WebSocketEventListener)new WebSocketEventMethod(object, method, annotation.filter()));
    }
}

