/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaTime {
    public static void define(Ruby runtime2) {
        JavaExtensions.put(runtime2, java.time.Instant.class, proxyClass -> Instant.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.time.OffsetDateTime.class, proxyClass -> OffsetDateTime.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.time.LocalDateTime.class, proxyClass -> LocalDateTime.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, java.time.ZonedDateTime.class, proxyClass -> ZonedDateTime.define(runtime2, proxyClass));
        JavaExtensions.put(runtime2, ZoneId.class, klass -> klass.addMethod("inspect", new JavaLang.InspectRawValue((RubyModule)klass)));
        JavaExtensions.put(runtime2, Temporal.class, klass -> klass.addMethod("inspect", new JavaLang.InspectValueWithTypePrefix((RubyModule)klass)));
    }

    private static RubyTime toTime(Ruby runtime2, int year2, int month2, int day, int hour2, int min2, int sec2, int nano, DateTimeZone zone2) {
        int millisOfSec = nano / 1000000;
        DateTime dt = new DateTime(year2, month2, day, hour2, min2, sec2, millisOfSec, zone2);
        return RubyTime.newTime(runtime2, dt, nano % 1000000);
    }

    private static DateTimeZone convertZone(String id2) {
        if ("Z".equals(id2)) {
            return DateTimeZone.UTC;
        }
        return DateTimeZone.forID((String)id2);
    }

    @JRubyModule(name={"Java::JavaTime::ZonedDateTime"})
    public static class ZonedDateTime {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(ZonedDateTime.class);
            return proxy2;
        }

        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.ZonedDateTime val = (java.time.ZonedDateTime)JavaUtil.unwrapIfJavaObject(self2);
            Ruby runtime2 = context.runtime;
            return JavaTime.toTime(runtime2, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), JavaTime.convertZone(val.getZone().getId()));
        }
    }

    @JRubyModule(name={"Java::JavaTime::OffsetDateTime"})
    public static class OffsetDateTime {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(OffsetDateTime.class);
            return proxy2;
        }

        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.OffsetDateTime val = (java.time.OffsetDateTime)JavaUtil.unwrapIfJavaObject(self2);
            Ruby runtime2 = context.runtime;
            return JavaTime.toTime(runtime2, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), JavaTime.convertZone(val.getOffset().getId()));
        }
    }

    @JRubyModule(name={"Java::JavaTime::LocalDateTime"})
    public static class LocalDateTime {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(LocalDateTime.class);
            return proxy2;
        }

        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.LocalDateTime val = (java.time.LocalDateTime)JavaUtil.unwrapIfJavaObject(self2);
            Ruby runtime2 = context.runtime;
            return JavaTime.toTime(runtime2, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), RubyTime.getLocalTimeZone(runtime2));
        }
    }

    @JRubyModule(name={"Java::JavaTime::Instant"})
    public static class Instant {
        static RubyModule define(Ruby runtime2, RubyModule proxy2) {
            proxy2.defineAnnotatedMethods(Instant.class);
            return proxy2;
        }

        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.Instant val = (java.time.Instant)JavaUtil.unwrapIfJavaObject(self2);
            long nano = val.getNano();
            long millis = val.getEpochSecond() * 1000L + nano / 1000000L;
            Ruby runtime2 = context.runtime;
            return RubyTime.newTime(runtime2, new DateTime(millis, RubyTime.getLocalTimeZone(runtime2)), nano %= 1000000L);
        }
    }
}

