/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.FiberQueue;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadFiber.class);
    private static final BiConsumer<Ruby, Runnable> FIBER_LAUNCHER;
    private static final MethodHandle VTHREAD_START_METHOD;
    private static final FiberRequest NEVER;
    volatile FiberData data;
    volatile RubyThread thread;
    final boolean root;

    private static void nativeThreadLauncher(Ruby runtime2, Runnable runnable) {
        runtime2.getFiberExecutor().submit(runnable);
    }

    public boolean isBlocking() {
        return this.data.blocking;
    }

    public ThreadFiber(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, false);
    }

    public ThreadFiber(Ruby runtime2, RubyClass klass, boolean root) {
        super(runtime2, klass);
        this.root = root;
    }

    public static void initRootFiber(ThreadContext context, RubyThread currentThread) {
        Ruby runtime2 = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime2, runtime2.getFiber(), true);
        rootFiber.data = new FiberData(new FiberQueue(runtime2), currentThread, rootFiber, true);
        rootFiber.thread = currentThread;
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new FiberQueue(runtime2), context.getFiberCurrentThread(), this, false);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime2, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _opts, Block block) {
        IRubyObject blockingOpt;
        IRubyObject[] blockingPoolOpt;
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("tried to create Proc object without block");
        }
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, _opts);
        boolean blocking2 = false;
        if (!opts.isNil() && (blockingPoolOpt = ArgsUtil.extractKeywordArgs(context, opts, "blocking", "pool")) != null && (blockingOpt = blockingPoolOpt[0]) != null && !blockingOpt.isNil()) {
            blocking2 = blockingOpt.isTrue();
        }
        this.data = new FiberData(new FiberQueue(runtime2), context.getFiberCurrentThread(), this, blocking2);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime2, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, keywords=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        FiberRequest result2;
        FiberRequest val;
        Ruby runtime2 = context.runtime;
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        FiberData data2 = this.data;
        if (currentFiberData == data2) {
            throw runtime2.newFiberError("attempt to resume the current fiber");
        }
        if (this.root || data2.prev != null || data2.transferred) {
            throw runtime2.newFiberError("attempt to resume a resuming fiber");
        }
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = new FiberRequest(values2[0], RequestType.DATA);
                break;
            }
            default: {
                val = new FiberRequest(RubyArray.newArrayMayCopy(runtime2, values2), RequestType.DATA);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        data2.prev = context.getFiber();
        try {
            result2 = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
        }
        finally {
            data2.prev = null;
        }
        if (data2.blocking) {
            context.getFiberCurrentThread().decrementBlocking();
        }
        if (result2.type == RequestType.RAISE) {
            throw ((RubyException)result2.data).toThrowable();
        }
        return ThreadFiber.processResultData(context, result2);
    }

    @JRubyMethod(rest=true)
    public IRubyObject raise(ThreadContext context, IRubyObject[] args2) {
        return this.raise(context, RubyThread.prepareRaiseException(context, args2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FiberRequest exchangeWithFiber(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, FiberRequest request) {
        targetFiberData.queue.push(context, request);
        try {
            ThreadFiber.adjustThreadBlocking(context, currentFiberData, targetFiberData);
            FiberRequest fiberRequest = currentFiberData.queue.pop(context);
            return fiberRequest;
        }
        catch (RaiseException re) {
            ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
            FiberRequest fiberRequest = currentFiberData.queue.pop(context);
            return fiberRequest;
        }
        finally {
            ThreadFiber.adjustThreadBlocking(context, targetFiberData, currentFiberData);
        }
    }

    private static void adjustThreadBlocking(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData) {
        if (currentFiberData.blocking) {
            context.getFiberCurrentThread().decrementBlocking();
        }
        if (targetFiberData.blocking) {
            context.getFiberCurrentThread().incrementBlocking();
        }
    }

    private static void handleExceptionDuringExchange(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, RaiseException re) {
        if (context.runtime.getLocalJumpError().isInstance(re.getException())) {
            throw re;
        }
        if (currentFiberData.queue.isShutdown()) {
            throw re;
        }
        if (targetFiberData.queue.isShutdown()) {
            throw re;
        }
        ThreadFiber fiber2 = (ThreadFiber)targetFiberData.fiber.get();
        if (fiber2 == null || !fiber2.alive()) {
            throw re;
        }
        fiber2.thread.raise(re.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject transfer(ThreadContext context, IRubyObject[] values2) {
        FiberRequest result2;
        FiberRequest val;
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = new FiberRequest(values2[0], RequestType.DATA);
                break;
            }
            default: {
                val = new FiberRequest(RubyArray.newArrayMayCopy(runtime2, values2), RequestType.DATA);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            data2.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            data2.prev = context.getFiber();
        }
        try {
            result2 = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
        }
        finally {
            data2.prev = null;
            currentFiberData.transferred = false;
        }
        if (result2.type == RequestType.RAISE) {
            throw ((RubyException)result2.data).toThrowable();
        }
        return ThreadFiber.processResultData(context, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject raise(ThreadContext context, IRubyObject exception2) {
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            RubyKernel.raise(context, this, exception2);
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        FiberRequest val = new FiberRequest(exception2, RequestType.RAISE);
        data2.prev = context.getFiber();
        FiberRequest result2 = null;
        try {
            result2 = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
        }
        finally {
            if (result2 == null) {
                data2.prev = null;
                currentFiberData.transferred = false;
            }
        }
        if (result2.type == RequestType.RAISE) {
            throw ((RubyException)result2.data).toThrowable();
        }
        return ThreadFiber.processResultData(context, result2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime2 = context.runtime;
        FiberData currentFiberData = ThreadFiber.verifyCurrentFiber(context, runtime2);
        FiberData prevFiberData = currentFiberData.prev.data;
        FiberRequest result2 = ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, new FiberRequest(value2, RequestType.DATA));
        if (result2.type == RequestType.RAISE) {
            throw ((RubyException)result2.data).toThrowable();
        }
        return ThreadFiber.processResultData(context, result2);
    }

    private static IRubyObject processResultData(ThreadContext context, FiberRequest result2) {
        IRubyObject data2 = result2.data;
        if (data2 == RubyBasicObject.NEVER) {
            return context.nil;
        }
        return data2;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject[] value2) {
        switch (value2.length) {
            case 0: {
                return ThreadFiber.yield(context, recv2);
            }
            case 1: {
                return ThreadFiber.yield(context, recv2, value2[0]);
            }
        }
        Ruby runtime2 = context.runtime;
        FiberData currentFiberData = ThreadFiber.verifyCurrentFiber(context, runtime2);
        FiberData prevFiberData = currentFiberData.prev.data;
        FiberRequest result2 = ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, new FiberRequest(RubyArray.newArrayNoCopy(runtime2, value2), RequestType.DATA));
        if (result2.type == RequestType.RAISE) {
            throw ((RubyException)result2.data).toThrowable();
        }
        return ThreadFiber.processResultData(context, result2);
    }

    private static FiberData verifyCurrentFiber(ThreadContext context, Ruby runtime2) {
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime2.newFiberError("can't yield from root fiber");
        }
        if (currentFiberData.prev == null) {
            throw runtime2.newFiberError("BUG: yield occurred with null previous fiber. Report this at http://bugs.jruby.org");
        }
        if (currentFiberData.queue.isShutdown()) {
            throw runtime2.newFiberError("dead fiber yielded");
        }
        return currentFiberData;
    }

    @JRubyMethod(name={"alive?"})
    public IRubyObject alive_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.alive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject current(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    final boolean alive() {
        RubyThread thread2 = this.thread;
        return thread2 != null && thread2.isAlive() && !this.data.queue.isShutdown();
    }

    static RubyThread createThread(Ruby runtime2, FiberData data2, FiberQueue queue, Block block) {
        AtomicReference fiberThread = new AtomicReference();
        boolean retried = false;
        while (!retried) {
            try {
                FIBER_LAUNCHER.accept(runtime2, () -> {
                    ThreadContext context = runtime2.getCurrentContext();
                    context.setFiber((ThreadFiber)data2.fiber.get());
                    context.useRecursionGuardsFrom(data2.parent.getContext());
                    RubyThread rubyThread = context.getThread();
                    fiberThread.set(rubyThread);
                    rubyThread.setFiberCurrentThread(data2.parent);
                    Thread thread2 = Thread.currentThread();
                    String oldName = thread2.getName();
                    thread2.setName("Fiber thread for block at: " + block.getBody().getFile() + ":" + block.getBody().getLine());
                    try {
                        FiberRequest init = data2.queue.pop(context);
                        try {
                            FiberRequest result2 = init == NEVER ? new FiberRequest(block.yieldSpecific(context), RequestType.DATA) : new FiberRequest(block.yieldArray(context, init.data, null), RequestType.DATA);
                            ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                            if (tf != null) {
                                tf.thread = null;
                            }
                            data2.prev.data.queue.push(context, result2);
                            data2.queue.shutdown();
                            runtime2.getThreadService().unregisterCurrentThread(context);
                        }
                        catch (Throwable throwable) {
                            data2.queue.shutdown();
                            runtime2.getThreadService().unregisterCurrentThread(context);
                            ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                            if (tf != null) {
                                tf.thread = null;
                            }
                            throw throwable;
                        }
                        ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                        if (tf != null) {
                            tf.thread = null;
                        }
                    }
                    catch (JumpException.FlowControlException fce) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(fce.buildException(runtime2).getException());
                        }
                    }
                    catch (IRBreakJump bj) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(((RaiseException)IRException.BREAK_LocalJumpError.getException(runtime2)).getException());
                        }
                    }
                    catch (IRReturnJump rj) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(((RaiseException)IRException.RETURN_LocalJumpError.getException(runtime2)).getException());
                        }
                    }
                    catch (RaiseException re) {
                        if (data2.prev != null) {
                            data2.prev.data.queue.push(context, new FiberRequest(re.getException(), RequestType.RAISE));
                        }
                    }
                    catch (Throwable t) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(JavaUtil.convertJavaToUsableRubyObject(runtime2, t));
                        }
                    }
                    finally {
                        thread2.setName(oldName);
                    }
                });
                break;
            }
            catch (OutOfMemoryError oome) {
                oome.printStackTrace();
                String oomeMessage = oome.getMessage();
                if (!retried && oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                    System.gc();
                    retried = true;
                    continue;
                }
                throw oome;
            }
        }
        while (fiberThread.get() == null) {
            Thread.yield();
        }
        return (RubyThread)fiberThread.get();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject __finalize__(ThreadContext context) {
        try {
            this.doFinalize();
        }
        catch (Exception ignore) {
            return context.fals;
        }
        return context.nil;
    }

    private void doFinalize() {
        FiberData data2 = this.data;
        this.data = null;
        if (data2 != null) {
            if (data2.parent == null) {
                return;
            }
            data2.queue.shutdown();
        }
        RubyThread thread2 = this.thread;
        this.thread = null;
        if (thread2 != null) {
            thread2.dieFromFinalizer();
            thread2.interrupt();
            data2 = null;
            thread2 = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.doFinalize();
        }
        finally {
            super.finalize();
        }
    }

    @JRubyMethod(name={"blocking?"})
    public IRubyObject blocking_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isBlocking());
    }

    @JRubyMethod(name={"blocking?"}, meta=true)
    public static IRubyObject blocking_p_s(ThreadContext context, IRubyObject self2) {
        boolean blocking2 = context.getFiber().isBlocking();
        if (!blocking2) {
            return context.fals;
        }
        return RubyFixnum.one(context.runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"blocking"}, meta=true)
    public static IRubyObject blocking(ThreadContext context, IRubyObject self2, Block block) {
        ThreadFiber currentFiber = context.getFiber();
        boolean blocking2 = currentFiber.isBlocking();
        if (currentFiber.isBlocking()) {
            return block.yieldSpecific(context, currentFiber);
        }
        try {
            assert (!currentFiber.isBlocking()) : "fiber was blocking when it should not have been";
            currentFiber.data.blocking = true;
            context.getFiberCurrentThread().incrementBlocking();
            IRubyObject iRubyObject = block.yieldSpecific(context, currentFiber);
            return iRubyObject;
        }
        finally {
            currentFiber.data.blocking = false;
            context.getFiberCurrentThread().decrementBlocking();
        }
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context) {
        return this.backtrace(context, null, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2) {
        return this.backtrace(context, level2, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadFiber threadFiber = (ThreadFiber)this.data.fiber.get();
        if (threadFiber == null) {
            return context.nil;
        }
        return threadFiber.thread.backtrace(context, level2, length2);
    }

    @JRubyMethod(name={"backtrace_locations"})
    public IRubyObject backtrace_locations(ThreadContext context) {
        return this.backtrace_locations(context, null, null);
    }

    @JRubyMethod(name={"backtrace_locations"})
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2) {
        return this.backtrace_locations(context, level2, null);
    }

    @JRubyMethod(name={"backtrace_locations"})
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadFiber threadFiber = (ThreadFiber)this.data.fiber.get();
        if (threadFiber == null) {
            return context.nil;
        }
        return threadFiber.thread.backtrace_locations(context, level2, length2);
    }

    public FiberData getData() {
        return this.data;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    static {
        VirtualThreadLauncher fiberLauncher = ThreadFiber::nativeThreadLauncher;
        MethodHandle start2 = null;
        if (((Boolean)Options.FIBER_VTHREADS.load()).booleanValue()) {
            try {
                Method ofVirtualMethod = Thread.class.getMethod("ofVirtual", new Class[0]);
                Object builder = ofVirtualMethod.invoke(null, new Object[0]);
                Method startMethod = Class.forName("java.lang.Thread$Builder").getMethod("start", Runnable.class);
                start2 = MethodHandles.publicLookup().unreflect(startMethod).bindTo(builder);
                fiberLauncher = new VirtualThreadLauncher();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        VTHREAD_START_METHOD = start2;
        FIBER_LAUNCHER = fiberLauncher;
        NEVER = new FiberRequest(RubyBasicObject.NEVER, RequestType.DATA);
    }

    public static class FiberData {
        final FiberQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;
        volatile boolean blocking;

        FiberData(FiberQueue queue, RubyThread parent, ThreadFiber fiber2, boolean blocking2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
            this.blocking = blocking2;
        }

        public ThreadFiber getPrev() {
            return this.prev;
        }
    }

    public static class FiberSchedulerSupport {
        @JRubyMethod(name={"schedule"}, meta=true, rest=true, keywords=true)
        public static IRubyObject schedule(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
            RubyThread thread2 = context.getThread();
            IRubyObject scheduler = thread2.getScheduler();
            IRubyObject fiber2 = context.nil;
            if (scheduler.isNil()) {
                throw context.runtime.newRuntimeError("No scheduler is available!");
            }
            fiber2 = scheduler.callMethod(context, "fiber", args2, block);
            return fiber2;
        }

        @JRubyMethod(name={"scheduler"}, meta=true)
        public static IRubyObject get_scheduler(ThreadContext context, IRubyObject self2) {
            return context.getFiberCurrentThread().getScheduler();
        }

        @JRubyMethod(name={"current_scheduler"}, meta=true)
        public static IRubyObject current_scheduler(ThreadContext context, IRubyObject self2) {
            return context.getFiberCurrentThread().getSchedulerCurrent();
        }

        @JRubyMethod(name={"set_scheduler"}, meta=true)
        public static IRubyObject set_scheduler(ThreadContext context, IRubyObject self2, IRubyObject scheduler) {
            return context.getFiberCurrentThread().setFiberScheduler(scheduler);
        }
    }

    public static class FiberRequest {
        final IRubyObject data;
        final RequestType type;

        FiberRequest(IRubyObject data2, RequestType type2) {
            this.data = data2;
            this.type = type2;
        }
    }

    public static enum RequestType {
        DATA,
        RAISE;

    }

    private static class VirtualThreadLauncher
    implements BiConsumer<Ruby, Runnable> {
        private VirtualThreadLauncher() {
        }

        @Override
        public void accept(Ruby ruby, Runnable runnable) {
            try {
                VTHREAD_START_METHOD.invokeWithArguments(runnable);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
            }
        }
    }
}

