/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Bignum"}, parent="Integer")
public class RubyBignum
extends RubyInteger {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger ULONG_MAX = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    final BigInteger value;
    private static final int BIGLEN_LIMIT = 0x2000000;

    public static RubyClass createBignumClass(Ruby runtime2) {
        RubyClass bignum = runtime2.getInteger();
        runtime2.getObject().setConstant("Bignum", bignum);
        runtime2.getObject().deprecateConstant(runtime2, "Bignum");
        return bignum;
    }

    public RubyBignum(Ruby runtime2, BigInteger value2) {
        super(runtime2, runtime2.getBignum());
        this.value = value2;
        this.setFrozen(true);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BIGNUM;
    }

    @Override
    public Class<?> getJavaClass() {
        return BigInteger.class;
    }

    public static RubyBignum newBignum(Ruby runtime2, long value2) {
        return RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2));
    }

    public static RubyBignum newBignum(Ruby runtime2, double value2) {
        try {
            return RubyBignum.newBignum(runtime2, RubyBignum.toBigInteger(value2));
        }
        catch (NumberFormatException nfe) {
            throw runtime2.newFloatDomainError(Double.toString(value2));
        }
    }

    public static BigInteger toBigInteger(double value2) {
        return new BigDecimal(value2).toBigInteger();
    }

    public static RubyInteger newBignorm(Ruby runtime2, double value2) {
        try {
            return RubyBignum.bignorm(runtime2, RubyBignum.toBigInteger(value2));
        }
        catch (NumberFormatException nfe) {
            throw runtime2.newFloatDomainError(Double.toString(value2));
        }
    }

    public static RubyBignum newBignum(Ruby runtime2, BigInteger value2) {
        return new RubyBignum(runtime2, value2);
    }

    public static RubyBignum newBignum(Ruby runtime2, String value2) {
        return new RubyBignum(runtime2, new BigInteger(value2));
    }

    @Override
    public double getDoubleValue() {
        return RubyBignum.big2dbl(this);
    }

    @Override
    public long getLongValue() {
        return RubyBignum.big2long(this);
    }

    @Override
    public int getIntValue() {
        return (int)RubyBignum.big2long(this);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public RubyInteger negate() {
        return RubyBignum.bignorm(this.getRuntime(), this.value.negate());
    }

    public static RubyInteger bignorm(Ruby runtime2, BigInteger bi) {
        return bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0 ? RubyBignum.newBignum(runtime2, bi) : runtime2.newFixnum(bi.longValue());
    }

    public static long big2long(RubyBignum val) {
        BigInteger big = val.value;
        if (big.compareTo(LONG_MIN) < 0 || big.compareTo(LONG_MAX) > 0) {
            throw val.getRuntime().newRangeError("bignum too big to convert into `long'");
        }
        return big.longValue();
    }

    public static long big2ulong(RubyBignum value2) {
        Ruby runtime2 = value2.getRuntime();
        BigInteger big = value2.getValue();
        return RubyBignum.big2ulong(runtime2, big);
    }

    public static long big2ulong(Ruby runtime2, BigInteger big) {
        if (big.compareTo(BigInteger.ZERO) < 0 || big.compareTo(ULONG_MAX) > 0) {
            throw runtime2.newRangeError("bignum out of range for `ulong'");
        }
        return big.longValue();
    }

    public static double big2dbl(RubyBignum val) {
        BigInteger big = val.value;
        double dbl = RubyBignum.convertToDouble(big);
        if (dbl == Double.NEGATIVE_INFINITY || dbl == Double.POSITIVE_INFINITY) {
            val.getRuntime().getWarnings().warn(IRubyWarnings.ID.BIGNUM_FROM_FLOAT_RANGE, "Bignum out of Float range");
        }
        return dbl;
    }

    private RubyFixnum checkShiftDown(ThreadContext context, RubyBignum other) {
        if (other.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (this.value.compareTo(LONG_MIN) < 0 || this.value.compareTo(LONG_MAX) > 0) {
            return other.value.signum() >= 0 ? RubyFixnum.zero(context.runtime) : RubyFixnum.minus_one(context.runtime);
        }
        return null;
    }

    static double convertToDouble(BigInteger bigint) {
        long signum = bigint.signum() == -1 ? Long.MIN_VALUE : 0L;
        int len = (bigint = bigint.abs()).bitLength();
        if (len == 0) {
            return 0.0;
        }
        long exp2 = len + 1022;
        long frac2 = 0L;
        if (exp2 > 2047L) {
            exp2 = 2047L;
        } else {
            frac2 = bigint.shiftRight(len - 54).longValue() + 1L >> 1;
            if (frac2 == 0x20000000000000L && ++exp2 > 2047L) {
                exp2 = 2047L;
            }
        }
        return Double.longBitsToDouble(signum | exp2 << 52 | frac2 & 0xFFFFFFFFFFFFFL);
    }

    public static BigInteger fix2big(RubyFixnum arg2) {
        return RubyBignum.long2big(arg2.value);
    }

    public static BigInteger long2big(long arg2) {
        return BigInteger.valueOf(arg2);
    }

    @Override
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        int ndigits = arg2.convertToInteger().getIntValue();
        BigInteger self2 = this.value;
        if (ndigits >= 0) {
            return this;
        }
        int posdigits = Math.abs(ndigits);
        BigInteger exp2 = BigInteger.TEN.pow(posdigits);
        BigInteger mod = self2.mod(exp2);
        BigInteger res = self2;
        if (mod.signum() != 0) {
            res = self2.add(exp2.subtract(mod));
        }
        return RubyBignum.newBignum(context.runtime, res);
    }

    @Override
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        int ndigits = arg2.convertToInteger().getIntValue();
        BigInteger self2 = this.value;
        if (ndigits >= 0) {
            return this;
        }
        int posdigits = Math.abs(ndigits);
        BigInteger exp2 = BigInteger.TEN.pow(posdigits);
        BigInteger res = self2.subtract(self2.mod(exp2));
        return RubyBignum.newBignum(context.runtime, res);
    }

    @Override
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        BigInteger self2 = this.value;
        if (self2.compareTo(BigInteger.ZERO) == 1) {
            return this.floor(context, arg2);
        }
        if (self2.compareTo(BigInteger.ZERO) == -1) {
            return this.ceil(context, arg2);
        }
        return this;
    }

    @Override
    public RubyArray digits(ThreadContext context, IRubyObject base) {
        BigInteger bigBase;
        BigInteger self2 = this.value;
        Ruby runtime2 = context.runtime;
        if (self2.compareTo(BigInteger.ZERO) == -1) {
            throw runtime2.newMathDomainError("out of domain");
        }
        if (!(base instanceof RubyInteger)) {
            try {
                base = base.convertToInteger();
            }
            catch (ClassCastException e) {
                String cname = RubyBignum.getMetaClass(base).getRealClass().getName();
                throw runtime2.newTypeError("wrong argument type " + cname + " (expected Integer)");
            }
        }
        if ((bigBase = base instanceof RubyBignum ? ((RubyBignum)base).value : RubyBignum.long2big(((RubyFixnum)base).value)).signum() == -1) {
            throw runtime2.newArgumentError("negative radix");
        }
        if (bigBase.compareTo(BigInteger.valueOf(2L)) == -1) {
            throw runtime2.newArgumentError("invalid radix: " + bigBase);
        }
        RubyArray res = RubyArray.newArray(context.runtime, 0);
        if (self2.signum() == 0) {
            res.append(RubyFixnum.newFixnum(context.getRuntime(), 0L));
            return res;
        }
        while (self2.signum() > 0) {
            BigInteger q = self2.mod(bigBase);
            res.append(RubyBignum.newBignum(context.getRuntime(), q));
            self2 = self2.divide(bigBase);
        }
        return res;
    }

    public IRubyObject to_s(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(args2[0]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 1);
    }

    @Override
    public RubyString to_s() {
        return RubyString.newUSASCIIString(this.getRuntime(), this.value.toString(10));
    }

    @Override
    public RubyString to_s(IRubyObject arg0) {
        int base = RubyBignum.num2int(arg0);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return RubyString.newUSASCIIString(this.getRuntime(), this.value.toString(base));
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        Ruby runtime2 = this.getRuntime();
        if (other instanceof RubyFixnum) {
            return runtime2.newArray((IRubyObject)RubyBignum.newBignum(runtime2, ((RubyFixnum)other).value), (IRubyObject)this);
        }
        if (other instanceof RubyBignum) {
            return runtime2.newArray((IRubyObject)RubyBignum.newBignum(runtime2, ((RubyBignum)other).value), (IRubyObject)this);
        }
        return RubyArray.newArray(runtime2, RubyKernel.new_float(runtime2, other), RubyKernel.new_float(runtime2, this));
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyBignum.bignorm(context.runtime, this.value.negate());
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_plus(context, ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return this.op_plus(context, ((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return this.addFloat((RubyFloat)other);
        }
        return this.addOther(context, other);
    }

    @Override
    public final IRubyObject op_plus(ThreadContext context, long other) {
        BigInteger result2 = this.value.add(BigInteger.valueOf(other));
        if (other > 0L && this.value.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    public final IRubyObject op_plus(ThreadContext context, BigInteger other) {
        BigInteger result2 = this.value.add(other);
        if (this.value.signum() > 0 && other.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    private IRubyObject addFloat(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) + other.value);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_plus, other);
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_minus(context, ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return this.op_minus(context, ((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return this.subtractFloat((RubyFloat)other);
        }
        return this.subtractOther(context, other);
    }

    @Override
    public final IRubyObject op_minus(ThreadContext context, long other) {
        BigInteger result2 = this.value.subtract(BigInteger.valueOf(other));
        if (this.value.signum() < 0 && other > 0L) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    public final IRubyObject op_minus(ThreadContext context, BigInteger other) {
        BigInteger result2 = this.value.subtract(other);
        if (this.value.signum() < 0 && other.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    private IRubyObject subtractFloat(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) - other.value);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_minus, other);
    }

    @Override
    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mul(context, ((RubyFixnum)other).value);
        }
        if (!(other instanceof RubyBignum)) {
            if (other instanceof RubyFloat) {
                return RubyFloat.newFloat(context.runtime, RubyBignum.big2dbl(this) * ((RubyFloat)other).value);
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_times, other);
        }
        return RubyBignum.bignorm(context.runtime, this.value.multiply(((RubyBignum)other).value));
    }

    @Deprecated
    public final IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        return this.op_mul(context, other);
    }

    @Override
    public final IRubyObject op_mul(ThreadContext context, long other) {
        return RubyBignum.bignorm(context.runtime, this.value.multiply(RubyBignum.long2big(other)));
    }

    private IRubyObject op_divide(ThreadContext context, IRubyObject other, boolean slash) {
        BigInteger otherValue;
        Ruby runtime2 = context.runtime;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                double otherFloatValue = ((RubyFloat)other).value;
                if (!slash && otherFloatValue == 0.0) {
                    throw runtime2.newZeroDivisionError();
                }
                double div2 = RubyBignum.big2dbl(this) / otherFloatValue;
                if (slash) {
                    return RubyFloat.newFloat(runtime2, div2);
                }
                return RubyNumeric.dbl2ival(runtime2, div2);
            }
            return this.coerceBin(context, slash ? RubyBignum.sites((ThreadContext)context).op_quo : RubyBignum.sites((ThreadContext)context).div, other);
        }
        return this.divideImpl(runtime2, otherValue);
    }

    private RubyInteger divideImpl(Ruby runtime2, BigInteger otherValue) {
        BigInteger[] results;
        if (otherValue.signum() == 0) {
            throw runtime2.newZeroDivisionError();
        }
        BigInteger result2 = this.value.signum() * otherValue.signum() == -1 ? ((results = this.value.divideAndRemainder(otherValue))[1].signum() != 0 ? results[0].subtract(BigInteger.ONE) : results[0]) : this.value.divide(otherValue);
        return RubyBignum.bignorm(runtime2, result2);
    }

    @Override
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, true);
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.divideImpl(context.runtime, RubyBignum.long2big(other));
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, false);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, long other) {
        return this.divideImpl(context.runtime, RubyBignum.long2big(other));
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
                throw context.runtime.newZeroDivisionError();
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).divmod, other);
        }
        if (otherValue.signum() == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        BigInteger[] results = this.value.divideAndRemainder(otherValue);
        if (this.value.signum() * otherValue.signum() == -1 && results[1].signum() != 0) {
            results[0] = results[0].subtract(BigInteger.ONE);
            results[1] = otherValue.add(results[1]);
        }
        Ruby runtime2 = context.runtime;
        return RubyArray.newArray(runtime2, RubyBignum.bignorm(runtime2, results[0]), RubyBignum.bignorm(runtime2, results[1]));
    }

    @Override
    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mod(context, ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            BigInteger otherValue = ((RubyBignum)other).value;
            if (otherValue.signum() == 0) {
                throw context.runtime.newZeroDivisionError();
            }
            BigInteger result2 = this.value.mod(otherValue.abs());
            if (otherValue.signum() == -1 && result2.signum() != 0) {
                result2 = otherValue.add(result2);
            }
            return RubyBignum.bignorm(context.runtime, result2);
        }
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_mod, other);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, long other) {
        if (other == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        BigInteger result2 = this.value.mod(RubyBignum.long2big(other < 0L ? -other : other));
        if (other < 0L && result2.signum() != 0) {
            result2 = RubyBignum.long2big(other).add(result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    @Override
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    IRubyObject modulo(ThreadContext context, long other) {
        return this.op_mod(context, other);
    }

    @Deprecated
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
                throw context.runtime.newZeroDivisionError();
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).remainder, other);
        }
        if (otherValue.signum() == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        return RubyBignum.bignorm(context.runtime, this.value.remainder(otherValue));
    }

    @Deprecated
    public IRubyObject remainder19(ThreadContext context, IRubyObject other) {
        return this.remainder(context, other);
    }

    @Override
    @JRubyMethod(name={"quo"}, required=1)
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger && ((RubyInteger)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        if (other instanceof RubyNumeric) {
            if (((RubyNumeric)other).getDoubleValue() == 0.0) {
                throw context.runtime.newZeroDivisionError();
            }
            return RubyFloat.newFloat(context.runtime, RubyBignum.big2dbl(this) / ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).quo, other);
    }

    @Deprecated
    public final IRubyObject quo19(ThreadContext context, IRubyObject other) {
        return this.quo(context, other);
    }

    @Override
    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        double d;
        Ruby runtime2 = context.runtime;
        if (other == RubyFixnum.zero(runtime2)) {
            return RubyFixnum.one(runtime2);
        }
        if (other instanceof RubyFloat) {
            d = ((RubyFloat)other).value;
            if (this.compareTo(RubyFixnum.zero(runtime2)) == -1 && d != (double)Math.round(d)) {
                RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                return RubyBignum.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)complex, (IRubyObject)complex, other);
            }
        } else if (other instanceof RubyBignum) {
            d = ((RubyBignum)other).getDoubleValue();
            context.runtime.getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
        } else {
            if (other instanceof RubyFixnum) {
                return this.op_pow(context, ((RubyFixnum)other).value);
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_exp, other);
        }
        return this.pow(runtime2, d);
    }

    private RubyNumeric pow(Ruby runtime2, double d) {
        double pow2 = Math.pow(RubyBignum.big2dbl(this), d);
        if (Double.isInfinite(pow2)) {
            return RubyFloat.newFloat(runtime2, pow2);
        }
        return RubyNumeric.dbl2ival(runtime2, pow2);
    }

    public final IRubyObject op_pow(ThreadContext context, long other) {
        Ruby runtime2 = context.runtime;
        if (other < 0L) {
            IRubyObject x = this.op_pow(context, -other);
            if (x instanceof RubyInteger) {
                return RubyRational.newRationalRaw(runtime2, RubyFixnum.one(runtime2), x);
            }
            return RubyBignum.dbl2num(runtime2, 1.0 / RubyBignum.num2dbl(context, x));
        }
        int xbits = this.value.bitLength();
        if (xbits > 0x2000000 || (long)xbits * other > 0x2000000L) {
            runtime2.getWarnings().warn("in a**b, b may be too big");
            return this.pow(runtime2, other);
        }
        return RubyBignum.newBignum(runtime2, this.value.pow((int)other));
    }

    private void warnIfPowExponentTooBig(ThreadContext context, long other) {
        if ((double)((this.value.bitLength() + 7) / 8 * 4) * Math.abs((double)other) > 1048576.0) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
        }
    }

    @Deprecated
    public IRubyObject op_pow19(ThreadContext context, IRubyObject other) {
        return this.op_pow(context, other);
    }

    @Override
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.and(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return this.op_and(context, (RubyFixnum)other);
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_and, other);
    }

    final RubyInteger op_and(ThreadContext context, RubyFixnum other) {
        return RubyBignum.bignorm(context.runtime, this.value.and(RubyBignum.fix2big(other)));
    }

    @Deprecated
    public IRubyObject op_and19(ThreadContext context, IRubyObject other) {
        return this.op_and(context, other);
    }

    @Override
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.or(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return this.op_or(context, (RubyFixnum)other);
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_or, other);
    }

    final RubyInteger op_or(ThreadContext context, RubyFixnum other) {
        return RubyBignum.bignorm(context.runtime, this.value.or(RubyBignum.fix2big(other)));
    }

    @Override
    public IRubyObject bit_length(ThreadContext context) {
        return context.runtime.newFixnum(this.value.bitLength());
    }

    @Deprecated
    public IRubyObject op_or19(ThreadContext context, IRubyObject other) {
        return this.op_or(context, other);
    }

    @Override
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.xor(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(context.runtime, this.value.xor(BigInteger.valueOf(((RubyFixnum)other).value)));
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_xor, other);
    }

    @Deprecated
    public IRubyObject op_xor19(ThreadContext context, IRubyObject other) {
        return this.op_xor(context, other);
    }

    @Override
    public IRubyObject op_neg(ThreadContext context) {
        return RubyBignum.newBignum(context.runtime, this.value.not());
    }

    @Override
    public IRubyObject op_lshift(ThreadContext context, IRubyObject other) {
        long shift2;
        while (true) {
            if (other instanceof RubyFixnum) {
                shift2 = ((RubyFixnum)other).value;
                if (shift2 >= 0L || (long)this.value.bitLength() > -shift2) break;
                if (this.value.signum() >= 0) {
                    return RubyFixnum.zero(context.runtime);
                }
                return RubyFixnum.minus_one(context.runtime);
            }
            if (other instanceof RubyBignum) {
                RubyFixnum tmp;
                if (this.value.signum() == 0) {
                    return RubyFixnum.zero(context.runtime);
                }
                RubyBignum otherBignum = (RubyBignum)other;
                if (otherBignum.value.signum() < 0 && (tmp = otherBignum.checkShiftDown(context, this)) != null) {
                    return tmp;
                }
                if (otherBignum.value.compareTo(INTEGER_MAX) > 0) {
                    throw context.runtime.newRaiseException(context.runtime.getNoMemoryError(), "failed to allocate memory");
                }
                shift2 = RubyBignum.big2long(otherBignum);
                break;
            }
            other = other.convertToInteger();
        }
        return this.op_lshift(context, shift2);
    }

    @Override
    public RubyInteger op_lshift(ThreadContext context, long shift2) {
        if (this.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (shift2 > Integer.MAX_VALUE) {
            throw context.runtime.newRaiseException(context.runtime.getNoMemoryError(), "failed to allocate memory");
        }
        return RubyBignum.bignorm(context.runtime, this.value.shiftLeft((int)shift2));
    }

    @Override
    public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
        long shift2;
        while (true) {
            if (other instanceof RubyFixnum) {
                shift2 = ((RubyFixnum)other).value;
                if ((long)this.value.bitLength() > shift2) break;
                if (this.value.signum() >= 0) {
                    return RubyFixnum.zero(context.runtime);
                }
                return RubyFixnum.minus_one(context.runtime);
            }
            if (other instanceof RubyBignum) {
                RubyFixnum tmp;
                if (this.value == BigInteger.ZERO) {
                    return RubyFixnum.zero(context.runtime);
                }
                RubyBignum otherBignum = (RubyBignum)other;
                if (otherBignum.value.signum() >= 0 && (tmp = otherBignum.checkShiftDown(context, this)) != null) {
                    return tmp;
                }
                if (otherBignum.value.compareTo(INTEGER_MIN) < 0) {
                    throw context.runtime.newRaiseException(context.runtime.getNoMemoryError(), "failed to allocate memory");
                }
                shift2 = RubyBignum.big2long(otherBignum);
                break;
            }
            other = other.convertToInteger();
        }
        return this.op_rshift(context, shift2);
    }

    @Override
    public RubyInteger op_rshift(ThreadContext context, long shift2) {
        if (this.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (shift2 < Integer.MIN_VALUE) {
            throw context.runtime.newRaiseException(context.runtime.getNoMemoryError(), "failed to allocate memory");
        }
        return RubyBignum.bignorm(context.runtime, this.value.shiftRight((int)shift2));
    }

    @Override
    public RubyBoolean odd_p(ThreadContext context) {
        return this.value.testBit(0) ? context.tru : context.fals;
    }

    @Override
    public RubyBoolean even_p(ThreadContext context) {
        return this.value.testBit(0) ? context.fals : context.tru;
    }

    @Override
    protected IRubyObject op_aref_subclass(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum && (other = RubyBignum.bignorm(context.runtime, ((RubyBignum)other).value)) instanceof RubyBignum) {
            if (((RubyBignum)other).value.signum() >= 0 != (this.value.signum() == -1)) {
                return RubyFixnum.zero(context.runtime);
            }
            return RubyFixnum.one(context.runtime);
        }
        long position = RubyBignum.num2long(other);
        if (position < 0L || position > Integer.MAX_VALUE) {
            return RubyFixnum.zero(context.runtime);
        }
        return this.value.testBit((int)position) ? RubyFixnum.one(context.runtime) : RubyFixnum.zero(context.runtime);
    }

    private IRubyObject big_op(ThreadContext context, IRubyObject other, BIGNUM_OP_T op) {
        IRubyObject rel;
        if (other instanceof RubyInteger) {
            rel = this.op_cmp(context, other);
        } else if (other instanceof RubyFloat) {
            rel = this.float_cmp(context, (RubyFloat)other);
        } else {
            switch (op) {
                case BIGNUM_OP_GT: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_gt;
                    break;
                }
                case BIGNUM_OP_GE: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_ge;
                    break;
                }
                case BIGNUM_OP_LT: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_lt;
                    break;
                }
                case BIGNUM_OP_LE: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_le;
                }
            }
            return this.coerceRelOp(context, RubyBignum.sites((ThreadContext)context).op_gt, other);
        }
        if (rel.isNil()) {
            return context.fals;
        }
        int n = RubyBignum.fix2int(rel);
        IRubyObject ret = context.nil;
        switch (op) {
            case BIGNUM_OP_GT: {
                ret = n > 0 ? context.tru : context.fals;
                break;
            }
            case BIGNUM_OP_GE: {
                ret = n >= 0 ? context.tru : context.fals;
                break;
            }
            case BIGNUM_OP_LT: {
                ret = n < 0 ? context.tru : context.fals;
                break;
            }
            case BIGNUM_OP_LE: {
                ret = n <= 0 ? context.tru : context.fals;
            }
        }
        return ret;
    }

    @Override
    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_GT);
    }

    @Override
    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_LT);
    }

    @Override
    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_GE);
    }

    @Override
    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_LE);
    }

    private IRubyObject float_cmp(ThreadContext context, RubyFloat y) {
        Ruby runtime2 = context.runtime;
        double yd = y.value;
        if (Double.isNaN(yd)) {
            return context.nil;
        }
        if (Double.isInfinite(yd)) {
            if (yd > 0.0) {
                return RubyFixnum.minus_one(runtime2);
            }
            return RubyFixnum.one(runtime2);
        }
        double yi = yd > 0.0 ? Math.floor(yd) : Math.ceil(yd);
        double yf = yd - yi;
        IRubyObject rel = this.op_cmp(context, RubyBignum.newBignorm(runtime2, yi));
        if (yf == 0.0 || !rel.equals(RubyFixnum.zero(runtime2))) {
            return rel;
        }
        if (yf < 0.0) {
            return RubyFixnum.one(runtime2);
        }
        return RubyFixnum.minus_one(runtime2);
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value);
        }
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return (int)this.coerceCmp(context, RubyBignum.sites((ThreadContext)context).op_cmp, other).convertToInteger().getLongValue();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value) == 0;
        }
        return false;
    }

    @Override
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flt = (RubyFloat)other;
                if (flt.isInfinite()) {
                    if (flt.value > 0.0) {
                        return RubyFixnum.minus_one(context.runtime);
                    }
                    return RubyFixnum.one(context.runtime);
                }
                return RubyBignum.dbl_cmp(context.runtime, RubyBignum.big2dbl(this), flt.value);
            }
            return this.coerceCmp(context, RubyBignum.sites((ThreadContext)context).op_cmp, other);
        }
        return RubyFixnum.newFixnum(context.runtime, this.value.compareTo(otherValue));
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                double a = ((RubyFloat)other).value;
                if (Double.isNaN(a)) {
                    return context.fals;
                }
                return RubyBoolean.newBoolean(context, a == RubyBignum.big2dbl(this));
            }
            return other.op_eqq(context, this);
        }
        return RubyBoolean.newBoolean(context, this.value.compareTo(otherValue) == 0);
    }

    @Override
    public IRubyObject eql_p(IRubyObject other) {
        return this.op_equal(this.metaClass.runtime.getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject eql_p19(IRubyObject other) {
        return this.eql_p(other);
    }

    @Override
    public RubyFixnum hash() {
        Ruby runtime2 = this.metaClass.runtime;
        return RubyFixnum.newFixnum(runtime2, RubyBignum.bigHash(runtime2, this.value));
    }

    @Override
    public int hashCode() {
        return (int)RubyBignum.bigHash(this.getRuntime(), this.value);
    }

    private static long bigHash(Ruby runtime2, BigInteger value2) {
        return Helpers.multAndMix(runtime2.getHashSeedK0(), value2.hashCode());
    }

    @Override
    public IRubyObject to_f(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getDoubleValue());
    }

    @Override
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @Deprecated
    public IRubyObject abs() {
        return this.abs(this.metaClass.runtime.getCurrentContext());
    }

    @Override
    public IRubyObject abs(ThreadContext context) {
        return RubyBignum.newBignum(context.runtime, this.value.abs());
    }

    @Override
    public IRubyObject size(ThreadContext context) {
        return context.runtime.newFixnum((this.value.bitLength() + 7) / 8);
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isZero());
    }

    @Override
    public final boolean isZero() {
        return this.value.equals(BigInteger.ZERO);
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero() ? context.nil : this;
    }

    public static void marshalTo(RubyBignum bignum, MarshalStream output) throws IOException {
        output.registerLinkTarget(bignum);
        output.write(bignum.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = bignum.value.abs();
        byte[] digits2 = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits2.length % 2 != 0 && digits2[0] != 0;
        int shortLength = digits2.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.writeInt(shortLength);
        for (int i2 = 1; i2 <= shortLength * 2 && i2 <= digits2.length; ++i2) {
            output.write(digits2[digits2.length - i2]);
        }
        if (oddLengthNonzeroStart) {
            output.write(0);
        }
    }

    public static RubyNumeric unmarshalFrom(UnmarshalStream input) throws IOException {
        boolean positive = input.readUnsignedByte() == 43;
        int shortLength = input.unmarshalInt();
        byte[] digits2 = new byte[shortLength * 2 + 1];
        for (int i2 = digits2.length - 1; i2 >= 1; --i2) {
            digits2[i2] = input.readSignedByte();
        }
        BigInteger value2 = new BigInteger(digits2);
        if (!positive) {
            value2 = value2.negate();
        }
        return RubyBignum.bignorm(input.getRuntime(), value2);
    }

    @Override
    public IRubyObject fdivDouble(ThreadContext context, IRubyObject y) {
        double dy;
        double dx = this.getDoubleValue();
        if (y instanceof RubyFixnum) {
            long ly = ((RubyFixnum)y).value;
            if (Double.isInfinite(dx)) {
                return this.fdivInt(context.runtime, BigDecimal.valueOf(ly));
            }
            dy = ly;
        } else {
            if (y instanceof RubyBignum) {
                return this.fdivDouble(context, (RubyBignum)y);
            }
            if (y instanceof RubyFloat) {
                dy = ((RubyFloat)y).value;
                if (Double.isNaN(dy)) {
                    return context.runtime.newFloat(dy);
                }
                if (Double.isInfinite(dx)) {
                    return this.fdivFloat(context, (RubyFloat)y);
                }
            } else {
                return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).fdiv, y);
            }
        }
        return context.runtime.newFloat(dx / dy);
    }

    final RubyFloat fdivDouble(ThreadContext context, RubyBignum y) {
        double dx = this.getDoubleValue();
        double dy = RubyBignum.big2dbl(y);
        if (Double.isInfinite(dx) || Double.isInfinite(dy)) {
            return (RubyFloat)this.fdivInt(context, y);
        }
        return context.runtime.newFloat(dx / dy);
    }

    public IRubyObject fdivInt(ThreadContext context, RubyBignum y) {
        return this.fdivInt(context.runtime, new BigDecimal(y.value));
    }

    private RubyFloat fdivInt(Ruby runtime2, BigDecimal y) {
        return runtime2.newFloat(new BigDecimal(this.value).divide(y).doubleValue());
    }

    public IRubyObject fdivFloat(ThreadContext context, RubyFloat y) {
        return context.runtime.newFloat(new BigDecimal(this.value).divide(new BigDecimal(y.value)).doubleValue());
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        CachingCallSite op_lt_site = RubyBignum.sites((ThreadContext)context).basic_op_lt;
        if (op_lt_site.isBuiltin(this.metaClass)) {
            return RubyBoolean.newBoolean(context, this.value.signum() < 0);
        }
        return op_lt_site.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        CachingCallSite op_gt_site = RubyBignum.sites((ThreadContext)context).basic_op_gt;
        if (op_gt_site.isBuiltin(this.metaClass)) {
            return RubyBoolean.newBoolean(context, this.value.signum() > 0);
        }
        return op_gt_site.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = this.value.bitLength() / 8 + 1;
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    public RubyRational convertToRational() {
        Ruby runtime2 = this.getRuntime();
        return RubyRational.newRationalRaw(runtime2, this, RubyFixnum.one(runtime2));
    }

    @Override
    public IRubyObject sqrt(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.isNegative()) {
            throw runtime2.newMathDomainError("Numerical argument is out of domain - isqrt");
        }
        return RubyBignum.bignorm(runtime2, RubyBignum.floorSqrt(this.value));
    }

    private static JavaSites.BignumSites sites(ThreadContext context) {
        return context.sites.Bignum;
    }

    private static enum BIGNUM_OP_T {
        BIGNUM_OP_GT,
        BIGNUM_OP_GE,
        BIGNUM_OP_LT,
        BIGNUM_OP_LE;

    }
}

