/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandles;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.compiler.BlockJITTask;
import org.jruby.compiler.ClassLoaderMode;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.FullBuildTask;
import org.jruby.compiler.JITClassGenerator;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.JITCounts;
import org.jruby.compiler.MethodCompiledJITTask;
import org.jruby.compiler.MethodJITTask;
import org.jruby.compiler.NotCompilableException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakValuedMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JITCompiler.class);
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    final JITCounts counts = new JITCounts();
    private final ExecutorService executor;
    final Ruby runtime;
    final RubyInstanceConfig config;
    final Map<String, ClassDefiningClassLoader> loaderMap;
    static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup().in(Ruby.class);

    public JITCompiler(Ruby runtime2) {
        this.runtime = runtime2;
        this.config = runtime2.getInstanceConfig();
        this.executor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + runtime2.getRuntimeNumber() + "-JIT", 1));
        switch ((ClassLoaderMode)((Object)Options.JIT_LOADER_MODE.load())) {
            case SHARED: {
                this.loaderMap = new SharedClassLoaderMap(new ClassDefiningJRubyClassLoader(runtime2.getJRubyClassLoader()));
                break;
            }
            case SHARED_SOURCE: {
                this.loaderMap = new WeakValuedMap<String, ClassDefiningClassLoader>();
                break;
            }
            default: {
                this.loaderMap = null;
            }
        }
    }

    @Override
    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.counts.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    @Override
    public long getCodeAverageSize() {
        return this.counts.codeAverageSize.get();
    }

    @Override
    public long getCompileTimeAverage() {
        return this.counts.compileTimeAverage.get() / 1000L;
    }

    @Override
    public long getCodeLargestSize() {
        return this.counts.codeLargestSize.get();
    }

    @Override
    public long getIRSize() {
        return this.counts.irSize.get();
    }

    @Override
    public long getIRAverageSize() {
        return this.counts.irAverageSize.get();
    }

    @Override
    public long getIRLargestSize() {
        return this.counts.irLargestSize.get();
    }

    @Override
    public String[] getFrameAwareMethods() {
        Object[] frameAwareMethods = MethodIndex.FRAME_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(frameAwareMethods);
        return frameAwareMethods;
    }

    @Override
    public String[] getScopeAwareMethods() {
        Object[] scopeAwareMethods = MethodIndex.SCOPE_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(scopeAwareMethods);
        return scopeAwareMethods;
    }

    public void tearDown() {
        this.shutdown();
    }

    public void shutdown() {
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public Runnable getTaskFor(ThreadContext context, Compilable method2) {
        if (method2 instanceof MixedModeIRMethod) {
            return new MethodJITTask(this, (MixedModeIRMethod)method2, method2.getOwnerName());
        }
        if (method2 instanceof MixedModeIRBlockBody) {
            return new BlockJITTask(this, (MixedModeIRBlockBody)method2, method2.getOwnerName());
        }
        if (method2 instanceof CompiledIRMethod) {
            return new MethodCompiledJITTask(this, (CompiledIRMethod)method2, method2.getOwnerName());
        }
        return new FullBuildTask(this, method2);
    }

    public void buildThresholdReached(ThreadContext context, Compilable method2) {
        RubyInstanceConfig config = context.runtime.getInstanceConfig();
        Runnable task = this.getTaskFor(context, method2);
        if (task instanceof Task && config.getJitMax() >= 0 && (long)config.getJitMax() < this.getSuccessCount()) {
            if (config.isJitLogging()) {
                JITCompiler.log(method2, method2.getName(), "skipping: jit.max threshold reached", new Object[0]);
            }
            return;
        }
        try {
            if (config.getJitBackground() && config.getJitThreshold() > 0) {
                try {
                    this.executor.submit(task);
                }
                catch (RejectedExecutionException ree) {
                    task.run();
                }
            } else {
                method2.ensureInstrsReady();
                task.run();
            }
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NotCompilableException(e);
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            StringBuilder builder = new StringBuilder();
            for (byte aByte : sha1.digest()) {
                builder.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassDefiningClassLoader getLoaderFor(String source2) {
        if (source2 != null && this.loaderMap != null) {
            ClassDefiningClassLoader loader = this.loaderMap.get(source2);
            if (loader == null) {
                Map<String, ClassDefiningClassLoader> map2 = this.loaderMap;
                synchronized (map2) {
                    loader = this.loaderMap.get(source2);
                    if (loader == null) {
                        loader = new ClassDefiningJRubyClassLoader(this.runtime.getJRubyClassLoader());
                        this.loaderMap.put(source2, loader);
                    }
                }
            }
            return loader;
        }
        return new OneShotClassLoader(this.runtime.getJRubyClassLoader());
    }

    static void log(Compilable<?> target2, String name2, String message2, Object ... reason2) {
        String className = target2.getImplementationClass().getName();
        StringBuilder builder = new StringBuilder(32);
        builder.append(message2).append(": ").append(className);
        if (name2 != null) {
            builder.append(' ').append(name2);
        }
        builder.append(" at ").append(target2.getFile()).append(':').append(target2.getLine());
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (Object aReason : reason2) {
                builder.append(aReason);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }

    private static class SharedClassLoaderMap
    extends AbstractMap<String, ClassDefiningClassLoader> {
        final ClassDefiningClassLoader value;

        SharedClassLoaderMap(ClassDefiningClassLoader value2) {
            this.value = value2;
        }

        @Override
        public ClassDefiningClassLoader get(Object key2) {
            return this.value;
        }

        @Override
        public ClassDefiningClassLoader put(String key2, ClassDefiningClassLoader value2) {
            return this.value;
        }

        @Override
        public int size() {
            return -1;
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<Map.Entry<String, ClassDefiningClassLoader>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class Task
    implements Runnable {
        protected final JITCompiler jitCompiler;

        public Task(JITCompiler jitCompiler) {
            this.jitCompiler = jitCompiler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JITCompiler jITCompiler = this.jitCompiler;
            synchronized (jITCompiler) {
                try {
                    this.exec();
                }
                catch (Throwable ex) {
                    this.jitFailed(ex);
                }
            }
        }

        protected abstract void exec() throws Exception;

        protected String getSourceFile() {
            return null;
        }

        protected void jitFailed(Throwable ex) {
            if (this.jitCompiler.config.isJitLogging()) {
                this.logFailed(ex);
                if (this.jitCompiler.config.isJitLoggingVerbose()) {
                    ex.printStackTrace();
                }
            }
            this.jitCompiler.counts.failCount.incrementAndGet();
        }

        protected Class<?> defineClass(JITClassGenerator generator, JVMVisitor visitor, IRScope scope, InterpreterContext interpreterContext) {
            Class sourceClass = visitor.defineFromBytecode(scope, generator.bytecode(), this.getCodeLoader());
            if (sourceClass == null) {
                this.jitCompiler.counts.failCount.incrementAndGet();
                return null;
            }
            generator.updateCounters(this.jitCompiler.counts, interpreterContext);
            long methodCount = this.jitCompiler.counts.successCount.incrementAndGet();
            if (this.jitCompiler.config.isJitLogging()) {
                this.logJitted();
            }
            if (this.jitCompiler.config.getJitLogEvery() > 0 && methodCount % (long)this.jitCompiler.config.getJitLogEvery() == 0L) {
                this.logImpl("live compiled count: " + methodCount, new Object[0]);
            }
            return sourceClass;
        }

        ClassDefiningClassLoader getCodeLoader() {
            return this.jitCompiler.getLoaderFor(this.getSourceFile());
        }

        protected void logJitted() {
            this.logImpl("done jitting", new Object[0]);
        }

        protected void logFailed(Throwable ex) {
            this.logImpl("could not compile", ex);
        }

        protected abstract void logImpl(String var1, Object ... var2);
    }
}

