/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.util.ArraysUtil;
import jodd.util.ClassUtil;

public class Methods {
    protected final ClassDescriptor classDescriptor;
    protected final HashMap<String, MethodDescriptor[]> methodsMap;
    private MethodDescriptor[] allMethods;

    public Methods(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.methodsMap = this.inspectMethods();
    }

    protected HashMap<String, MethodDescriptor[]> inspectMethods() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        Class type = this.classDescriptor.getType();
        Method[] methods = scanAccessible ? ClassUtil.getAccessibleMethods((Class)type) : ClassUtil.getSupportedMethods((Class)type);
        HashMap<String, MethodDescriptor[]> map = new HashMap<String, MethodDescriptor[]>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            Object[] mds = map.get(methodName);
            mds = mds == null ? new MethodDescriptor[1] : (MethodDescriptor[])ArraysUtil.resize((Object[])mds, (int)(mds.length + 1));
            map.put(methodName, (MethodDescriptor[])mds);
            mds[mds.length - 1] = this.createMethodDescriptor(method);
        }
        return map;
    }

    protected MethodDescriptor createMethodDescriptor(Method method) {
        return new MethodDescriptor(this.classDescriptor, method);
    }

    public MethodDescriptor getMethodDescriptor(String name, Class[] paramTypes) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            Method m = methodDescriptor.getMethod();
            if (!ClassUtil.compareParameters((Class[])m.getParameterTypes(), (Class[])paramTypes)) continue;
            return methodDescriptor;
        }
        return null;
    }

    public MethodDescriptor getMethodDescriptor(String name) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        if (methodDescriptors.length != 1) {
            throw new IllegalArgumentException("Method name not unique: " + name);
        }
        return methodDescriptors[0];
    }

    public MethodDescriptor[] getAllMethodDescriptors(String name) {
        return this.methodsMap.get(name);
    }

    public MethodDescriptor[] getAllMethodDescriptors() {
        if (this.allMethods == null) {
            ArrayList allMethodsList = new ArrayList();
            for (MethodDescriptor[] methodDescriptors : this.methodsMap.values()) {
                Collections.addAll(allMethodsList, methodDescriptors);
            }
            MethodDescriptor[] allMethods = allMethodsList.toArray(new MethodDescriptor[0]);
            Arrays.sort(allMethods, new Comparator<MethodDescriptor>(){

                @Override
                public int compare(MethodDescriptor md1, MethodDescriptor md2) {
                    return md1.getMethod().getName().compareTo(md2.getMethod().getName());
                }
            });
            this.allMethods = allMethods;
        }
        return this.allMethods;
    }
}

