/* The following code was generated by JFlex 1.7.0-SNAPSHOT tweaked for IntelliJ platform */

package org.intellij.markdown.lexer;

import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.lexer.GeneratedLexer;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

/* Auto generated File */

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0-SNAPSHOT
 * from the specification file <code>markdown.flex</code>
 */
public class _MarkdownLexer implements GeneratedLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int TAG_START = 2;
  public static final int AFTER_LINE_START = 4;
  public static final int PARSE_DELIMITED = 6;
  public static final int CODE = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  1, 1
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [9, 6, 6]
   * Total runtime size is 1568 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[ZZ_CMAP_Z[ch>>12]|((ch>>6)&0x3f)]<<6)|(ch&0x3f)];
  }

  /* The ZZ_CMAP_Z table has 272 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\100\1\200\u010d\100");

  /* The ZZ_CMAP_Y table has 192 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\175\3\1\4\77\3");

  /* The ZZ_CMAP_A table has 320 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\3\1\6\1\4\1\5\1\7\22\0\1\3\1\14\1\10\4\40\1\12\2\42\1\41\1\40\1\37"+
    "\1\15\1\36\1\33\12\1\1\27\1\0\1\13\1\32\1\16\1\17\1\35\1\24\1\20\1\22\1\23"+
    "\17\20\1\25\6\20\1\21\1\11\1\26\1\34\1\30\1\31\32\2\1\40\1\34\2\40\6\0\1\4"+
    "\242\0\2\4\26\0");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\3\1\1\2\2\3\1\4\1\5\1\6\1\3"+
    "\1\6\1\7\1\10\1\11\1\12\2\13\1\1\2\13"+
    "\1\0\1\1\3\0\2\14\1\15\1\16\7\0\1\1"+
    "\1\15\3\0\1\17\12\0\1\1\14\0\1\20\2\0"+
    "\1\21\3\0\1\17\5\0\1\20\22\0\1\20\20\0"+
    "\1\17\2\0\1\17\74\0\1\17\u0172\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[553];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\43\0\106\0\151\0\214\0\257\0\322\0\214"+
    "\0\214\0\365\0\u0118\0\u013b\0\214\0\u015e\0\u0181\0\214"+
    "\0\214\0\214\0\u01a4\0\214\0\u01c7\0\u01c7\0\u01ea\0\u0181"+
    "\0\u020d\0\u020d\0\u0230\0\u0253\0\u0276\0\214\0\u0299\0\214"+
    "\0\u02bc\0\u02df\0\u0302\0\u0325\0\u0348\0\u036b\0\u01c7\0\u038e"+
    "\0\u038e\0\u0276\0\u03b1\0\u03d4\0\u03f7\0\214\0\u041a\0\u043d"+
    "\0\u0460\0\u0483\0\u04a6\0\u04c9\0\u04ec\0\u050f\0\u0532\0\u0555"+
    "\0\u0555\0\u0578\0\u059b\0\u05be\0\u05e1\0\u0604\0\u0627\0\u064a"+
    "\0\u066d\0\u0690\0\u06b3\0\u06d6\0\u06f9\0\214\0\u071c\0\u073f"+
    "\0\214\0\u0762\0\u0785\0\u07a8\0\u0762\0\u07cb\0\u07ee\0\u0811"+
    "\0\u0834\0\u0857\0\u04c9\0\u087a\0\u089d\0\u08c0\0\u08e3\0\u0906"+
    "\0\u0929\0\u094c\0\u096f\0\u0992\0\u09b5\0\u09d8\0\u09fb\0\u0a1e"+
    "\0\u0a41\0\u0a64\0\u0a87\0\u0aaa\0\u0acd\0\u0762\0\u0af0\0\u0b13"+
    "\0\u0b36\0\u0b59\0\u0b7c\0\u0b9f\0\u0bc2\0\u0be5\0\u0c08\0\u0c2b"+
    "\0\u0c4e\0\u0c71\0\u0c94\0\u0cb7\0\u0cda\0\u0cfd\0\u08e3\0\u0d20"+
    "\0\u0d43\0\u0906\0\u0d66\0\u0d89\0\u0dac\0\u0dcf\0\u0df2\0\u0e15"+
    "\0\u0e38\0\u0e5b\0\u0e7e\0\u0ea1\0\u0ec4\0\u0ee7\0\u0f0a\0\u0f2d"+
    "\0\u0f50\0\u0f73\0\u0f96\0\u0fb9\0\u0fdc\0\u0fff\0\u1022\0\u1045"+
    "\0\u1068\0\u108b\0\u10ae\0\u10d1\0\u10f4\0\u1117\0\u113a\0\u115d"+
    "\0\u1180\0\u11a3\0\u11c6\0\u11e9\0\u120c\0\u122f\0\u1252\0\u1275"+
    "\0\u1298\0\u12bb\0\u12de\0\u1301\0\u1324\0\u1347\0\u136a\0\u138d"+
    "\0\u13b0\0\u13d3\0\u13f6\0\u1419\0\u143c\0\u145f\0\u1482\0\u14a5"+
    "\0\u14c8\0\u14eb\0\u150e\0\u1531\0\u1554\0\u1577\0\u11e9\0\u159a"+
    "\0\u15bd\0\u15e0\0\u1603\0\u1626\0\u1649\0\u166c\0\u168f\0\u16b2"+
    "\0\u16d5\0\u16f8\0\u171b\0\u173e\0\u1761\0\u1784\0\u17a7\0\u17ca"+
    "\0\u17ed\0\u1810\0\u1833\0\u1856\0\u1879\0\u189c\0\u18bf\0\u18e2"+
    "\0\u1905\0\u1928\0\u194b\0\u196e\0\u1991\0\u19b4\0\u19d7\0\u19fa"+
    "\0\u1a1d\0\u1a40\0\u1a63\0\u1a86\0\u1aa9\0\u1acc\0\u1aef\0\u1b12"+
    "\0\u1b35\0\u1b58\0\u1b7b\0\u1b9e\0\u1bc1\0\u1be4\0\u1c07\0\u1c2a"+
    "\0\u1c4d\0\u1c70\0\u1c93\0\u1cb6\0\u1cd9\0\u1cfc\0\u1d1f\0\u1d42"+
    "\0\u1d65\0\u1d88\0\u1dab\0\u1dce\0\u1df1\0\u1e14\0\u1e37\0\u1e5a"+
    "\0\u1e7d\0\u1ea0\0\u1ec3\0\u1ee6\0\u1f09\0\u1f2c\0\u1f4f\0\u1f72"+
    "\0\u1f95\0\u1fb8\0\u1fdb\0\u1ffe\0\u2021\0\u2044\0\u2067\0\u208a"+
    "\0\u20ad\0\u20d0\0\u20f3\0\u2116\0\u2139\0\u215c\0\u217f\0\u21a2"+
    "\0\u21c5\0\u21e8\0\u220b\0\u222e\0\u2251\0\u2274\0\u2297\0\u22ba"+
    "\0\u22dd\0\u2300\0\u2323\0\u2346\0\u2369\0\u238c\0\u23af\0\u23d2"+
    "\0\u23f5\0\u2418\0\u243b\0\u245e\0\u2481\0\u24a4\0\u24c7\0\u24ea"+
    "\0\u250d\0\u2530\0\u2553\0\u2576\0\u2599\0\u25bc\0\u25df\0\u2602"+
    "\0\u2625\0\u2648\0\u266b\0\u268e\0\u26b1\0\u26d4\0\u26f7\0\u271a"+
    "\0\u273d\0\u2760\0\u2783\0\u27a6\0\u27c9\0\u27ec\0\u280f\0\u2832"+
    "\0\u2855\0\u2878\0\u289b\0\u28be\0\u28e1\0\u2904\0\u2927\0\u294a"+
    "\0\u296d\0\u2990\0\u29b3\0\u29d6\0\u29f9\0\u2a1c\0\u2a3f\0\u2a62"+
    "\0\u2a85\0\u2aa8\0\u2acb\0\u2aee\0\u2b11\0\u2b34\0\u2b57\0\u2b7a"+
    "\0\u2b9d\0\u2bc0\0\u2be3\0\u2c06\0\u2c29\0\u2c4c\0\u2c6f\0\u2c92"+
    "\0\u2cb5\0\u2cd8\0\u2cfb\0\u2d1e\0\u2d41\0\u2d64\0\u2d87\0\u2daa"+
    "\0\u2dcd\0\u2df0\0\u2e13\0\u2e36\0\u2e59\0\u2e7c\0\u2e9f\0\u2ec2"+
    "\0\u2ee5\0\u2f08\0\u2f2b\0\u2f4e\0\u2f71\0\u2f94\0\u2fb7\0\u2fda"+
    "\0\u2ffd\0\u3020\0\u3043\0\u3066\0\u3089\0\u30ac\0\u30cf\0\u30f2"+
    "\0\u3115\0\u3138\0\u315b\0\u317e\0\u31a1\0\u31c4\0\u31e7\0\u320a"+
    "\0\u322d\0\u3250\0\u3273\0\u3296\0\u32b9\0\u32dc\0\u32ff\0\u3322"+
    "\0\u3345\0\u3368\0\u338b\0\u33ae\0\u33d1\0\u33f4\0\u3417\0\u343a"+
    "\0\u345d\0\u3480\0\u34a3\0\u34c6\0\u34e9\0\u350c\0\u352f\0\u3552"+
    "\0\u3575\0\u3598\0\u35bb\0\u35de\0\u3601\0\u3624\0\u3647\0\u366a"+
    "\0\u368d\0\u36b0\0\u36d3\0\u36f6\0\u3719\0\u373c\0\u375f\0\u3782"+
    "\0\u37a5\0\u37c8\0\u37eb\0\u380e\0\u3831\0\u3854\0\u3877\0\u389a"+
    "\0\u38bd\0\u38e0\0\u3903\0\u3926\0\u3949\0\u396c\0\u398f\0\u39b2"+
    "\0\u39d5\0\u39f8\0\u3a1b\0\u3a3e\0\u3a61\0\u3a84\0\u3aa7\0\u3aca"+
    "\0\u3aed\0\u3b10\0\u3b33\0\u3b56\0\u3b79\0\u3b9c\0\u3bbf\0\u3be2"+
    "\0\u3c05\0\u3c28\0\u3c4b\0\u3c6e\0\u3c91\0\u3cb4\0\u3cd7\0\u3cfa"+
    "\0\u3d1d\0\u3d40\0\u3d63\0\u3d86\0\u3da9\0\u3dcc\0\u3def\0\u3e12"+
    "\0\u3e35\0\u3e58\0\u3e7b\0\u3e9e\0\u3ec1\0\u3ee4\0\u3f07\0\u3f2a"+
    "\0\u3f4d\0\u3f70\0\u3f93\0\u3fb6\0\u3fd9\0\u3ffc\0\u401f\0\u4042"+
    "\0\u4065\0\u4088\0\u40ab\0\u40ce\0\u40f1\0\u4114\0\u4137\0\u415a"+
    "\0\u417d\0\u41a0\0\u41c3\0\u41e6\0\u4209\0\u422c\0\u424f\0\u4272"+
    "\0\u4295\0\u42b8\0\u42db\0\u42fe\0\u4321\0\u4344\0\u4367\0\u438a"+
    "\0\u43ad\0\u43d0\0\u43f3\0\u4416\0\u4439\0\u445c\0\u447f\0\u44a2"+
    "\0\u44c5\0\u44e8\0\u450b\0\u452e\0\u4551\0\u4574\0\u4597\0\u45ba"+
    "\0\u45dd\0\u4600\0\u4623\0\u4646\0\u4669\0\u468c\0\u46af\0\u46d2"+
    "\0\u46f5\0\u4718\0\u473b\0\u475e\0\u4781\0\u47a4\0\u47c7\0\u47ea"+
    "\0\u480d";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[553];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\5\1\6\1\5\1\6\1\5\1\7\6\5\1\10"+
    "\24\5\44\11\2\12\1\13\1\14\1\13\2\14\1\15"+
    "\1\16\1\15\1\17\1\20\1\11\1\15\1\11\1\12"+
    "\1\15\4\12\1\15\1\21\1\22\1\23\7\11\1\22"+
    "\1\15\3\24\1\25\1\5\1\26\1\5\1\7\1\24"+
    "\1\27\1\24\1\30\14\24\1\22\1\23\7\24\1\22"+
    "\1\24\46\0\1\31\1\5\1\32\1\5\1\7\6\0"+
    "\1\10\32\0\1\5\35\0\2\12\1\33\1\0\1\33"+
    "\12\0\1\12\1\0\4\12\2\0\1\34\15\0\1\13"+
    "\1\14\1\13\2\14\20\0\1\35\10\0\1\35\4\0"+
    "\5\14\37\0\3\36\1\37\7\40\2\0\1\40\4\0"+
    "\3\40\1\41\1\0\1\40\1\0\6\40\1\0\1\42"+
    "\1\43\7\0\1\42\1\0\1\44\1\42\1\0\1\45"+
    "\1\43\1\0\4\43\2\0\3\42\1\46\1\42\1\0"+
    "\1\42\1\0\2\42\32\0\1\23\14\0\1\47\1\0"+
    "\1\47\22\0\1\35\10\0\1\35\11\0\7\40\2\0"+
    "\1\40\4\0\3\40\1\41\1\0\1\40\1\0\6\40"+
    "\3\0\1\50\1\5\1\51\1\5\1\7\6\0\1\10"+
    "\25\0\2\12\1\33\1\0\1\33\12\0\1\12\1\0"+
    "\4\12\16\0\2\12\15\0\1\12\1\0\4\12\2\0"+
    "\1\34\15\0\1\52\1\0\1\52\43\0\1\36\65\0"+
    "\1\41\12\0\2\42\7\0\1\42\1\0\2\42\1\0"+
    "\2\42\1\0\4\42\2\0\5\42\1\53\1\42\1\0"+
    "\2\42\2\0\1\54\1\43\1\55\1\0\1\55\4\0"+
    "\1\42\1\0\2\42\1\56\1\42\1\43\1\0\4\43"+
    "\1\0\1\57\3\42\1\60\1\42\1\53\1\42\1\0"+
    "\2\42\2\0\2\42\7\0\1\42\1\0\1\42\1\61"+
    "\1\0\1\42\1\62\1\63\4\62\2\0\5\42\1\53"+
    "\1\42\1\0\2\42\1\0\1\64\2\45\7\64\1\45"+
    "\1\64\2\45\1\64\1\65\1\45\1\64\4\45\2\64"+
    "\5\45\1\66\1\45\1\64\2\45\1\64\1\0\1\42"+
    "\1\67\7\0\1\42\1\0\2\42\1\0\1\42\1\67"+
    "\1\0\4\67\2\0\5\42\1\53\1\42\1\0\2\42"+
    "\4\0\1\70\1\5\1\71\1\5\1\7\6\0\1\10"+
    "\25\0\2\72\15\0\1\72\1\0\4\72\16\0\2\54"+
    "\1\55\1\0\1\55\4\0\1\42\1\0\2\42\1\56"+
    "\1\42\1\54\1\0\4\54\2\0\3\42\1\60\1\42"+
    "\1\53\1\42\1\0\2\42\3\0\1\73\1\55\1\0"+
    "\1\55\7\0\1\73\1\56\1\0\1\73\1\0\4\73"+
    "\1\0\1\73\3\0\1\74\7\0\3\75\1\0\1\75"+
    "\2\0\4\75\1\0\2\75\1\0\24\75\1\0\2\42"+
    "\7\0\1\42\1\0\2\42\1\56\2\42\1\0\4\42"+
    "\2\0\5\42\1\53\1\42\1\0\2\42\2\0\2\42"+
    "\7\0\1\42\1\0\1\42\1\76\1\0\2\42\1\0"+
    "\4\42\2\0\5\42\1\53\1\42\1\0\2\42\2\0"+
    "\2\42\1\77\1\0\1\77\4\0\1\42\1\0\2\42"+
    "\1\0\1\42\1\62\1\0\4\62\2\0\5\42\1\53"+
    "\1\42\1\0\2\42\23\0\1\100\20\0\17\64\1\101"+
    "\24\64\2\45\7\64\1\45\1\64\2\45\1\56\2\45"+
    "\1\64\4\45\2\64\5\45\1\66\1\45\1\64\2\45"+
    "\2\64\2\102\14\64\1\101\1\102\1\64\4\102\15\64"+
    "\1\0\2\67\1\103\1\0\1\103\4\0\1\42\1\0"+
    "\2\42\1\56\1\42\1\67\1\0\4\67\2\0\5\42"+
    "\1\53\1\42\1\0\2\42\4\0\1\70\1\5\1\71"+
    "\1\5\1\7\34\0\2\104\12\0\1\105\1\106\1\0"+
    "\1\104\1\0\4\104\10\0\1\53\5\0\2\73\1\107"+
    "\1\0\1\107\7\0\1\73\1\56\1\0\1\73\1\0"+
    "\4\73\1\0\2\73\1\0\1\110\1\74\2\0\1\73"+
    "\22\0\1\56\24\0\3\75\1\0\1\75\2\0\4\75"+
    "\1\0\2\75\1\111\24\75\1\112\2\113\7\112\1\113"+
    "\1\112\1\113\1\114\1\115\2\113\1\112\4\113\2\112"+
    "\5\113\1\116\1\113\1\112\2\113\1\112\3\74\1\117"+
    "\1\74\1\117\10\74\1\0\24\74\23\0\1\120\17\0"+
    "\16\64\1\56\25\64\2\121\12\64\1\122\1\123\1\101"+
    "\1\121\1\64\4\121\10\64\1\66\4\64\3\0\1\103"+
    "\1\0\1\103\10\0\1\56\25\0\2\124\12\0\1\125"+
    "\1\106\1\0\1\124\1\0\4\124\10\0\1\53\5\0"+
    "\2\124\12\0\1\125\2\0\1\124\1\0\4\124\17\0"+
    "\1\73\1\107\1\0\1\107\7\0\1\73\1\56\1\0"+
    "\1\73\1\0\4\73\1\0\1\73\2\0\1\110\1\74"+
    "\7\0\3\126\1\110\1\126\1\110\2\0\1\127\1\126"+
    "\1\130\1\0\2\126\1\0\12\126\2\0\10\126\15\112"+
    "\1\131\26\112\2\113\7\112\1\113\1\112\1\113\1\132"+
    "\1\112\2\113\1\112\4\113\2\112\5\113\1\116\1\113"+
    "\1\112\2\113\2\112\2\113\7\112\1\113\1\112\1\113"+
    "\1\60\1\115\2\113\1\112\4\113\2\112\5\113\1\116"+
    "\1\113\1\112\2\113\2\112\2\133\12\112\1\131\2\112"+
    "\1\133\1\112\4\133\15\112\3\74\1\117\1\74\1\117"+
    "\10\74\1\56\24\74\24\0\1\134\16\0\1\64\2\135"+
    "\12\64\1\136\1\123\1\101\1\135\1\64\4\135\10\64"+
    "\1\66\5\64\2\135\12\64\1\136\1\64\1\101\1\135"+
    "\1\64\4\135\15\64\1\0\2\137\12\0\1\140\1\106"+
    "\1\0\1\137\1\0\4\137\10\0\1\53\5\0\2\137"+
    "\12\0\1\140\2\0\1\137\1\0\4\137\15\0\3\126"+
    "\1\55\1\126\1\55\3\0\1\126\2\0\2\126\1\56"+
    "\12\126\2\0\10\126\6\127\1\0\1\127\1\141\1\142"+
    "\31\127\6\130\1\0\2\130\1\143\1\141\30\130\15\112"+
    "\1\74\26\112\2\113\7\112\1\113\1\112\1\113\1\60"+
    "\1\112\2\113\1\112\4\113\2\112\5\113\1\116\1\113"+
    "\1\112\2\113\2\112\2\144\12\112\1\145\1\146\1\112"+
    "\1\144\1\112\4\144\10\112\1\116\4\112\25\0\1\147"+
    "\15\0\1\64\2\150\12\64\1\151\1\123\1\101\1\150"+
    "\1\64\4\150\10\64\1\66\5\64\2\150\12\64\1\151"+
    "\1\64\1\101\1\150\1\64\4\150\15\64\1\0\2\152"+
    "\12\0\1\153\1\106\1\0\1\152\1\0\4\152\10\0"+
    "\1\53\5\0\2\152\12\0\1\153\2\0\1\152\1\0"+
    "\4\152\20\0\1\55\1\0\1\55\10\0\1\56\14\0"+
    "\1\74\7\0\6\127\1\0\1\127\1\154\1\142\31\127"+
    "\6\130\1\0\2\130\1\143\1\155\30\130\1\112\2\156"+
    "\12\112\1\157\1\146\1\112\1\156\1\112\4\156\10\112"+
    "\1\116\5\112\2\156\12\112\1\160\2\112\1\156\1\112"+
    "\4\156\15\112\24\0\1\161\16\0\1\64\2\162\12\64"+
    "\1\163\1\123\1\101\1\162\1\64\4\162\10\64\1\66"+
    "\5\64\2\162\12\64\1\163\1\64\1\101\1\162\1\64"+
    "\4\162\15\64\1\0\2\164\12\0\1\165\1\106\1\0"+
    "\1\164\1\0\4\164\10\0\1\53\5\0\2\164\12\0"+
    "\1\165\2\0\1\164\1\0\4\164\15\0\3\127\1\166"+
    "\1\127\1\166\1\0\1\127\1\141\1\142\4\127\1\167"+
    "\14\127\1\170\7\127\3\130\1\171\1\130\1\171\1\0"+
    "\2\130\1\143\1\141\3\130\1\172\14\130\1\173\7\130"+
    "\1\112\2\174\12\112\1\175\1\146\1\112\1\174\1\112"+
    "\4\174\10\112\1\116\5\112\2\174\12\112\1\176\2\112"+
    "\1\174\1\112\4\174\15\112\1\0\2\137\12\0\1\140"+
    "\1\56\1\0\1\137\1\0\4\137\36\0\1\177\21\0"+
    "\1\64\2\200\12\64\1\201\1\123\1\101\1\200\1\64"+
    "\4\200\10\64\1\66\5\64\2\200\12\64\1\201\1\64"+
    "\1\101\1\200\1\64\4\200\15\64\1\0\2\202\12\0"+
    "\1\203\1\106\1\0\1\202\1\0\4\202\10\0\1\53"+
    "\5\0\2\202\12\0\1\203\2\0\1\202\1\0\4\202"+
    "\15\0\2\127\1\204\1\166\1\127\1\166\1\0\1\127"+
    "\1\141\1\142\3\127\1\204\1\167\1\127\1\204\1\127"+
    "\4\204\1\127\1\204\3\127\1\170\15\127\1\0\1\127"+
    "\1\141\1\142\4\127\1\167\24\127\2\130\1\205\1\171"+
    "\1\130\1\171\1\0\2\130\1\143\1\141\2\130\1\205"+
    "\1\172\1\130\1\205\1\130\4\205\1\130\1\205\3\130"+
    "\1\173\15\130\1\0\2\130\1\143\1\141\3\130\1\172"+
    "\24\130\1\112\2\206\12\112\1\207\1\146\1\112\1\206"+
    "\1\112\4\206\10\112\1\116\5\112\2\206\12\112\1\210"+
    "\2\112\1\206\1\112\4\206\15\112\1\0\2\152\12\0"+
    "\1\153\1\56\1\0\1\152\1\0\4\152\15\0\26\177"+
    "\1\211\14\177\1\64\2\212\12\64\1\213\1\123\1\101"+
    "\1\212\1\64\4\212\10\64\1\66\5\64\2\212\12\64"+
    "\1\213\1\64\1\101\1\212\1\64\4\212\15\64\1\0"+
    "\2\214\12\0\1\215\1\106\1\0\1\214\1\0\4\214"+
    "\10\0\1\53\5\0\2\214\12\0\1\215\2\0\1\214"+
    "\1\0\4\214\15\0\1\127\2\204\1\216\1\127\1\216"+
    "\1\0\1\127\1\141\1\142\3\127\1\204\1\167\1\127"+
    "\1\204\1\127\4\204\1\127\2\204\1\127\1\217\1\170"+
    "\2\127\1\204\4\127\1\130\2\205\1\220\1\130\1\220"+
    "\1\0\2\130\1\143\1\141\2\130\1\205\1\172\1\130"+
    "\1\205\1\130\4\205\1\130\2\205\1\130\1\221\1\173"+
    "\2\130\1\205\4\130\1\112\2\222\12\112\1\223\1\146"+
    "\1\112\1\222\1\112\4\222\10\112\1\116\5\112\2\222"+
    "\12\112\1\224\2\112\1\222\1\112\4\222\15\112\1\0"+
    "\2\164\12\0\1\165\1\56\1\0\1\164\1\0\4\164"+
    "\15\0\26\177\1\225\14\177\1\64\2\226\12\64\1\227"+
    "\1\123\1\101\1\226\1\64\4\226\10\64\1\66\5\64"+
    "\2\226\12\64\1\227\1\64\1\101\1\226\1\64\4\226"+
    "\15\64\1\0\2\230\12\0\1\231\1\106\1\0\1\230"+
    "\1\0\4\230\10\0\1\53\5\0\2\230\12\0\1\231"+
    "\2\0\1\230\1\0\4\230\15\0\2\127\1\204\1\216"+
    "\1\127\1\216\1\0\1\127\1\141\1\142\3\127\1\204"+
    "\1\167\1\127\1\204\1\127\4\204\1\127\1\204\2\127"+
    "\1\217\1\170\7\127\3\232\1\217\1\232\1\217\1\0"+
    "\1\127\1\154\1\233\1\234\1\127\2\232\1\127\12\232"+
    "\2\127\10\232\2\130\1\205\1\220\1\130\1\220\1\0"+
    "\2\130\1\143\1\141\2\130\1\205\1\172\1\130\1\205"+
    "\1\130\4\205\1\130\1\205\2\130\1\221\1\173\7\130"+
    "\3\235\1\221\1\235\1\221\1\0\1\130\1\234\1\236"+
    "\1\155\1\130\2\235\1\130\12\235\2\130\10\235\1\112"+
    "\2\237\12\112\1\240\1\146\1\112\1\237\1\112\4\237"+
    "\10\112\1\116\5\112\2\237\12\112\1\241\2\112\1\237"+
    "\1\112\4\237\15\112\1\0\2\202\12\0\1\203\1\56"+
    "\1\0\1\202\1\0\4\202\15\0\16\177\1\56\24\177"+
    "\1\64\2\242\12\64\1\243\1\123\1\101\1\242\1\64"+
    "\4\242\10\64\1\66\5\64\2\242\12\64\1\243\1\64"+
    "\1\101\1\242\1\64\4\242\15\64\1\0\2\244\12\0"+
    "\1\245\1\106\1\0\1\244\1\0\4\244\10\0\1\53"+
    "\5\0\2\244\12\0\1\245\2\0\1\244\1\0\4\244"+
    "\15\0\3\232\1\166\1\232\1\166\1\0\1\127\1\141"+
    "\1\233\2\127\2\232\1\167\12\232\2\127\13\232\1\166"+
    "\1\232\1\166\1\0\1\127\1\154\1\233\2\127\2\232"+
    "\1\167\12\232\2\127\10\232\6\234\1\0\1\234\1\155"+
    "\1\246\1\154\30\234\3\235\1\171\1\235\1\171\1\0"+
    "\2\130\1\236\1\141\1\130\2\235\1\172\12\235\2\130"+
    "\13\235\1\171\1\235\1\171\1\0\2\130\1\236\1\155"+
    "\1\130\2\235\1\172\12\235\2\130\10\235\1\112\2\247"+
    "\12\112\1\250\1\146\1\112\1\247\1\112\4\247\10\112"+
    "\1\116\5\112\2\247\12\112\1\251\2\112\1\247\1\112"+
    "\4\247\15\112\1\0\2\214\12\0\1\215\1\56\1\0"+
    "\1\214\1\0\4\214\15\0\1\64\2\252\12\64\1\253"+
    "\1\123\1\101\1\252\1\64\4\252\10\64\1\66\5\64"+
    "\2\252\12\64\1\253\1\64\1\101\1\252\1\64\4\252"+
    "\15\64\1\0\2\254\12\0\1\255\1\106\1\0\1\254"+
    "\1\0\4\254\10\0\1\53\5\0\2\254\12\0\1\255"+
    "\2\0\1\254\1\0\4\254\15\0\6\234\1\0\1\234"+
    "\1\256\1\246\1\256\30\234\1\112\2\257\12\112\1\260"+
    "\1\146\1\112\1\257\1\112\4\257\10\112\1\116\5\112"+
    "\2\257\12\112\1\261\2\112\1\257\1\112\4\257\15\112"+
    "\1\0\2\230\12\0\1\231\1\56\1\0\1\230\1\0"+
    "\4\230\15\0\1\64\2\262\12\64\1\263\1\123\1\101"+
    "\1\262\1\64\4\262\10\64\1\66\5\64\2\262\12\64"+
    "\1\263\1\64\1\101\1\262\1\64\4\262\15\64\1\0"+
    "\2\264\12\0\1\265\1\106\1\0\1\264\1\0\4\264"+
    "\10\0\1\53\5\0\2\264\12\0\1\265\2\0\1\264"+
    "\1\0\4\264\15\0\3\234\1\266\1\234\1\266\1\0"+
    "\1\234\1\155\1\246\1\154\3\234\1\267\14\234\1\270"+
    "\7\234\1\112\2\271\12\112\1\272\1\146\1\112\1\271"+
    "\1\112\4\271\10\112\1\116\5\112\2\271\12\112\1\273"+
    "\2\112\1\271\1\112\4\271\15\112\1\0\2\244\12\0"+
    "\1\245\1\56\1\0\1\244\1\0\4\244\15\0\1\64"+
    "\2\274\12\64\1\275\1\123\1\101\1\274\1\64\4\274"+
    "\10\64\1\66\5\64\2\274\12\64\1\275\1\64\1\101"+
    "\1\274\1\64\4\274\15\64\1\0\2\276\12\0\1\277"+
    "\1\106\1\0\1\276\1\0\4\276\10\0\1\53\5\0"+
    "\2\276\12\0\1\277\2\0\1\276\1\0\4\276\15\0"+
    "\2\234\1\300\1\266\1\234\1\266\1\0\1\234\1\155"+
    "\1\246\1\154\2\234\1\300\1\267\1\234\1\300\1\234"+
    "\4\300\1\234\1\300\3\234\1\270\15\234\1\0\1\234"+
    "\1\155\1\246\1\154\3\234\1\267\24\234\1\112\2\301"+
    "\12\112\1\302\1\146\1\112\1\301\1\112\4\301\10\112"+
    "\1\116\5\112\2\301\12\112\1\303\2\112\1\301\1\112"+
    "\4\301\15\112\1\0\2\254\12\0\1\255\1\56\1\0"+
    "\1\254\1\0\4\254\15\0\1\64\2\304\12\64\1\305"+
    "\1\123\1\101\1\304\1\64\4\304\10\64\1\66\5\64"+
    "\2\304\12\64\1\305\1\64\1\101\1\304\1\64\4\304"+
    "\15\64\1\0\2\306\12\0\1\307\1\106\1\0\1\306"+
    "\1\0\4\306\10\0\1\53\5\0\2\306\12\0\1\307"+
    "\2\0\1\306\1\0\4\306\15\0\1\234\2\300\1\310"+
    "\1\234\1\310\1\0\1\234\1\155\1\246\1\154\2\234"+
    "\1\300\1\267\1\234\1\300\1\234\4\300\1\234\2\300"+
    "\1\234\1\311\1\270\2\234\1\300\4\234\1\112\2\312"+
    "\12\112\1\313\1\146\1\112\1\312\1\112\4\312\10\112"+
    "\1\116\5\112\2\312\12\112\1\314\2\112\1\312\1\112"+
    "\4\312\15\112\1\0\2\264\12\0\1\265\1\56\1\0"+
    "\1\264\1\0\4\264\15\0\1\64\2\315\12\64\1\316"+
    "\1\123\1\101\1\315\1\64\4\315\10\64\1\66\5\64"+
    "\2\315\12\64\1\316\1\64\1\101\1\315\1\64\4\315"+
    "\15\64\1\0\2\317\12\0\1\320\1\106\1\0\1\317"+
    "\1\0\4\317\10\0\1\53\5\0\2\317\12\0\1\320"+
    "\2\0\1\317\1\0\4\317\15\0\2\234\1\300\1\310"+
    "\1\234\1\310\1\0\1\234\1\155\1\246\1\154\2\234"+
    "\1\300\1\267\1\234\1\300\1\234\4\300\1\234\1\300"+
    "\2\234\1\311\1\270\7\234\3\321\1\311\1\321\1\311"+
    "\1\0\1\234\1\256\1\322\1\256\1\234\2\321\1\234"+
    "\12\321\2\234\10\321\1\112\2\323\12\112\1\324\1\146"+
    "\1\112\1\323\1\112\4\323\10\112\1\116\5\112\2\323"+
    "\12\112\1\325\2\112\1\323\1\112\4\323\15\112\1\0"+
    "\2\276\12\0\1\277\1\56\1\0\1\276\1\0\4\276"+
    "\15\0\1\64\2\326\12\64\1\327\1\123\1\101\1\326"+
    "\1\64\4\326\10\64\1\66\5\64\2\326\12\64\1\327"+
    "\1\64\1\101\1\326\1\64\4\326\15\64\1\0\2\330"+
    "\12\0\1\331\1\106\1\0\1\330\1\0\4\330\10\0"+
    "\1\53\5\0\2\330\12\0\1\331\2\0\1\330\1\0"+
    "\4\330\15\0\3\321\1\266\1\321\1\266\1\0\1\234"+
    "\1\155\1\322\1\154\1\234\2\321\1\267\12\321\2\234"+
    "\13\321\1\266\1\321\1\266\1\0\1\234\1\256\1\322"+
    "\1\256\1\234\2\321\1\267\12\321\2\234\10\321\1\112"+
    "\2\332\12\112\1\333\1\146\1\112\1\332\1\112\4\332"+
    "\10\112\1\116\5\112\2\332\12\112\1\334\2\112\1\332"+
    "\1\112\4\332\15\112\1\0\2\306\12\0\1\307\1\56"+
    "\1\0\1\306\1\0\4\306\15\0\1\64\2\335\12\64"+
    "\1\336\1\123\1\101\1\335\1\64\4\335\10\64\1\66"+
    "\5\64\2\335\12\64\1\336\1\64\1\101\1\335\1\64"+
    "\4\335\15\64\1\0\2\337\12\0\1\340\1\106\1\0"+
    "\1\337\1\0\4\337\10\0\1\53\5\0\2\337\12\0"+
    "\1\340\2\0\1\337\1\0\4\337\15\0\1\112\2\341"+
    "\12\112\1\342\1\146\1\112\1\341\1\112\4\341\10\112"+
    "\1\116\5\112\2\341\12\112\1\343\2\112\1\341\1\112"+
    "\4\341\15\112\1\0\2\317\12\0\1\320\1\56\1\0"+
    "\1\317\1\0\4\317\15\0\1\64\2\344\12\64\1\345"+
    "\1\123\1\101\1\344\1\64\4\344\10\64\1\66\5\64"+
    "\2\344\12\64\1\345\1\64\1\101\1\344\1\64\4\344"+
    "\15\64\1\0\2\346\12\0\1\347\1\106\1\0\1\346"+
    "\1\0\4\346\10\0\1\53\5\0\2\346\12\0\1\347"+
    "\2\0\1\346\1\0\4\346\15\0\1\112\2\350\12\112"+
    "\1\351\1\146\1\112\1\350\1\112\4\350\10\112\1\116"+
    "\5\112\2\350\12\112\1\352\2\112\1\350\1\112\4\350"+
    "\15\112\1\0\2\330\12\0\1\331\1\56\1\0\1\330"+
    "\1\0\4\330\15\0\1\64\2\353\12\64\1\354\1\123"+
    "\1\101\1\353\1\64\4\353\10\64\1\66\5\64\2\353"+
    "\12\64\1\354\1\64\1\101\1\353\1\64\4\353\15\64"+
    "\1\0\2\355\12\0\1\356\1\106\1\0\1\355\1\0"+
    "\4\355\10\0\1\53\5\0\2\355\12\0\1\356\2\0"+
    "\1\355\1\0\4\355\15\0\1\112\2\357\12\112\1\360"+
    "\1\146\1\112\1\357\1\112\4\357\10\112\1\116\5\112"+
    "\2\357\12\112\1\361\2\112\1\357\1\112\4\357\15\112"+
    "\1\0\2\337\12\0\1\340\1\56\1\0\1\337\1\0"+
    "\4\337\15\0\1\64\2\362\12\64\1\363\1\123\1\101"+
    "\1\362\1\64\4\362\10\64\1\66\5\64\2\362\12\64"+
    "\1\363\1\64\1\101\1\362\1\64\4\362\15\64\1\0"+
    "\2\364\12\0\1\365\1\106\1\0\1\364\1\0\4\364"+
    "\10\0\1\53\5\0\2\364\12\0\1\365\2\0\1\364"+
    "\1\0\4\364\15\0\1\112\2\366\12\112\1\367\1\146"+
    "\1\112\1\366\1\112\4\366\10\112\1\116\5\112\2\366"+
    "\12\112\1\370\2\112\1\366\1\112\4\366\15\112\1\0"+
    "\2\346\12\0\1\347\1\56\1\0\1\346\1\0\4\346"+
    "\15\0\1\64\2\371\12\64\1\372\1\123\1\101\1\371"+
    "\1\64\4\371\10\64\1\66\5\64\2\371\12\64\1\372"+
    "\1\64\1\101\1\371\1\64\4\371\15\64\1\0\2\373"+
    "\12\0\1\374\1\106\1\0\1\373\1\0\4\373\10\0"+
    "\1\53\5\0\2\373\12\0\1\374\2\0\1\373\1\0"+
    "\4\373\15\0\1\112\2\375\12\112\1\376\1\146\1\112"+
    "\1\375\1\112\4\375\10\112\1\116\5\112\2\375\12\112"+
    "\1\377\2\112\1\375\1\112\4\375\15\112\1\0\2\355"+
    "\12\0\1\356\1\56\1\0\1\355\1\0\4\355\15\0"+
    "\1\64\2\u0100\12\64\1\u0101\1\123\1\101\1\u0100\1\64"+
    "\4\u0100\10\64\1\66\5\64\2\u0100\12\64\1\u0101\1\64"+
    "\1\101\1\u0100\1\64\4\u0100\15\64\1\0\2\u0102\12\0"+
    "\1\u0103\1\106\1\0\1\u0102\1\0\4\u0102\10\0\1\53"+
    "\5\0\2\u0102\12\0\1\u0103\2\0\1\u0102\1\0\4\u0102"+
    "\15\0\1\112\2\u0104\12\112\1\u0105\1\146\1\112\1\u0104"+
    "\1\112\4\u0104\10\112\1\116\5\112\2\u0104\12\112\1\u0106"+
    "\2\112\1\u0104\1\112\4\u0104\15\112\1\0\2\364\12\0"+
    "\1\365\1\56\1\0\1\364\1\0\4\364\15\0\1\64"+
    "\2\u0107\12\64\1\u0108\1\123\1\101\1\u0107\1\64\4\u0107"+
    "\10\64\1\66\5\64\2\u0107\12\64\1\u0108\1\64\1\101"+
    "\1\u0107\1\64\4\u0107\15\64\1\0\2\u0109\12\0\1\u010a"+
    "\1\106\1\0\1\u0109\1\0\4\u0109\10\0\1\53\5\0"+
    "\2\u0109\12\0\1\u010a\2\0\1\u0109\1\0\4\u0109\15\0"+
    "\1\112\2\u010b\12\112\1\u010c\1\146\1\112\1\u010b\1\112"+
    "\4\u010b\10\112\1\116\5\112\2\u010b\12\112\1\u010d\2\112"+
    "\1\u010b\1\112\4\u010b\15\112\1\0\2\373\12\0\1\374"+
    "\1\56\1\0\1\373\1\0\4\373\15\0\1\64\2\u010e"+
    "\12\64\1\u010f\1\123\1\101\1\u010e\1\64\4\u010e\10\64"+
    "\1\66\5\64\2\u010e\12\64\1\u010f\1\64\1\101\1\u010e"+
    "\1\64\4\u010e\15\64\1\0\2\u0110\12\0\1\u0111\1\106"+
    "\1\0\1\u0110\1\0\4\u0110\10\0\1\53\5\0\2\u0110"+
    "\12\0\1\u0111\2\0\1\u0110\1\0\4\u0110\15\0\1\112"+
    "\2\u0112\12\112\1\u0113\1\146\1\112\1\u0112\1\112\4\u0112"+
    "\10\112\1\116\5\112\2\u0112\12\112\1\u0114\2\112\1\u0112"+
    "\1\112\4\u0112\15\112\1\0\2\u0102\12\0\1\u0103\1\56"+
    "\1\0\1\u0102\1\0\4\u0102\15\0\1\64\2\u0115\12\64"+
    "\1\u0116\1\123\1\101\1\u0115\1\64\4\u0115\10\64\1\66"+
    "\5\64\2\u0115\12\64\1\u0116\1\64\1\101\1\u0115\1\64"+
    "\4\u0115\15\64\1\0\2\u0117\12\0\1\u0118\1\106\1\0"+
    "\1\u0117\1\0\4\u0117\10\0\1\53\5\0\2\u0117\12\0"+
    "\1\u0118\2\0\1\u0117\1\0\4\u0117\15\0\1\112\2\u0119"+
    "\12\112\1\u011a\1\146\1\112\1\u0119\1\112\4\u0119\10\112"+
    "\1\116\5\112\2\u0119\12\112\1\u011b\2\112\1\u0119\1\112"+
    "\4\u0119\15\112\1\0\2\u0109\12\0\1\u010a\1\56\1\0"+
    "\1\u0109\1\0\4\u0109\15\0\1\64\2\u011c\12\64\1\u011d"+
    "\1\123\1\101\1\u011c\1\64\4\u011c\10\64\1\66\5\64"+
    "\2\u011c\12\64\1\u011d\1\64\1\101\1\u011c\1\64\4\u011c"+
    "\15\64\1\0\2\u011e\12\0\1\u011f\1\106\1\0\1\u011e"+
    "\1\0\4\u011e\10\0\1\53\5\0\2\u011e\12\0\1\u011f"+
    "\2\0\1\u011e\1\0\4\u011e\15\0\1\112\2\u0120\12\112"+
    "\1\u0121\1\146\1\112\1\u0120\1\112\4\u0120\10\112\1\116"+
    "\5\112\2\u0120\12\112\1\u0122\2\112\1\u0120\1\112\4\u0120"+
    "\15\112\1\0\2\u0110\12\0\1\u0111\1\56\1\0\1\u0110"+
    "\1\0\4\u0110\15\0\1\64\2\u0123\12\64\1\u0124\1\123"+
    "\1\101\1\u0123\1\64\4\u0123\10\64\1\66\5\64\2\u0123"+
    "\12\64\1\u0124\1\64\1\101\1\u0123\1\64\4\u0123\15\64"+
    "\1\0\2\u0125\12\0\1\u0126\1\106\1\0\1\u0125\1\0"+
    "\4\u0125\10\0\1\53\5\0\2\u0125\12\0\1\u0126\2\0"+
    "\1\u0125\1\0\4\u0125\15\0\1\112\2\u0127\12\112\1\u0128"+
    "\1\146\1\112\1\u0127\1\112\4\u0127\10\112\1\116\5\112"+
    "\2\u0127\12\112\1\u0129\2\112\1\u0127\1\112\4\u0127\15\112"+
    "\1\0\2\u0117\12\0\1\u0118\1\56\1\0\1\u0117\1\0"+
    "\4\u0117\15\0\1\64\2\u012a\12\64\1\u012b\1\123\1\101"+
    "\1\u012a\1\64\4\u012a\10\64\1\66\5\64\2\u012a\12\64"+
    "\1\u012b\1\64\1\101\1\u012a\1\64\4\u012a\15\64\1\0"+
    "\2\u012c\12\0\1\u012d\1\106\1\0\1\u012c\1\0\4\u012c"+
    "\10\0\1\53\5\0\2\u012c\12\0\1\u012d\2\0\1\u012c"+
    "\1\0\4\u012c\15\0\1\112\2\u012e\12\112\1\u012f\1\146"+
    "\1\112\1\u012e\1\112\4\u012e\10\112\1\116\5\112\2\u012e"+
    "\12\112\1\u0130\2\112\1\u012e\1\112\4\u012e\15\112\1\0"+
    "\2\u011e\12\0\1\u011f\1\56\1\0\1\u011e\1\0\4\u011e"+
    "\15\0\1\64\2\u0131\12\64\1\u0132\1\123\1\101\1\u0131"+
    "\1\64\4\u0131\10\64\1\66\5\64\2\u0131\12\64\1\u0132"+
    "\1\64\1\101\1\u0131\1\64\4\u0131\15\64\1\0\2\u0133"+
    "\12\0\1\u0134\1\106\1\0\1\u0133\1\0\4\u0133\10\0"+
    "\1\53\5\0\2\u0133\12\0\1\u0134\2\0\1\u0133\1\0"+
    "\4\u0133\15\0\1\112\2\u0135\12\112\1\u0136\1\146\1\112"+
    "\1\u0135\1\112\4\u0135\10\112\1\116\5\112\2\u0135\12\112"+
    "\1\u0137\2\112\1\u0135\1\112\4\u0135\15\112\1\0\2\u0125"+
    "\12\0\1\u0126\1\56\1\0\1\u0125\1\0\4\u0125\15\0"+
    "\1\64\2\u0138\12\64\1\u0139\1\123\1\101\1\u0138\1\64"+
    "\4\u0138\10\64\1\66\5\64\2\u0138\12\64\1\u0139\1\64"+
    "\1\101\1\u0138\1\64\4\u0138\15\64\1\0\2\u013a\12\0"+
    "\1\u013b\1\106\1\0\1\u013a\1\0\4\u013a\10\0\1\53"+
    "\5\0\2\u013a\12\0\1\u013b\2\0\1\u013a\1\0\4\u013a"+
    "\15\0\1\112\2\u013c\12\112\1\u013d\1\146\1\112\1\u013c"+
    "\1\112\4\u013c\10\112\1\116\5\112\2\u013c\12\112\1\u013e"+
    "\2\112\1\u013c\1\112\4\u013c\15\112\1\0\2\u012c\12\0"+
    "\1\u012d\1\56\1\0\1\u012c\1\0\4\u012c\15\0\1\64"+
    "\2\u013f\12\64\1\u0140\1\123\1\101\1\u013f\1\64\4\u013f"+
    "\10\64\1\66\5\64\2\u013f\12\64\1\u0140\1\64\1\101"+
    "\1\u013f\1\64\4\u013f\15\64\1\0\2\u0141\12\0\1\u0142"+
    "\1\106\1\0\1\u0141\1\0\4\u0141\10\0\1\53\5\0"+
    "\2\u0141\12\0\1\u0142\2\0\1\u0141\1\0\4\u0141\15\0"+
    "\1\112\2\u0143\12\112\1\u0144\1\146\1\112\1\u0143\1\112"+
    "\4\u0143\10\112\1\116\5\112\2\u0143\12\112\1\u0145\2\112"+
    "\1\u0143\1\112\4\u0143\15\112\1\0\2\u0133\12\0\1\u0134"+
    "\1\56\1\0\1\u0133\1\0\4\u0133\15\0\1\64\2\u0146"+
    "\12\64\1\u0147\1\123\1\101\1\u0146\1\64\4\u0146\10\64"+
    "\1\66\5\64\2\u0146\12\64\1\u0147\1\64\1\101\1\u0146"+
    "\1\64\4\u0146\15\64\1\0\2\u0148\12\0\1\u0149\1\106"+
    "\1\0\1\u0148\1\0\4\u0148\10\0\1\53\5\0\2\u0148"+
    "\12\0\1\u0149\2\0\1\u0148\1\0\4\u0148\15\0\1\112"+
    "\2\u014a\12\112\1\u014b\1\146\1\112\1\u014a\1\112\4\u014a"+
    "\10\112\1\116\5\112\2\u014a\12\112\1\u014c\2\112\1\u014a"+
    "\1\112\4\u014a\15\112\1\0\2\u013a\12\0\1\u013b\1\56"+
    "\1\0\1\u013a\1\0\4\u013a\15\0\1\64\2\u014d\12\64"+
    "\1\u014e\1\123\1\101\1\u014d\1\64\4\u014d\10\64\1\66"+
    "\5\64\2\u014d\12\64\1\u014e\1\64\1\101\1\u014d\1\64"+
    "\4\u014d\15\64\1\0\2\u014f\12\0\1\u0150\1\106\1\0"+
    "\1\u014f\1\0\4\u014f\10\0\1\53\5\0\2\u014f\12\0"+
    "\1\u0150\2\0\1\u014f\1\0\4\u014f\15\0\1\112\2\u0151"+
    "\12\112\1\u0152\1\146\1\112\1\u0151\1\112\4\u0151\10\112"+
    "\1\116\5\112\2\u0151\12\112\1\u0153\2\112\1\u0151\1\112"+
    "\4\u0151\15\112\1\0\2\u0141\12\0\1\u0142\1\56\1\0"+
    "\1\u0141\1\0\4\u0141\15\0\1\64\2\u0154\12\64\1\u0155"+
    "\1\123\1\101\1\u0154\1\64\4\u0154\10\64\1\66\5\64"+
    "\2\u0154\12\64\1\u0155\1\64\1\101\1\u0154\1\64\4\u0154"+
    "\15\64\1\0\2\u0156\12\0\1\u0157\1\106\1\0\1\u0156"+
    "\1\0\4\u0156\10\0\1\53\5\0\2\u0156\12\0\1\u0157"+
    "\2\0\1\u0156\1\0\4\u0156\15\0\1\112\2\u0158\12\112"+
    "\1\u0159\1\146\1\112\1\u0158\1\112\4\u0158\10\112\1\116"+
    "\5\112\2\u0158\12\112\1\u015a\2\112\1\u0158\1\112\4\u0158"+
    "\15\112\1\0\2\u0148\12\0\1\u0149\1\56\1\0\1\u0148"+
    "\1\0\4\u0148\15\0\1\64\2\u015b\12\64\1\u015c\1\123"+
    "\1\101\1\u015b\1\64\4\u015b\10\64\1\66\5\64\2\u015b"+
    "\12\64\1\u015c\1\64\1\101\1\u015b\1\64\4\u015b\15\64"+
    "\1\0\2\u015d\12\0\1\u015e\1\106\1\0\1\u015d\1\0"+
    "\4\u015d\10\0\1\53\5\0\2\u015d\12\0\1\u015e\2\0"+
    "\1\u015d\1\0\4\u015d\15\0\1\112\2\u015f\12\112\1\u0160"+
    "\1\146\1\112\1\u015f\1\112\4\u015f\10\112\1\116\5\112"+
    "\2\u015f\12\112\1\u0161\2\112\1\u015f\1\112\4\u015f\15\112"+
    "\1\0\2\u014f\12\0\1\u0150\1\56\1\0\1\u014f\1\0"+
    "\4\u014f\15\0\1\64\2\u0162\12\64\1\u0163\1\123\1\101"+
    "\1\u0162\1\64\4\u0162\10\64\1\66\5\64\2\u0162\12\64"+
    "\1\u0163\1\64\1\101\1\u0162\1\64\4\u0162\15\64\1\0"+
    "\2\u0164\12\0\1\u0165\1\106\1\0\1\u0164\1\0\4\u0164"+
    "\10\0\1\53\5\0\2\u0164\12\0\1\u0165\2\0\1\u0164"+
    "\1\0\4\u0164\15\0\1\112\2\u0166\12\112\1\u0167\1\146"+
    "\1\112\1\u0166\1\112\4\u0166\10\112\1\116\5\112\2\u0166"+
    "\12\112\1\u0168\2\112\1\u0166\1\112\4\u0166\15\112\1\0"+
    "\2\u0156\12\0\1\u0157\1\56\1\0\1\u0156\1\0\4\u0156"+
    "\15\0\1\64\2\u0169\12\64\1\u016a\1\123\1\101\1\u0169"+
    "\1\64\4\u0169\10\64\1\66\5\64\2\u0169\12\64\1\u016a"+
    "\1\64\1\101\1\u0169\1\64\4\u0169\15\64\1\0\2\u016b"+
    "\12\0\1\u016c\1\106\1\0\1\u016b\1\0\4\u016b\10\0"+
    "\1\53\5\0\2\u016b\12\0\1\u016c\2\0\1\u016b\1\0"+
    "\4\u016b\15\0\1\112\2\u016d\12\112\1\u016e\1\146\1\112"+
    "\1\u016d\1\112\4\u016d\10\112\1\116\5\112\2\u016d\12\112"+
    "\1\u016f\2\112\1\u016d\1\112\4\u016d\15\112\1\0\2\u015d"+
    "\12\0\1\u015e\1\56\1\0\1\u015d\1\0\4\u015d\15\0"+
    "\1\64\2\u0170\12\64\1\u0171\1\123\1\101\1\u0170\1\64"+
    "\4\u0170\10\64\1\66\5\64\2\u0170\12\64\1\u0171\1\64"+
    "\1\101\1\u0170\1\64\4\u0170\15\64\1\0\2\u0172\12\0"+
    "\1\u0173\1\106\1\0\1\u0172\1\0\4\u0172\10\0\1\53"+
    "\5\0\2\u0172\12\0\1\u0173\2\0\1\u0172\1\0\4\u0172"+
    "\15\0\1\112\2\u0174\12\112\1\u0175\1\146\1\112\1\u0174"+
    "\1\112\4\u0174\10\112\1\116\5\112\2\u0174\12\112\1\u0176"+
    "\2\112\1\u0174\1\112\4\u0174\15\112\1\0\2\u0164\12\0"+
    "\1\u0165\1\56\1\0\1\u0164\1\0\4\u0164\15\0\1\64"+
    "\2\u0177\12\64\1\u0178\1\123\1\101\1\u0177\1\64\4\u0177"+
    "\10\64\1\66\5\64\2\u0177\12\64\1\u0178\1\64\1\101"+
    "\1\u0177\1\64\4\u0177\15\64\1\0\2\u0179\12\0\1\u017a"+
    "\1\106\1\0\1\u0179\1\0\4\u0179\10\0\1\53\5\0"+
    "\2\u0179\12\0\1\u017a\2\0\1\u0179\1\0\4\u0179\15\0"+
    "\1\112\2\u017b\12\112\1\u017c\1\146\1\112\1\u017b\1\112"+
    "\4\u017b\10\112\1\116\5\112\2\u017b\12\112\1\u017d\2\112"+
    "\1\u017b\1\112\4\u017b\15\112\1\0\2\u016b\12\0\1\u016c"+
    "\1\56\1\0\1\u016b\1\0\4\u016b\15\0\1\64\2\u017e"+
    "\12\64\1\u017f\1\123\1\101\1\u017e\1\64\4\u017e\10\64"+
    "\1\66\5\64\2\u017e\12\64\1\u017f\1\64\1\101\1\u017e"+
    "\1\64\4\u017e\15\64\1\0\2\u0180\12\0\1\u0181\1\106"+
    "\1\0\1\u0180\1\0\4\u0180\10\0\1\53\5\0\2\u0180"+
    "\12\0\1\u0181\2\0\1\u0180\1\0\4\u0180\15\0\1\112"+
    "\2\u0182\12\112\1\u0183\1\146\1\112\1\u0182\1\112\4\u0182"+
    "\10\112\1\116\5\112\2\u0182\12\112\1\u0184\2\112\1\u0182"+
    "\1\112\4\u0182\15\112\1\0\2\u0172\12\0\1\u0173\1\56"+
    "\1\0\1\u0172\1\0\4\u0172\15\0\1\64\2\u0185\12\64"+
    "\1\u0186\1\123\1\101\1\u0185\1\64\4\u0185\10\64\1\66"+
    "\5\64\2\u0185\12\64\1\u0186\1\64\1\101\1\u0185\1\64"+
    "\4\u0185\15\64\1\0\2\u0187\12\0\1\u0188\1\106\1\0"+
    "\1\u0187\1\0\4\u0187\10\0\1\53\5\0\2\u0187\12\0"+
    "\1\u0188\2\0\1\u0187\1\0\4\u0187\15\0\1\112\2\u0189"+
    "\12\112\1\u018a\1\146\1\112\1\u0189\1\112\4\u0189\10\112"+
    "\1\116\5\112\2\u0189\12\112\1\u018b\2\112\1\u0189\1\112"+
    "\4\u0189\15\112\1\0\2\u0179\12\0\1\u017a\1\56\1\0"+
    "\1\u0179\1\0\4\u0179\15\0\1\64\2\u018c\12\64\1\u018d"+
    "\1\123\1\101\1\u018c\1\64\4\u018c\10\64\1\66\5\64"+
    "\2\u018c\12\64\1\u018d\1\64\1\101\1\u018c\1\64\4\u018c"+
    "\15\64\1\0\2\u018e\12\0\1\u018f\1\106\1\0\1\u018e"+
    "\1\0\4\u018e\10\0\1\53\5\0\2\u018e\12\0\1\u018f"+
    "\2\0\1\u018e\1\0\4\u018e\15\0\1\112\2\u0190\12\112"+
    "\1\u0191\1\146\1\112\1\u0190\1\112\4\u0190\10\112\1\116"+
    "\5\112\2\u0190\12\112\1\u0192\2\112\1\u0190\1\112\4\u0190"+
    "\15\112\1\0\2\u0180\12\0\1\u0181\1\56\1\0\1\u0180"+
    "\1\0\4\u0180\15\0\1\64\2\u0193\12\64\1\u0194\1\123"+
    "\1\101\1\u0193\1\64\4\u0193\10\64\1\66\5\64\2\u0193"+
    "\12\64\1\u0194\1\64\1\101\1\u0193\1\64\4\u0193\15\64"+
    "\1\0\2\u0195\12\0\1\u0196\1\106\1\0\1\u0195\1\0"+
    "\4\u0195\10\0\1\53\5\0\2\u0195\12\0\1\u0196\2\0"+
    "\1\u0195\1\0\4\u0195\15\0\1\112\2\u0197\12\112\1\u0198"+
    "\1\146\1\112\1\u0197\1\112\4\u0197\10\112\1\116\5\112"+
    "\2\u0197\12\112\1\u0199\2\112\1\u0197\1\112\4\u0197\15\112"+
    "\1\0\2\u0187\12\0\1\u0188\1\56\1\0\1\u0187\1\0"+
    "\4\u0187\15\0\1\64\2\u019a\12\64\1\u019b\1\123\1\101"+
    "\1\u019a\1\64\4\u019a\10\64\1\66\5\64\2\u019a\12\64"+
    "\1\u019b\1\64\1\101\1\u019a\1\64\4\u019a\15\64\1\0"+
    "\2\u019c\12\0\1\u019d\1\106\1\0\1\u019c\1\0\4\u019c"+
    "\10\0\1\53\5\0\2\u019c\12\0\1\u019d\2\0\1\u019c"+
    "\1\0\4\u019c\15\0\1\112\2\u019e\12\112\1\u019f\1\146"+
    "\1\112\1\u019e\1\112\4\u019e\10\112\1\116\5\112\2\u019e"+
    "\12\112\1\u01a0\2\112\1\u019e\1\112\4\u019e\15\112\1\0"+
    "\2\u018e\12\0\1\u018f\1\56\1\0\1\u018e\1\0\4\u018e"+
    "\15\0\1\64\2\u01a1\12\64\1\u01a2\1\123\1\101\1\u01a1"+
    "\1\64\4\u01a1\10\64\1\66\5\64\2\u01a1\12\64\1\u01a2"+
    "\1\64\1\101\1\u01a1\1\64\4\u01a1\15\64\1\0\2\u01a3"+
    "\12\0\1\u01a4\1\106\1\0\1\u01a3\1\0\4\u01a3\10\0"+
    "\1\53\5\0\2\u01a3\12\0\1\u01a4\2\0\1\u01a3\1\0"+
    "\4\u01a3\15\0\1\112\2\u01a5\12\112\1\u01a6\1\146\1\112"+
    "\1\u01a5\1\112\4\u01a5\10\112\1\116\5\112\2\u01a5\12\112"+
    "\1\u01a7\2\112\1\u01a5\1\112\4\u01a5\15\112\1\0\2\u0195"+
    "\12\0\1\u0196\1\56\1\0\1\u0195\1\0\4\u0195\15\0"+
    "\1\64\2\u01a8\12\64\1\u01a9\1\123\1\101\1\u01a8\1\64"+
    "\4\u01a8\10\64\1\66\5\64\2\u01a8\12\64\1\u01a9\1\64"+
    "\1\101\1\u01a8\1\64\4\u01a8\15\64\1\0\2\u01aa\12\0"+
    "\1\u01ab\1\106\1\0\1\u01aa\1\0\4\u01aa\10\0\1\53"+
    "\5\0\2\u01aa\12\0\1\u01ab\2\0\1\u01aa\1\0\4\u01aa"+
    "\15\0\1\112\2\u01ac\12\112\1\u01ad\1\146\1\112\1\u01ac"+
    "\1\112\4\u01ac\10\112\1\116\5\112\2\u01ac\12\112\1\u01ae"+
    "\2\112\1\u01ac\1\112\4\u01ac\15\112\1\0\2\u019c\12\0"+
    "\1\u019d\1\56\1\0\1\u019c\1\0\4\u019c\15\0\1\64"+
    "\2\u01af\12\64\1\u01b0\1\123\1\101\1\u01af\1\64\4\u01af"+
    "\10\64\1\66\5\64\2\u01af\12\64\1\u01b0\1\64\1\101"+
    "\1\u01af\1\64\4\u01af\15\64\1\0\2\u01b1\12\0\1\u01b2"+
    "\1\106\1\0\1\u01b1\1\0\4\u01b1\10\0\1\53\5\0"+
    "\2\u01b1\12\0\1\u01b2\2\0\1\u01b1\1\0\4\u01b1\15\0"+
    "\1\112\2\u01b3\12\112\1\u01b4\1\146\1\112\1\u01b3\1\112"+
    "\4\u01b3\10\112\1\116\5\112\2\u01b3\12\112\1\u01b5\2\112"+
    "\1\u01b3\1\112\4\u01b3\15\112\1\0\2\u01a3\12\0\1\u01a4"+
    "\1\56\1\0\1\u01a3\1\0\4\u01a3\15\0\1\64\2\u01b6"+
    "\12\64\1\u01b7\1\123\1\101\1\u01b6\1\64\4\u01b6\10\64"+
    "\1\66\5\64\2\u01b6\12\64\1\u01b7\1\64\1\101\1\u01b6"+
    "\1\64\4\u01b6\15\64\1\0\2\u01b8\12\0\1\u01b9\1\106"+
    "\1\0\1\u01b8\1\0\4\u01b8\10\0\1\53\5\0\2\u01b8"+
    "\12\0\1\u01b9\2\0\1\u01b8\1\0\4\u01b8\15\0\1\112"+
    "\2\u01ba\12\112\1\u01bb\1\146\1\112\1\u01ba\1\112\4\u01ba"+
    "\10\112\1\116\5\112\2\u01ba\12\112\1\u01bc\2\112\1\u01ba"+
    "\1\112\4\u01ba\15\112\1\0\2\u01aa\12\0\1\u01ab\1\56"+
    "\1\0\1\u01aa\1\0\4\u01aa\15\0\1\64\2\u01bd\12\64"+
    "\1\u01be\1\123\1\101\1\u01bd\1\64\4\u01bd\10\64\1\66"+
    "\5\64\2\u01bd\12\64\1\u01be\1\64\1\101\1\u01bd\1\64"+
    "\4\u01bd\15\64\1\0\2\u01bf\12\0\1\u01c0\1\106\1\0"+
    "\1\u01bf\1\0\4\u01bf\10\0\1\53\5\0\2\u01bf\12\0"+
    "\1\u01c0\2\0\1\u01bf\1\0\4\u01bf\15\0\1\112\2\u01c1"+
    "\12\112\1\u01c2\1\146\1\112\1\u01c1\1\112\4\u01c1\10\112"+
    "\1\116\5\112\2\u01c1\12\112\1\u01c3\2\112\1\u01c1\1\112"+
    "\4\u01c1\15\112\1\0\2\u01b1\12\0\1\u01b2\1\56\1\0"+
    "\1\u01b1\1\0\4\u01b1\15\0\1\64\2\u01c4\12\64\1\u01c5"+
    "\1\123\1\101\1\u01c4\1\64\4\u01c4\10\64\1\66\5\64"+
    "\2\u01c4\12\64\1\u01c5\1\64\1\101\1\u01c4\1\64\4\u01c4"+
    "\15\64\1\0\2\u01c6\12\0\1\u01c7\1\106\1\0\1\u01c6"+
    "\1\0\4\u01c6\10\0\1\53\5\0\2\u01c6\12\0\1\u01c7"+
    "\2\0\1\u01c6\1\0\4\u01c6\15\0\1\112\2\u01c8\12\112"+
    "\1\u01c9\1\146\1\112\1\u01c8\1\112\4\u01c8\10\112\1\116"+
    "\5\112\2\u01c8\12\112\1\u01ca\2\112\1\u01c8\1\112\4\u01c8"+
    "\15\112\1\0\2\u01b8\12\0\1\u01b9\1\56\1\0\1\u01b8"+
    "\1\0\4\u01b8\15\0\1\64\2\u01cb\12\64\1\u01cc\1\123"+
    "\1\101\1\u01cb\1\64\4\u01cb\10\64\1\66\5\64\2\u01cb"+
    "\12\64\1\u01cc\1\64\1\101\1\u01cb\1\64\4\u01cb\15\64"+
    "\1\0\2\u01cd\12\0\1\u01ce\1\106\1\0\1\u01cd\1\0"+
    "\4\u01cd\10\0\1\53\5\0\2\u01cd\12\0\1\u01ce\2\0"+
    "\1\u01cd\1\0\4\u01cd\15\0\1\112\2\u01cf\12\112\1\u01d0"+
    "\1\146\1\112\1\u01cf\1\112\4\u01cf\10\112\1\116\5\112"+
    "\2\u01cf\12\112\1\u01d1\2\112\1\u01cf\1\112\4\u01cf\15\112"+
    "\1\0\2\u01bf\12\0\1\u01c0\1\56\1\0\1\u01bf\1\0"+
    "\4\u01bf\15\0\1\64\2\u01d2\12\64\1\u01d3\1\123\1\101"+
    "\1\u01d2\1\64\4\u01d2\10\64\1\66\5\64\2\u01d2\12\64"+
    "\1\u01d3\1\64\1\101\1\u01d2\1\64\4\u01d2\15\64\1\0"+
    "\2\u01d4\12\0\1\u01d5\1\106\1\0\1\u01d4\1\0\4\u01d4"+
    "\10\0\1\53\5\0\2\u01d4\12\0\1\u01d5\2\0\1\u01d4"+
    "\1\0\4\u01d4\15\0\1\112\2\u01d6\12\112\1\u01d7\1\146"+
    "\1\112\1\u01d6\1\112\4\u01d6\10\112\1\116\5\112\2\u01d6"+
    "\12\112\1\u01d8\2\112\1\u01d6\1\112\4\u01d6\15\112\1\0"+
    "\2\u01c6\12\0\1\u01c7\1\56\1\0\1\u01c6\1\0\4\u01c6"+
    "\15\0\1\64\2\u01d9\12\64\1\u01da\1\123\1\101\1\u01d9"+
    "\1\64\4\u01d9\10\64\1\66\5\64\2\u01d9\12\64\1\u01da"+
    "\1\64\1\101\1\u01d9\1\64\4\u01d9\15\64\1\0\2\u01db"+
    "\12\0\1\u01dc\1\106\1\0\1\u01db\1\0\4\u01db\10\0"+
    "\1\53\5\0\2\u01db\12\0\1\u01dc\2\0\1\u01db\1\0"+
    "\4\u01db\15\0\1\112\2\u01dd\12\112\1\u01de\1\146\1\112"+
    "\1\u01dd\1\112\4\u01dd\10\112\1\116\5\112\2\u01dd\12\112"+
    "\1\u01df\2\112\1\u01dd\1\112\4\u01dd\15\112\1\0\2\u01cd"+
    "\12\0\1\u01ce\1\56\1\0\1\u01cd\1\0\4\u01cd\15\0"+
    "\1\64\2\u01e0\12\64\1\u01e1\1\123\1\101\1\u01e0\1\64"+
    "\4\u01e0\10\64\1\66\5\64\2\u01e0\12\64\1\u01e1\1\64"+
    "\1\101\1\u01e0\1\64\4\u01e0\15\64\1\0\2\u01e2\12\0"+
    "\1\u01e3\1\106\1\0\1\u01e2\1\0\4\u01e2\10\0\1\53"+
    "\5\0\2\u01e2\12\0\1\u01e3\2\0\1\u01e2\1\0\4\u01e2"+
    "\15\0\1\112\2\u01e4\12\112\1\u01e5\1\146\1\112\1\u01e4"+
    "\1\112\4\u01e4\10\112\1\116\5\112\2\u01e4\12\112\1\u01e6"+
    "\2\112\1\u01e4\1\112\4\u01e4\15\112\1\0\2\u01d4\12\0"+
    "\1\u01d5\1\56\1\0\1\u01d4\1\0\4\u01d4\15\0\1\64"+
    "\2\u01e7\12\64\1\u01e8\1\123\1\101\1\u01e7\1\64\4\u01e7"+
    "\10\64\1\66\5\64\2\u01e7\12\64\1\u01e8\1\64\1\101"+
    "\1\u01e7\1\64\4\u01e7\15\64\1\0\2\u01e9\12\0\1\u01ea"+
    "\1\106\1\0\1\u01e9\1\0\4\u01e9\10\0\1\53\5\0"+
    "\2\u01e9\12\0\1\u01ea\2\0\1\u01e9\1\0\4\u01e9\15\0"+
    "\1\112\2\u01eb\12\112\1\u01ec\1\146\1\112\1\u01eb\1\112"+
    "\4\u01eb\10\112\1\116\5\112\2\u01eb\12\112\1\u01ed\2\112"+
    "\1\u01eb\1\112\4\u01eb\15\112\1\0\2\u01db\12\0\1\u01dc"+
    "\1\56\1\0\1\u01db\1\0\4\u01db\15\0\1\64\2\u01ee"+
    "\12\64\1\u01ef\1\123\1\101\1\u01ee\1\64\4\u01ee\10\64"+
    "\1\66\5\64\2\u01ee\12\64\1\u01ef\1\64\1\101\1\u01ee"+
    "\1\64\4\u01ee\15\64\1\0\2\u01f0\12\0\1\u01f1\1\106"+
    "\1\0\1\u01f0\1\0\4\u01f0\10\0\1\53\5\0\2\u01f0"+
    "\12\0\1\u01f1\2\0\1\u01f0\1\0\4\u01f0\15\0\1\112"+
    "\2\u01f2\12\112\1\u01f3\1\146\1\112\1\u01f2\1\112\4\u01f2"+
    "\10\112\1\116\5\112\2\u01f2\12\112\1\u01f4\2\112\1\u01f2"+
    "\1\112\4\u01f2\15\112\1\0\2\u01e2\12\0\1\u01e3\1\56"+
    "\1\0\1\u01e2\1\0\4\u01e2\15\0\1\64\2\u01f5\12\64"+
    "\1\u01f6\1\123\1\101\1\u01f5\1\64\4\u01f5\10\64\1\66"+
    "\5\64\2\u01f5\12\64\1\u01f6\1\64\1\101\1\u01f5\1\64"+
    "\4\u01f5\15\64\1\0\2\u01f7\12\0\1\u01f8\1\106\1\0"+
    "\1\u01f7\1\0\4\u01f7\10\0\1\53\5\0\2\u01f7\12\0"+
    "\1\u01f8\2\0\1\u01f7\1\0\4\u01f7\15\0\1\112\2\u01f9"+
    "\12\112\1\u01fa\1\146\1\112\1\u01f9\1\112\4\u01f9\10\112"+
    "\1\116\5\112\2\u01f9\12\112\1\u01fb\2\112\1\u01f9\1\112"+
    "\4\u01f9\15\112\1\0\2\u01e9\12\0\1\u01ea\1\56\1\0"+
    "\1\u01e9\1\0\4\u01e9\15\0\1\64\2\u01fc\12\64\1\u01fd"+
    "\1\123\1\101\1\u01fc\1\64\4\u01fc\10\64\1\66\5\64"+
    "\2\u01fc\12\64\1\u01fd\1\64\1\101\1\u01fc\1\64\4\u01fc"+
    "\15\64\1\0\2\u01fe\12\0\1\u01ff\1\106\1\0\1\u01fe"+
    "\1\0\4\u01fe\10\0\1\53\5\0\2\u01fe\12\0\1\u01ff"+
    "\2\0\1\u01fe\1\0\4\u01fe\15\0\1\112\2\u0200\12\112"+
    "\1\u0201\1\146\1\112\1\u0200\1\112\4\u0200\10\112\1\116"+
    "\5\112\2\u0200\12\112\1\u0202\2\112\1\u0200\1\112\4\u0200"+
    "\15\112\1\0\2\u01f0\12\0\1\u01f1\1\56\1\0\1\u01f0"+
    "\1\0\4\u01f0\15\0\1\64\2\u0203\12\64\1\u0204\1\123"+
    "\1\101\1\u0203\1\64\4\u0203\10\64\1\66\5\64\2\u0203"+
    "\12\64\1\u0204\1\64\1\101\1\u0203\1\64\4\u0203\15\64"+
    "\1\0\2\u0205\12\0\1\u0206\1\106\1\0\1\u0205\1\0"+
    "\4\u0205\10\0\1\53\5\0\2\u0205\12\0\1\u0206\2\0"+
    "\1\u0205\1\0\4\u0205\15\0\1\112\2\u0207\12\112\1\u0208"+
    "\1\146\1\112\1\u0207\1\112\4\u0207\10\112\1\116\5\112"+
    "\2\u0207\12\112\1\u0209\2\112\1\u0207\1\112\4\u0207\15\112"+
    "\1\0\2\u01f7\12\0\1\u01f8\1\56\1\0\1\u01f7\1\0"+
    "\4\u01f7\15\0\1\64\2\u020a\12\64\1\u020b\1\123\1\101"+
    "\1\u020a\1\64\4\u020a\10\64\1\66\5\64\2\u020a\12\64"+
    "\1\u020b\1\64\1\101\1\u020a\1\64\4\u020a\15\64\1\0"+
    "\2\u020c\12\0\1\u020d\1\106\1\0\1\u020c\1\0\4\u020c"+
    "\10\0\1\53\5\0\2\u020c\12\0\1\u020d\2\0\1\u020c"+
    "\1\0\4\u020c\15\0\1\112\2\u020e\12\112\1\u020f\1\146"+
    "\1\112\1\u020e\1\112\4\u020e\10\112\1\116\5\112\2\u020e"+
    "\12\112\1\u0210\2\112\1\u020e\1\112\4\u020e\15\112\1\0"+
    "\2\u01fe\12\0\1\u01ff\1\56\1\0\1\u01fe\1\0\4\u01fe"+
    "\15\0\1\64\2\u0211\12\64\1\u0212\1\123\1\101\1\u0211"+
    "\1\64\4\u0211\10\64\1\66\5\64\2\u0211\12\64\1\u0212"+
    "\1\64\1\101\1\u0211\1\64\4\u0211\15\64\1\0\2\u0213"+
    "\12\0\1\u0214\1\106\1\0\1\u0213\1\0\4\u0213\10\0"+
    "\1\53\5\0\2\u0213\12\0\1\u0214\2\0\1\u0213\1\0"+
    "\4\u0213\15\0\1\112\2\u0215\12\112\1\u0216\1\146\1\112"+
    "\1\u0215\1\112\4\u0215\10\112\1\116\5\112\2\u0215\12\112"+
    "\1\u0217\2\112\1\u0215\1\112\4\u0215\15\112\1\0\2\u0205"+
    "\12\0\1\u0206\1\56\1\0\1\u0205\1\0\4\u0205\15\0"+
    "\1\64\2\u0218\12\64\1\u0219\1\123\1\101\1\u0218\1\64"+
    "\4\u0218\10\64\1\66\5\64\2\u0218\12\64\1\u0219\1\64"+
    "\1\101\1\u0218\1\64\4\u0218\15\64\1\0\2\u021a\12\0"+
    "\1\u021b\1\106\1\0\1\u021a\1\0\4\u021a\10\0\1\53"+
    "\5\0\2\u021a\12\0\1\u021b\2\0\1\u021a\1\0\4\u021a"+
    "\15\0\1\112\2\u021c\12\112\1\u021d\1\146\1\112\1\u021c"+
    "\1\112\4\u021c\10\112\1\116\5\112\2\u021c\12\112\1\u021e"+
    "\2\112\1\u021c\1\112\4\u021c\15\112\1\0\2\u020c\12\0"+
    "\1\u020d\1\56\1\0\1\u020c\1\0\4\u020c\15\0\1\64"+
    "\2\u021f\12\64\1\u0220\1\123\1\101\1\u021f\1\64\4\u021f"+
    "\10\64\1\66\5\64\2\u021f\12\64\1\u0220\1\64\1\101"+
    "\1\u021f\1\64\4\u021f\15\64\1\0\2\u0221\13\0\1\106"+
    "\1\0\1\u0221\1\0\4\u0221\10\0\1\53\5\0\2\u0221"+
    "\15\0\1\u0221\1\0\4\u0221\15\0\1\112\2\u0222\12\112"+
    "\1\u0223\1\146\1\112\1\u0222\1\112\4\u0222\10\112\1\116"+
    "\5\112\2\u0222\12\112\1\u0224\2\112\1\u0222\1\112\4\u0222"+
    "\15\112\1\0\2\u0213\12\0\1\u0214\1\56\1\0\1\u0213"+
    "\1\0\4\u0213\15\0\1\64\2\u0225\13\64\1\123\1\101"+
    "\1\u0225\1\64\4\u0225\10\64\1\66\5\64\2\u0225\14\64"+
    "\1\101\1\u0225\1\64\4\u0225\15\64\16\0\1\106\17\0"+
    "\1\53\4\0\1\112\2\u0226\12\112\1\u0227\1\146\1\112"+
    "\1\u0226\1\112\4\u0226\10\112\1\116\5\112\2\u0226\12\112"+
    "\1\u0228\2\112\1\u0226\1\112\4\u0226\15\112\1\0\2\u021a"+
    "\12\0\1\u021b\1\56\1\0\1\u021a\1\0\4\u021a\15\0"+
    "\16\64\1\123\1\101\16\64\1\66\4\64\1\112\2\u0229"+
    "\12\112\1\131\1\146\1\112\1\u0229\1\112\4\u0229\10\112"+
    "\1\116\5\112\2\u0229\12\112\1\74\2\112\1\u0229\1\112"+
    "\4\u0229\15\112\1\0\2\u0221\13\0\1\56\1\0\1\u0221"+
    "\1\0\4\u0221\15\0\15\112\1\131\1\146\17\112\1\116"+
    "\4\112";

  private static int [] zzUnpackTrans() {
    int [] result = new int[18480];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\11\2\1\2\11\3\1\1\11\2\1\3\11"+
    "\1\1\1\11\4\1\1\0\1\1\3\0\1\11\1\1"+
    "\1\11\1\1\7\0\2\1\3\0\1\11\12\0\1\1"+
    "\14\0\1\11\2\0\1\11\3\0\1\1\5\0\1\1"+
    "\22\0\1\1\20\0\1\1\2\0\1\1\74\0\1\1"+
    "\u0172\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[553];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private static class Token extends MarkdownTokenTypes {}

  private Stack<Integer> stateStack = new Stack<Integer>();

  private boolean isHeader = false;

  private ParseDelimited parseDelimited = new ParseDelimited();

  private static class ParseDelimited {
    char exitChar = 0;
    IElementType returnType = null;
    boolean inlinesAllowed = true;
  }

  private static class LinkDef {
    boolean wasUrl;
    boolean wasParen;
  }

  private static class HtmlHelper {
    private static final String BLOCK_TAGS_STRING =
            "article, header, aside, hgroup, blockquote, hr, iframe, body, li, map, button, " +
            "object, canvas, ol, caption, output, col, p, colgroup, pre, dd, progress, div, " +
            "section, dl, table, td, dt, tbody, embed, textarea, fieldset, tfoot, figcaption, " +
            "th, figure, thead, footer, footer, tr, form, ul, h1, h2, h3, h4, h5, h6, video, " +
            "script, style";

    static final Set<String> BLOCK_TAGS = getBlockTagsSet();

    private static Set<String> getBlockTagsSet() {
      Set<String> result = new HashSet<String>();
      String[] tags = BLOCK_TAGS_STRING.split(", ");
      for (String tag : tags) {
        result.add(tag);
      }
      return result;
    }
  }

  private static IElementType getDelimiterTokenType(char c) {
    switch (c) {
      case '"': return Token.DOUBLE_QUOTE;
      case '\'': return Token.SINGLE_QUOTE;
      case '(': return Token.LPAREN;
      case ')': return Token.RPAREN;
      case '[': return Token.LBRACKET;
      case ']': return Token.RBRACKET;
      case '<': return Token.LT;
      case '>': return Token.GT;
      default: return Token.BAD_CHARACTER;
    }
  }

  private IElementType parseDelimited(IElementType contentsType, boolean allowInlines) {
    char first = yycharat(0);
    char last = yycharat(yylength() - 1);

    stateStack.push(yystate());

    parseDelimited.exitChar = last;
    parseDelimited.returnType = contentsType;
//    parseDelimited.inlinesAllowed = allowInlines;
    parseDelimited.inlinesAllowed = true;

    yybegin(PARSE_DELIMITED);

    yypushback(yylength() - 1);
    return getDelimiterTokenType(first);
  }

  private void processEol() {
    int newlinePos = 1;
    while (newlinePos < yylength() && yycharat(newlinePos) != '\n') {
      newlinePos++;
    }

    // there is always one at 0 so that means there are two at least
    if (newlinePos != yylength()) {
      yypushback(yylength() - newlinePos);
      return;
    }

    yybegin(YYINITIAL);
    yypushback(yylength() - 1);

    isHeader = false;
  }

  private void popState() {
    if (stateStack.isEmpty()) {
      yybegin(AFTER_LINE_START);
    }
    else {
      yybegin(stateStack.pop());
    }
  }

  private void resetState() {
    yypushback(yylength());

    popState();
  }

  private String getTagName() {
    if (yylength() > 1 && yycharat(1) == '/') {
      return yytext().toString().substring(2, yylength() - 1).trim();
    }
    return yytext().toString().substring(1);
  }

  private boolean isBlockTag(String tagName) {
    return HtmlHelper.BLOCK_TAGS.contains(tagName.toLowerCase());
  }

  private boolean canInline() {
    return yystate() == AFTER_LINE_START || yystate() == PARSE_DELIMITED && parseDelimited.inlinesAllowed;
  }

  private IElementType getReturnGeneralized(IElementType defaultType) {
    if (canInline()) {
      return defaultType;
    }
    return parseDelimited.returnType;
  }

  private int countChars(CharSequence s, char c) {
    int result = 0;
    for (int i = 0; i < s.length(); ++i) {
      if (s.charAt(i) == c)
        result++;
    }
    return result;
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _MarkdownLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <code>pos</code> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { resetState();
            }
          case 18: break;
          case 2: 
            { return Token.BLOCK_QUOTE;
            }
          case 19: break;
          case 3: 
            { return Token.TEXT;
            }
          case 20: break;
          case 4: 
            { return Token.WHITE_SPACE;
            }
          case 21: break;
          case 5: 
            { int lastSpaces = yytext().toString().indexOf("\n");
    if (lastSpaces >= 2) {
      yypushback(yylength() - lastSpaces);
      return Token.HARD_LINE_BREAK;
    }
    else if (lastSpaces > 0) {
      yypushback(yylength() - lastSpaces);
      return Token.WHITE_SPACE;
    }

    processEol();
    return Token.EOL;
            }
          case 22: break;
          case 6: 
            { return getDelimiterTokenType(yycharat(0));
            }
          case 23: break;
          case 7: 
            { return Token.EXCLAMATION_MARK;
            }
          case 24: break;
          case 8: 
            { return Token.COLON;
            }
          case 25: break;
          case 9: 
            { return getReturnGeneralized(Token.EMPH);
            }
          case 26: break;
          case 10: 
            { if (canInline()) {
      return Token.BACKTICK;
    }
    return parseDelimited.returnType;
            }
          case 27: break;
          case 11: 
            { if (yycharat(0) == parseDelimited.exitChar) {
      yybegin(stateStack.pop());
      return getDelimiterTokenType(yycharat(0));
    }
    return parseDelimited.returnType;
            }
          case 28: break;
          case 12: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { return Token.HARD_LINE_BREAK;
            }
          case 29: break;
          case 13: 
            { return getReturnGeneralized(Token.TEXT);
            }
          case 30: break;
          case 14: 
            { return getReturnGeneralized(Token.ESCAPED_BACKTICKS);
            }
          case 31: break;
          case 15: 
            { return Token.HTML_TAG;
            }
          case 32: break;
          case 16: 
            { return parseDelimited(Token.EMAIL_AUTOLINK, false);
            }
          case 33: break;
          case 17: 
            { return parseDelimited(Token.AUTOLINK, false);
            }
          case 34: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
