/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.GeneratedToken;
import org.jetbrains.kotlin.commonizer.IdentityStringToken;
import org.jetbrains.kotlin.commonizer.IdentityStringTokenizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/commonizer/RegexIdentityStringTokenizer;", "Lorg/jetbrains/kotlin/commonizer/IdentityStringTokenizer;", "regex", "Lkotlin/text/Regex;", "token", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/commonizer/IdentityStringToken;", "(Lkotlin/text/Regex;Lkotlin/jvm/functions/Function1;)V", "getRegex", "()Lkotlin/text/Regex;", "getToken", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "nextToken", "Lorg/jetbrains/kotlin/commonizer/GeneratedToken;", "value", "toString", "kotlin-klib-commonizer-api"})
final class RegexIdentityStringTokenizer
implements IdentityStringTokenizer {
    @NotNull
    private final Regex regex;
    @NotNull
    private final Function1<String, IdentityStringToken> token;

    public RegexIdentityStringTokenizer(@NotNull Regex regex, @NotNull Function1<? super String, ? extends IdentityStringToken> token) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        this.regex = regex;
        this.token = token;
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @NotNull
    public final Function1<String, IdentityStringToken> getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public GeneratedToken nextToken(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull((Sequence)this.regex.findAll((CharSequence)value, 0));
        if (matchResult == null) {
            return null;
        }
        MatchResult firstMatchResult = matchResult;
        IntRange range = firstMatchResult.getRange();
        if (range.getFirst() != 0) {
            return null;
        }
        return new GeneratedToken((IdentityStringToken)this.token.invoke((Object)firstMatchResult.getValue()), StringsKt.drop((String)value, (int)firstMatchResult.getValue().length()));
    }

    @NotNull
    public final Regex component1() {
        return this.regex;
    }

    @NotNull
    public final Function1<String, IdentityStringToken> component2() {
        return this.token;
    }

    @NotNull
    public final RegexIdentityStringTokenizer copy(@NotNull Regex regex, @NotNull Function1<? super String, ? extends IdentityStringToken> token) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        return new RegexIdentityStringTokenizer(regex, token);
    }

    public static /* synthetic */ RegexIdentityStringTokenizer copy$default(RegexIdentityStringTokenizer regexIdentityStringTokenizer, Regex regex, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            regex = regexIdentityStringTokenizer.regex;
        }
        if ((n & 2) != 0) {
            function1 = regexIdentityStringTokenizer.token;
        }
        return regexIdentityStringTokenizer.copy(regex, function1);
    }

    @NotNull
    public String toString() {
        return "RegexIdentityStringTokenizer(regex=" + this.regex + ", token=" + this.token + ')';
    }

    public int hashCode() {
        int result = this.regex.hashCode();
        result = result * 31 + this.token.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexIdentityStringTokenizer)) {
            return false;
        }
        RegexIdentityStringTokenizer regexIdentityStringTokenizer = (RegexIdentityStringTokenizer)other;
        if (!Intrinsics.areEqual((Object)this.regex, (Object)regexIdentityStringTokenizer.regex)) {
            return false;
        }
        return Intrinsics.areEqual(this.token, regexIdentityStringTokenizer.token);
    }
}

