/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionReturnTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunctionReturnTypeMismatchChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirFunctionReturnTypeMismatchChecker INSTANCE = new FirFunctionReturnTypeMismatchChecker();

    private FirFunctionReturnTypeMismatchChecker() {
    }

    @Override
    public void check(@NotNull FirReturnExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType returnExpressionType;
        ConeKotlinType functionReturnType;
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            return;
        }
        FirFunction targetElement = expression2.getTarget().getLabeledElement();
        if (targetElement instanceof FirErrorFunction || targetElement instanceof FirAnonymousFunction && ((FirAnonymousFunction)targetElement).isLambda()) {
            return;
        }
        KtSourceElement ktSourceElement2 = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement2 != null ? ktSourceElement2.getKind() : null;
        if (!(DeclarationUtilsKt.getHasExplicitReturnType((FirCallableSymbol)targetElement.getSymbol()) || Intrinsics.areEqual((Object)sourceKind, (Object)KtRealSourceElementKind.INSTANCE) || targetElement instanceof FirPropertyAccessor)) {
            return;
        }
        FirExpression resultExpression2 = expression2.getResult();
        if (resultExpression2 instanceof FirWhenExpression && !ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)resultExpression2)) {
            return;
        }
        ConeKotlinType coneKotlinType = functionReturnType = targetElement instanceof FirConstructor ? FirTypeUtilsKt.getConeType(context2.getSession().getBuiltinTypes().getUnitType()) : FirTypeUtilsKt.getConeType(targetElement.getReturnTypeRef());
        if (targetElement instanceof FirAnonymousFunction && sourceKind instanceof KtFakeSourceElementKind.ImplicitReturn.FromLastStatement && ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) {
            return;
        }
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, returnExpressionType = FirTypeUtilsKt.getConeType(resultExpression2.getTypeRef()), functionReturnType)) {
            if (FirTypeUtilsKt.isNullLiteral(resultExpression2) && functionReturnType.getNullability() == ConeNullability.NOT_NULL) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression2.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (Object)functionReturnType, (DiagnosticContext)context2, null, 16, null);
            } else {
                boolean isDueToNullability = InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), returnExpressionType, functionReturnType);
                if (resultExpression2 instanceof FirSmartCastExpression && !((FirSmartCastExpression)resultExpression2).isStable() && FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, FirTypeUtilsKt.getConeType(((FirSmartCastExpression)resultExpression2).getSmartcastType()), functionReturnType)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression2.getSource(), FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE(), (Object)functionReturnType, (Object)resultExpression2, (Object)((FirSmartCastExpression)resultExpression2).getSmartcastStability().getDescription(), (Object)isDueToNullability, (DiagnosticContext)context2, null, 128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression2.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)isDueToNullability, (DiagnosticContext)context2, null, 128, null);
                }
            }
        } else {
            KtSourceElement ktSourceElement3 = resultExpression2.getSource();
            if ((ktSourceElement3 != null ? ktSourceElement3.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitUnit && !ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression2.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)false, (DiagnosticContext)context2, null, 128, null);
            }
        }
    }
}

