/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.DeclarationBuckets;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirRedeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOverloadabilityHelperKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001eH\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&JD\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00152\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\t2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010-\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0002J\f\u0010/\u001a\u00020\u0012*\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\u0005\u001a2\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006j\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "declarationConflictingSymbols", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lkotlin/collections/HashMap;", "getDeclarationConflictingSymbols", "()Ljava/util/HashMap;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "areCompatibleMainFunctions", "", "declaration1", "file1", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "declaration2", "file2", "collect", "", "declaration", "representation", "", "map", "", "", "collectClassMembers", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "collectTopLevel", "file", "packageMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "collectTopLevelConflict", "declarationPresentation", "containingFile", "conflictingSymbol", "conflictingPresentation", "conflictingFile", "isOverloadable", "conflicting", "representsMainFunctionAllowingConflictingOverloads", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n372#2,7:387\n372#2,7:394\n372#2,7:404\n1#3:401\n1855#4,2:402\n*S KotlinDebug\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector\n*L\n156#1:387,7\n163#1:394,7\n307#1:404,7\n257#1:402,2\n*E\n"})
public final class FirDeclarationInspector {
    @NotNull
    private final CheckerContext context;
    @NotNull
    private final HashMap<FirDeclaration, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols;

    public FirDeclarationInspector(@NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.declarationConflictingSymbols = new HashMap();
    }

    private final FirSession getSession() {
        return this.context.getSessionHolder().getSession();
    }

    @NotNull
    public final HashMap<FirDeclaration, SmartSet<FirBasedSymbol<?>>> getDeclarationConflictingSymbols() {
        return this.declarationConflictingSymbols;
    }

    public final void collectClassMembers(@NotNull FirRegularClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Map otherDeclarations = new LinkedHashMap();
        Map functionDeclarations = new LinkedHashMap();
        for (FirDeclaration it : klass.getDeclarations()) {
            if (!FirConflictsHelpersKt.access$isCollectable(it)) continue;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirSimpleFunction) {
                this.collect(it, FirRedeclarationPresenter.INSTANCE.represent((FirSimpleFunction)it), functionDeclarations);
                continue;
            }
            if (firDeclaration instanceof FirRegularClass) {
                this.collect(it, FirRedeclarationPresenter.INSTANCE.represent((FirRegularClass)it), otherDeclarations);
                continue;
            }
            if (firDeclaration instanceof FirTypeAlias) {
                this.collect(it, FirRedeclarationPresenter.INSTANCE.represent((FirTypeAlias)it), otherDeclarations);
                continue;
            }
            if (!(firDeclaration instanceof FirVariable)) continue;
            this.collect(it, FirRedeclarationPresenter.INSTANCE.represent((FirVariable)it), otherDeclarations);
        }
    }

    private final void collect(FirDeclaration declaration, String representation, Map<String, List<FirDeclaration>> map) {
        List list2;
        List list3;
        Map<String, List<FirDeclaration>> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(representation);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(representation, answer$iv);
            list3 = answer$iv;
        } else {
            list3 = value$iv;
        }
        List it = list2 = list3;
        boolean bl = false;
        it.add((FirDeclaration)declaration);
        SmartSet<FirBasedSymbol<? extends FirDeclaration>> conflicts = SmartSet.Companion.create();
        for (FirDeclaration otherDeclaration : it) {
            Object object;
            if (Intrinsics.areEqual((Object)otherDeclaration, (Object)declaration) || this.isOverloadable(declaration, otherDeclaration)) continue;
            conflicts.add(otherDeclaration.getSymbol());
            Map $this$getOrPut$iv2 = this.declarationConflictingSymbols;
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv2.get(otherDeclaration);
            if (value$iv2 == null) {
                boolean bl2 = false;
                SmartSet answer$iv = SmartSet.Companion.create();
                $this$getOrPut$iv2.put(otherDeclaration, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            ((SmartSet)object).add(declaration.getSymbol());
        }
        ((Map)this.declarationConflictingSymbols).put(declaration, conflicts);
    }

    public final void collectTopLevel(@NotNull FirFile file2, @NotNull FirPackageMemberScope packageMemberScope) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)packageMemberScope, (String)"packageMemberScope");
        for (Map.Entry entry : FirConflictsHelpersKt.access$groupTopLevelByName(file2.getDeclarations()).entrySet()) {
            boolean groupHasSimpleFunctions;
            Name declarationName = (Name)entry.getKey();
            DeclarationBuckets group = (DeclarationBuckets)entry.getValue();
            boolean groupHasClassLikesOrProperties = !((Collection)group.getClassLikes()).isEmpty() || !((Collection)group.getProperties()).isEmpty();
            boolean bl = groupHasSimpleFunctions = !((Collection)group.getSimpleFunctions()).isEmpty();
            if (groupHasSimpleFunctions || !((Collection)group.getConstructors()).isEmpty()) {
                packageMemberScope.processFunctionsByName(declarationName, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(group, this, file2, declarationName){
                    final /* synthetic */ DeclarationBuckets $group;
                    final /* synthetic */ FirDeclarationInspector this$0;
                    final /* synthetic */ FirFile $file;
                    final /* synthetic */ Name $declarationName;
                    {
                        this.$group = $group;
                        this.this$0 = $receiver;
                        this.$file = $file;
                        this.$declarationName = $declarationName;
                        super(1);
                    }

                    public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getSimpleFunctions(), it, null, null, 96, null);
                        FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getConstructors(), it, null, null, 96, null);
                    }
                }));
            }
            if (groupHasClassLikesOrProperties || groupHasSimpleFunctions) {
                packageMemberScope.processClassifiersByNameWithSubstitution(declarationName, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(group, groupHasSimpleFunctions, this, file2, declarationName){
                    final /* synthetic */ DeclarationBuckets $group;
                    final /* synthetic */ boolean $groupHasSimpleFunctions;
                    final /* synthetic */ FirDeclarationInspector this$0;
                    final /* synthetic */ FirFile $file;
                    final /* synthetic */ Name $declarationName;
                    {
                        this.$group = $group;
                        this.$groupHasSimpleFunctions = $groupHasSimpleFunctions;
                        this.this$0 = $receiver;
                        this.$file = $file;
                        this.$declarationName = $declarationName;
                        super(2);
                    }

                    public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                        Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                        FirDeclarationInspector.collectTopLevel$collectFromClassifierSource$default(this.$group, this.$groupHasSimpleFunctions, this.this$0, this.$file, this.$declarationName, symbol2, null, null, 192, null);
                    }
                });
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = FirNameConflictsTrackerComponentKt.getNameConflictsTracker(this.getSession());
                if (firNameConflictsTrackerComponent != null) {
                    HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap;
                    Object it = firNameConflictsTrackerComponent;
                    boolean bl2 = false;
                    FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)it : null;
                    if (firNameConflictsTracker != null && (hashMap = firNameConflictsTracker.getRedeclaredClassifiers()) != null && (it = hashMap.get(new ClassId(UtilsKt.getPackageFqName(file2), declarationName))) != null) {
                        Iterable $this$forEach$iv = (Iterable)it;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FirNameConflictsTracker.ClassifierWithFile it2 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                            boolean bl3 = false;
                            FirDeclarationInspector.collectTopLevel$collectFromClassifierSource$default(group, groupHasSimpleFunctions, this, file2, declarationName, it2.getClassifier(), null, it2.getFile(), 64, null);
                        }
                    }
                }
                for (Pair pair : group.getClassLikes()) {
                    FirClassLikeDeclaration classLike = (FirClassLikeDeclaration)pair.component1();
                    String representation = (String)pair.component2();
                    FirDeclarationInspector.collectTopLevel$collectFromClassifierSource(group, groupHasSimpleFunctions, this, file2, declarationName, (FirClassifierSymbol)classLike.getSymbol(), representation, file2);
                }
            }
            if (!groupHasClassLikesOrProperties && !(!((Collection)group.getExtensionProperties()).isEmpty())) continue;
            packageMemberScope.processPropertiesByName(declarationName, (Function1)new Function1<FirVariableSymbol<?>, Unit>(group, this, file2, declarationName){
                final /* synthetic */ DeclarationBuckets $group;
                final /* synthetic */ FirDeclarationInspector this$0;
                final /* synthetic */ FirFile $file;
                final /* synthetic */ Name $declarationName;
                {
                    this.$group = $group;
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$declarationName = $declarationName;
                    super(1);
                }

                public final void invoke(@NotNull FirVariableSymbol<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getClassLikes(), it, null, null, 96, null);
                    FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getProperties(), it, null, null, 96, null);
                    FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getExtensionProperties(), it, null, null, 96, null);
                }
            });
        }
    }

    private final void collectTopLevelConflict(FirDeclaration declaration, String declarationPresentation, FirFile containingFile, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        Object object;
        FirFile actualConflictingFile;
        String actualConflictingPresentation;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(conflictingSymbol, FirResolvePhase.STATUS);
        Object conflicting = conflictingSymbol.getFir();
        if (Intrinsics.areEqual(conflicting, (Object)declaration) || !Intrinsics.areEqual((Object)declaration.getModuleData(), (Object)((FirDeclaration)conflicting).getModuleData())) {
            return;
        }
        String string2 = conflictingPresentation;
        if (string2 == null) {
            string2 = FirRedeclarationPresenter.INSTANCE.represent((FirDeclaration)conflicting);
        }
        if (!Intrinsics.areEqual((Object)(actualConflictingPresentation = string2), (Object)declarationPresentation)) {
            return;
        }
        FirFile firFile = conflictingFile;
        if (firFile == null) {
            FirBasedSymbol<?> firBasedSymbol = conflictingSymbol;
            firFile = firBasedSymbol instanceof FirClassLikeSymbol ? FirProviderKt.getFirProvider(this.getSession()).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)conflictingSymbol) : (actualConflictingFile = firBasedSymbol instanceof FirCallableSymbol ? FirProviderKt.getFirProvider(this.getSession()).getFirCallableContainerFile((FirCallableSymbol)conflictingSymbol) : null);
        }
        if (!FirConflictsHelpersKt.access$isCollectable(conflicting)) {
            return;
        }
        if (this.areCompatibleMainFunctions(declaration, containingFile, (FirDeclaration)conflicting, actualConflictingFile)) {
            return;
        }
        if (conflicting instanceof FirMemberDeclaration && !FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.getSession()), (FirMemberDeclaration)conflicting, this.getSession(), containingFile, CollectionsKt.emptyList(), null, false, null, false, null, 480, null)) {
            return;
        }
        if (this.isOverloadable(declaration, (FirDeclaration)conflicting)) {
            return;
        }
        Map $this$getOrPut$iv = this.declarationConflictingSymbols;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            SmartSet answer$iv = SmartSet.Companion.create();
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((SmartSet)object).add(conflictingSymbol);
    }

    private final boolean representsMainFunctionAllowingConflictingOverloads(FirSimpleFunction $this$representsMainFunctionAllowingConflictingOverloads) {
        if (!(Intrinsics.areEqual((Object)$this$representsMainFunctionAllowingConflictingOverloads.getName(), (Object)StandardNames.MAIN) && FirConflictsHelpersKt.access$isTopLevel($this$representsMainFunctionAllowingConflictingOverloads.getSymbol().getCallableId()) && FirConflictsHelpersKt.access$getHasMainFunctionStatus($this$representsMainFunctionAllowingConflictingOverloads))) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getReceiverParameter() != null || !((Collection)$this$representsMainFunctionAllowingConflictingOverloads.getTypeParameters()).isEmpty()) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getValueParameters().isEmpty()) {
            return true;
        }
        Object object = (FirValueParameter)CollectionsKt.singleOrNull($this$representsMainFunctionAllowingConflictingOverloads.getValueParameters());
        if (object == null || (object = ((FirValueParameter)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null || (object = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, this.getSession())) == null) {
            return false;
        }
        Object paramType = object;
        if (!ConeBuiltinTypeUtilsKt.isNonPrimitiveArray((ConeKotlinType)paramType)) {
            return false;
        }
        Object object2 = ArraysKt.singleOrNull((Object[])((ConeKotlinType)paramType).getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object2 instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object2 : null;
        if (coneKotlinTypeProjection == null) {
            return false;
        }
        ConeKotlinTypeProjection typeArgument = coneKotlinTypeProjection;
        if (!(typeArgument instanceof ConeKotlinType) && !(typeArgument instanceof ConeKotlinTypeProjectionOut)) {
            return false;
        }
        return ConeBuiltinTypeUtilsKt.isString(TypeExpansionUtilsKt.fullyExpandedType(typeArgument.getType(), this.getSession()));
    }

    private final boolean areCompatibleMainFunctions(FirDeclaration declaration1, FirFile file1, FirDeclaration declaration2, FirFile file2) {
        return !Intrinsics.areEqual((Object)file1, (Object)file2) && declaration1 instanceof FirSimpleFunction && declaration2 instanceof FirSimpleFunction && this.representsMainFunctionAllowingConflictingOverloads((FirSimpleFunction)declaration1) && this.representsMainFunctionAllowingConflictingOverloads((FirSimpleFunction)declaration2);
    }

    private final boolean isOverloadable(FirDeclaration declaration, FirDeclaration conflicting) {
        boolean conflictingIsLowPriority;
        if (FirConflictsHelpersKt.access$isExpectAndActual(declaration, conflicting)) {
            return true;
        }
        boolean declarationIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(declaration.getAnnotations());
        if (declarationIsLowPriority != (conflictingIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(conflicting.getAnnotations()))) {
            return true;
        }
        return declaration instanceof FirCallableDeclaration && conflicting instanceof FirCallableDeclaration && FirDeclarationOverloadabilityHelperKt.getDeclarationOverloadabilityHelper(this.getSession()).isOverloadable((FirCallableDeclaration)declaration, (FirCallableDeclaration)conflicting);
    }

    private static final void collectTopLevel$collect(FirDeclarationInspector this$0, FirFile $file, Name declarationName, List<? extends Pair<? extends FirDeclaration, String>> declarations2, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        for (Pair<? extends FirDeclaration, String> pair : declarations2) {
            FirDeclaration declaration = (FirDeclaration)pair.component1();
            String declarationPresentation = (String)pair.component2();
            this$0.collectTopLevelConflict(declaration, declarationPresentation, $file, conflictingSymbol, conflictingPresentation, conflictingFile);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this$0.getSession());
            if (firLookupTrackerComponent == null) continue;
            String string2 = UtilsKt.getPackageFqName($file).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            firLookupTrackerComponent.recordLookup(declarationName, string2, declaration.getSource(), $file.getSource());
        }
    }

    static /* synthetic */ void collectTopLevel$collect$default(FirDeclarationInspector firDeclarationInspector, FirFile firFile, Name name2, List list2, FirBasedSymbol firBasedSymbol, String string2, FirFile firFile2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            firFile2 = null;
        }
        FirDeclarationInspector.collectTopLevel$collect(firDeclarationInspector, firFile, name2, list2, firBasedSymbol, string2, firFile2);
    }

    private static final void collectTopLevel$collectFromClassifierSource(DeclarationBuckets group, boolean groupHasSimpleFunctions, FirDeclarationInspector this$0, FirFile $file, Name declarationName, FirClassifierSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        FirDeclarationInspector.collectTopLevel$collect(this$0, $file, declarationName, group.getClassLikes(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
        FirDeclarationInspector.collectTopLevel$collect(this$0, $file, declarationName, group.getProperties(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
        if (groupHasSimpleFunctions) {
            if (!(conflictingSymbol instanceof FirRegularClassSymbol)) {
                return;
            }
            if (((FirRegularClassSymbol)conflictingSymbol).getClassKind() == ClassKind.OBJECT || ((FirRegularClassSymbol)conflictingSymbol).getClassKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)conflictingSymbol, FirResolvePhase.STATUS);
            FirRegularClass classWithSameName = (FirRegularClass)((FirRegularClassSymbol)conflictingSymbol).getFir();
            FirHelpersKt.unsubstitutedScope(classWithSameName, this$0.context).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)new Function1<FirConstructorSymbol, Unit>(classWithSameName, group, this$0, $file, declarationName){
                final /* synthetic */ FirRegularClass $classWithSameName;
                final /* synthetic */ DeclarationBuckets $group;
                final /* synthetic */ FirDeclarationInspector this$0;
                final /* synthetic */ FirFile $file;
                final /* synthetic */ Name $declarationName;
                {
                    this.$classWithSameName = $classWithSameName;
                    this.$group = $group;
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$declarationName = $declarationName;
                    super(1);
                }

                public final void invoke(@NotNull FirConstructorSymbol constructor2) {
                    Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                    String ctorRepresentation = FirRedeclarationPresenter.INSTANCE.represent((FirConstructor)constructor2.getFir(), this.$classWithSameName);
                    FirDeclarationInspector.collectTopLevel$collect$default(this.this$0, this.$file, this.$declarationName, this.$group.getSimpleFunctions(), constructor2, ctorRepresentation, null, 64, null);
                }
            }));
        }
    }

    static /* synthetic */ void collectTopLevel$collectFromClassifierSource$default(DeclarationBuckets declarationBuckets, boolean bl, FirDeclarationInspector firDeclarationInspector, FirFile firFile, Name name2, FirClassifierSymbol firClassifierSymbol, String string2, FirFile firFile2, int n, Object object) {
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            firFile2 = null;
        }
        FirDeclarationInspector.collectTopLevel$collectFromClassifierSource(declarationBuckets, bl, firDeclarationInspector, firFile, name2, firClassifierSymbol, string2, firFile2);
    }
}

