/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.parser.KDocLinkParser;
import org.jetbrains.kotlin.kdoc.parser.KDocParser;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocImpl;

public interface KDocTokens {
    public static final ILazyParseableElementType KDOC = new ILazyParseableElementType("KDoc", KotlinLanguage.INSTANCE){

        @Override
        public ASTNode parseContents(ASTNode chameleon) {
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new KDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
            KDocParser parser = new KDocParser();
            return parser.parse(this, builder2).getFirstChildNode();
        }

        @Override
        @Nullable
        public ASTNode createNode(CharSequence text2) {
            return new KDocImpl(text2);
        }
    };
    public static final KDocToken START = new KDocToken("KDOC_START");
    public static final KDocToken END = new KDocToken("KDOC_END");
    public static final KDocToken LEADING_ASTERISK = new KDocToken("KDOC_LEADING_ASTERISK");
    public static final KDocToken TEXT = new KDocToken("KDOC_TEXT");
    public static final KDocToken CODE_BLOCK_TEXT = new KDocToken("KDOC_CODE_BLOCK_TEXT");
    public static final KDocToken TAG_NAME = new KDocToken("KDOC_TAG_NAME");
    public static final ILazyParseableElementType MARKDOWN_LINK = new ILazyParseableElementType("KDOC_MARKDOWN_LINK", KotlinLanguage.INSTANCE){

        @Override
        public ASTNode parseContents(ASTNode chameleon) {
            return KDocLinkParser.parseMarkdownLink(this, chameleon);
        }
    };
    public static final KDocToken MARKDOWN_ESCAPED_CHAR = new KDocToken("KDOC_MARKDOWN_ESCAPED_CHAR");
    public static final KDocToken MARKDOWN_INLINE_LINK = new KDocToken("KDOC_MARKDOWN_INLINE_LINK");
    public static final TokenSet KDOC_HIGHLIGHT_TOKENS = TokenSet.create(START, END, LEADING_ASTERISK, TEXT, CODE_BLOCK_TEXT, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK);
    public static final TokenSet CONTENT_TOKENS = TokenSet.create(TEXT, CODE_BLOCK_TEXT, TAG_NAME, MARKDOWN_LINK, MARKDOWN_ESCAPED_CHAR, MARKDOWN_INLINE_LINK);
}

