/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FunctionDelegateMemberNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class FunctionDelegateMemberNameClashChecker
implements DeclarationChecker {
    public static final FunctionDelegateMemberNameClashChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
                DeclarationDescriptor container = declarationDescriptor;
                if (!(container instanceof ClassDescriptor) || !((ClassDescriptor)container).isFun()) {
                    return;
                }
                if (((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter() != null) break block8;
                List<ValueParameterDescriptor> list2 = ((CallableMemberDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
                Collection collection = list2;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block9;
            }
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"getFunctionDelegate") || descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor2).getName().asString(), (Object)"functionDelegate")) {
            PsiElement psiElement;
            KtDeclaration ktDeclaration = declaration2;
            if (!(ktDeclaration instanceof KtNamedDeclaration)) {
                ktDeclaration = null;
            }
            if ((psiElement = (KtNamedDeclaration)ktDeclaration) == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                psiElement = declaration2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"(declaration as? KtNamed\u2026Identifier ?: declaration");
            PsiElement reportOn = psiElement;
            context2.getTrace().report(ErrorsJvm.FUNCTION_DELEGATE_MEMBER_NAME_CLASH.on(reportOn));
        }
    }

    private FunctionDelegateMemberNameClashChecker() {
    }

    static {
        FunctionDelegateMemberNameClashChecker functionDelegateMemberNameClashChecker;
        INSTANCE = functionDelegateMemberNameClashChecker = new FunctionDelegateMemberNameClashChecker();
    }
}

