/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.kotlin.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.ComponentParameter;
import org.jetbrains.kotlin.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.kotlin.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;
    protected LifecycleStrategy lifecycleStrategy;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy) {
        super(componentKey, componentImplementation, monitor);
        this.checkConcrete();
        if (parameters2 != null) {
            for (int i = 0; i < parameters2.length; ++i) {
                if (parameters2[i] != null) continue;
                throw new NullPointerException("Parameter " + i + " is null");
            }
        }
        this.parameters = parameters2;
        this.allowNonPublicClasses = allowNonPublicClasses;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] parameters2) {
        Parameter[] componentParameters = new Parameter[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    protected Object newInstance(Constructor constructor, Object[] parameters2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(parameters2);
    }

    protected abstract Constructor getGreediestSatisfiableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;
}

