/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSealedClassInheritorsTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "checkBooleanExhaustiveness", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "nullable", "checkEnumExhaustiveness", "enum", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSealedClassExhaustiveness", "sealedClass", "processExhaustivenessCheck", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "BooleanExhaustivenessFlags", "BooleanExhaustivenessVisitor", "EnumExhaustivenessData", "EnumExhaustivenessVisitor", "SealedExhaustivenessData", "SealedExhaustivenessVisitor", "resolve"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer {
    private final BodyResolveComponents bodyResolveComponents;

    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw (Throwable)new IllegalArgumentException("Should not be there");
    }

    @NotNull
    public CompositeTransformResult<FirStatement> transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        FirWhenExpression firWhenExpression = this.processExhaustivenessCheck(whenExpression);
        if (firWhenExpression == null) {
            firWhenExpression = whenExpression;
        }
        FirWhenExpression resultExpression = firWhenExpression;
        FirElement $this$compose$iv = resultExpression;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final FirWhenExpression processExhaustivenessCheck(FirWhenExpression whenExpression) {
        FirWhenExpression firWhenExpression;
        boolean bl;
        Object object;
        Object object2;
        boolean bl2;
        block21: {
            Iterable $this$any$iv = whenExpression.getBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl3 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl2 = true;
                    break block21;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            whenExpression.replaceIsExhaustive(true);
            return whenExpression;
        }
        FirAnnotationContainer firAnnotationContainer = whenExpression.getSubjectVariable();
        if (firAnnotationContainer == null || (firAnnotationContainer = firAnnotationContainer.getReturnTypeRef()) == null) {
            FirExpression firExpression2 = whenExpression.getSubject();
            firAnnotationContainer = firExpression2 != null ? firExpression2.getTypeRef() : null;
        }
        if (firAnnotationContainer == null) {
            return null;
        }
        FirAnnotationContainer typeRef = firAnnotationContainer;
        FirAnnotationContainer firAnnotationContainer2 = typeRef;
        if (!(firAnnotationContainer2 instanceof FirResolvedTypeRef)) {
            firAnnotationContainer2 = null;
        }
        if ((object2 = (FirResolvedTypeRef)firAnnotationContainer2) == null || (object2 = ((FirResolvedTypeRef)object2).getType()) == null || (object2 = ConeTypesKt.lowerBoundIfFlexible((ConeKotlinType)object2)) == null) {
            return null;
        }
        Object type2 = object2;
        Object object3 = type2;
        if (!(object3 instanceof ConeLookupTagBasedType)) {
            object3 = null;
        }
        if ((object = (ConeLookupTagBasedType)object3) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            return null;
        }
        Object lookupTag = object;
        boolean nullable = ((FirResolvedTypeRef)typeRef).getType().getNullability() == ConeNullability.NULLABLE;
        Object object4 = lookupTag;
        if (!(object4 instanceof ConeClassLikeLookupTag)) {
            object4 = null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = (ConeClassLikeLookupTag)object4;
        if (Intrinsics.areEqual((Object)(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null), (Object)this.bodyResolveComponents.getSession().getBuiltinTypes().getBooleanType().getId())) {
            bl = this.checkBooleanExhaustiveness(whenExpression, nullable);
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = ResolveUtilsKt.toSymbol((ConeClassifierLookupTag)lookupTag, this.bodyResolveComponents.getSession());
            Object object5 = firClassifierSymbol != null ? firClassifierSymbol.getFir() : null;
            if (!(object5 instanceof FirRegularClass)) {
                object5 = null;
            }
            FirRegularClass firRegularClass = (FirRegularClass)object5;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass klass = firRegularClass;
            if (klass.getClassKind() == ClassKind.ENUM_CLASS) {
                bl = this.checkEnumExhaustiveness(whenExpression, klass, nullable);
            } else {
                FirMemberDeclaration $this$modality$iv = klass;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
                    bl = this.checkSealedClassExhaustiveness(whenExpression, klass, nullable);
                } else {
                    return null;
                }
            }
        }
        boolean isExhaustive = bl;
        if (isExhaustive) {
            whenExpression.replaceIsExhaustive(true);
            firWhenExpression = whenExpression;
        } else {
            firWhenExpression = null;
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkEnumExhaustiveness(FirWhenExpression whenExpression, FirRegularClass firRegularClass, boolean nullable) {
        Collection<FirVariableSymbol<FirEnumEntry>> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = FirDeclarationUtilKt.collectEnumEntries(firRegularClass);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirVariableSymbol<FirEnumEntry> firVariableSymbol = it.getSymbol();
            collection.add(firVariableSymbol);
        }
        collection = (List)destination$iv$iv;
        boolean bl = !nullable;
        Set set = CollectionsKt.toMutableSet((Iterable)collection);
        EnumExhaustivenessData data = new EnumExhaustivenessData(set, bl);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(EnumExhaustivenessVisitor.INSTANCE, data);
        }
        return data.getContainsNull() && data.getRemainingEntries().isEmpty();
    }

    private final boolean checkSealedClassExhaustiveness(FirWhenExpression whenExpression, FirRegularClass sealedClass, boolean nullable) {
        List<ClassId> inheritors2 = FirSealedClassInheritorsTransformerKt.getSealedInheritors(sealedClass);
        Collection collection = inheritors2;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        SealedExhaustivenessData data = new SealedExhaustivenessData(ResolveUtilsKt.getFirSymbolProvider(sealedClass.getSession()), CollectionsKt.toMutableSet((Iterable)inheritors2), !nullable);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(SealedExhaustivenessVisitor.INSTANCE, data);
        }
        return data.getContainsNull() && data.getRemainingInheritors().isEmpty();
    }

    private final boolean checkBooleanExhaustiveness(FirWhenExpression whenExpression, boolean nullable) {
        BooleanExhaustivenessFlags flags = new BooleanExhaustivenessFlags(!nullable);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(BooleanExhaustivenessVisitor.INSTANCE, flags);
        }
        return flags.getContainsTrue() && flags.getContainsFalse() && flags.getContainsNull();
    }

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "", "remainingEntries", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "containsNull", "", "(Ljava/util/Set;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "getRemainingEntries", "()Ljava/util/Set;", "resolve"})
    private static final class EnumExhaustivenessData {
        @NotNull
        private final Set<FirVariableSymbol<FirEnumEntry>> remainingEntries;
        private boolean containsNull;

        @NotNull
        public final Set<FirVariableSymbol<FirEnumEntry>> getRemainingEntries() {
            return this.remainingEntries;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public EnumExhaustivenessData(@NotNull Set<FirVariableSymbol<FirEnumEntry>> remainingEntries, boolean containsNull) {
            Intrinsics.checkNotNullParameter(remainingEntries, (String)"remainingEntries");
            this.remainingEntries = remainingEntries;
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "resolve"})
    private static final class EnumExhaustivenessVisitor
    extends FirVisitor<Unit, EnumExhaustivenessData> {
        public static final EnumExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull EnumExhaustivenessData data) {
            block4: {
                Object object;
                FirExpression argument;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)operatorCall, (String)"operatorCall");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (operatorCall.getOperation() != FirOperation.EQ) break block4;
                    FirCall $this$arguments$iv = operatorCall;
                    boolean $i$f$getArguments = false;
                    argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
                    if (!(argument instanceof FirConstExpression)) break block5;
                    if (((FirConstExpression)argument).getValue() != null) break block4;
                    data.setContainsNull(true);
                    break block4;
                }
                if (!(argument instanceof FirQualifiedAccessExpression)) break block4;
                FirReference firReference = ((FirQualifiedAccessExpression)argument).getCalleeReference();
                if (!(firReference instanceof FirResolvedNamedReference)) {
                    firReference = null;
                }
                FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
                if (firResolvedNamedReference == null) {
                    return;
                }
                FirResolvedNamedReference reference = firResolvedNamedReference;
                Object obj = reference.getResolvedSymbol().getFir();
                if (!(obj instanceof FirEnumEntry)) {
                    obj = null;
                }
                if ((object = (FirEnumEntry)obj) == null || (object = ((FirEnumEntry)object).getSymbol()) == null) {
                    return;
                }
                Object symbol2 = object;
                data.getRemainingEntries().remove(symbol2);
            }
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }

        private EnumExhaustivenessVisitor() {
        }

        static {
            EnumExhaustivenessVisitor enumExhaustivenessVisitor;
            INSTANCE = enumExhaustivenessVisitor = new EnumExhaustivenessVisitor();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "remainingInheritors", "", "Lorg/jetbrains/kotlin/name/ClassId;", "containsNull", "", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Ljava/util/Set;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "getRemainingInheritors", "()Ljava/util/Set;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "resolve"})
    private static final class SealedExhaustivenessData {
        @NotNull
        private final FirSymbolProvider symbolProvider;
        @NotNull
        private final Set<ClassId> remainingInheritors;
        private boolean containsNull;

        @NotNull
        public final FirSymbolProvider getSymbolProvider() {
            return this.symbolProvider;
        }

        @NotNull
        public final Set<ClassId> getRemainingInheritors() {
            return this.remainingInheritors;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public SealedExhaustivenessData(@NotNull FirSymbolProvider symbolProvider2, @NotNull Set<ClassId> remainingInheritors, boolean containsNull) {
            Intrinsics.checkNotNullParameter((Object)symbolProvider2, (String)"symbolProvider");
            Intrinsics.checkNotNullParameter(remainingInheritors, (String)"remainingInheritors");
            this.symbolProvider = symbolProvider2;
            this.remainingInheritors = remainingInheritors;
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "resolve"})
    private static final class SealedExhaustivenessVisitor
    extends FirDefaultVisitor<Unit, SealedExhaustivenessData> {
        public static final SealedExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (typeOperatorCall.getOperation() == FirOperation.IS) {
                typeOperatorCall.getConversionTypeRef().accept(this, data);
            }
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull SealedExhaustivenessData data) {
            block0: {
                FirExpression firExpression2;
                FirExpression argument;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)operatorCall, (String)"operatorCall");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (operatorCall.getOperation() != FirOperation.EQ) break block0;
                    FirCall $this$arguments$iv = operatorCall;
                    boolean $i$f$getArguments = false;
                    argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
                    firExpression2 = argument;
                    if (!(firExpression2 instanceof FirConstExpression)) break block1;
                    if (((FirConstExpression)argument).getValue() != null) break block0;
                    data.setContainsNull(true);
                    break block0;
                }
                if (!(firExpression2 instanceof FirResolvedQualifier)) break block0;
                argument.getTypeRef().accept(this, data);
            }
        }

        @Override
        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull SealedExhaustivenessData data) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ConeKotlinType coneKotlinType = resolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeLookupTagBasedType)coneKotlinType) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
                return;
            }
            Object lookupTag = object;
            FirClassifierSymbol<?> firClassifierSymbol = data.getSymbolProvider().getSymbolByLookupTag((ConeClassifierLookupTag)lookupTag);
            if (!(firClassifierSymbol instanceof FirClassSymbol)) {
                firClassifierSymbol = null;
            }
            FirClassSymbol firClassSymbol = (FirClassSymbol)firClassifierSymbol;
            if (firClassSymbol == null) {
                return;
            }
            FirClassSymbol symbol2 = firClassSymbol;
            data.getRemainingInheritors().remove(symbol2.getClassId());
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }

        private SealedExhaustivenessVisitor() {
        }

        static {
            SealedExhaustivenessVisitor sealedExhaustivenessVisitor;
            INSTANCE = sealedExhaustivenessVisitor = new SealedExhaustivenessVisitor();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0004R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "", "containsNull", "", "(Z)V", "containsFalse", "getContainsFalse", "()Z", "setContainsFalse", "getContainsNull", "setContainsNull", "containsTrue", "getContainsTrue", "setContainsTrue", "resolve"})
    private static final class BooleanExhaustivenessFlags {
        private boolean containsTrue;
        private boolean containsFalse;
        private boolean containsNull;

        public final boolean getContainsTrue() {
            return this.containsTrue;
        }

        public final void setContainsTrue(boolean bl) {
            this.containsTrue = bl;
        }

        public final boolean getContainsFalse() {
            return this.containsFalse;
        }

        public final void setContainsFalse(boolean bl) {
            this.containsFalse = bl;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public BooleanExhaustivenessFlags(boolean containsNull) {
            this.containsNull = containsNull;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitOperatorCall", "operatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirOperatorCall;", "resolve"})
    private static final class BooleanExhaustivenessVisitor
    extends FirVisitor<Unit, BooleanExhaustivenessFlags> {
        public static final BooleanExhaustivenessVisitor INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull BooleanExhaustivenessFlags data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitOperatorCall(@NotNull FirOperatorCall operatorCall, @NotNull BooleanExhaustivenessFlags data) {
            block0: {
                Object t;
                block2: {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)operatorCall, (String)"operatorCall");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        if (operatorCall.getOperation() != FirOperation.EQ) break block0;
                        FirCall $this$arguments$iv = operatorCall;
                        boolean $i$f$getArguments = false;
                        FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
                        if (!(argument instanceof FirConstExpression)) break block0;
                        t = ((FirConstExpression)argument).getValue();
                        if (!Intrinsics.areEqual(t, (Object)true)) break block1;
                        data.setContainsTrue(true);
                        break block0;
                    }
                    if (!Intrinsics.areEqual(t, (Object)false)) break block2;
                    data.setContainsFalse(true);
                    break block0;
                }
                if (t != null) break block0;
                data.setContainsNull(true);
            }
        }

        private BooleanExhaustivenessVisitor() {
        }

        static {
            BooleanExhaustivenessVisitor booleanExhaustivenessVisitor;
            INSTANCE = booleanExhaustivenessVisitor = new BooleanExhaustivenessVisitor();
        }
    }
}

