/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(PsiExpression expression2) {
        this.myBuf.append(expression2.getText());
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        expression2.getOperand().accept(this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType2 = expression2.getCheckType();
        if (checkType2 != null) {
            this.myBuf.append(checkType2.getText());
        }
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.myBuf.append("(");
        PsiExpression expr = expression2.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiExpression operand;
        PsiTypeElement castType = expression2.getCastType();
        if (castType != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression2.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        expression2.getArrayExpression().accept(this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression operand = expression2.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        expression2.getOperand().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        PsiExpression[] operands = expression2.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (i != 0) {
                PsiJavaToken token = expression2.getTokenBeforeOperand(operand);
                this.myBuf.append(" ").append(token.getText()).append(" ");
            }
            operand.accept(this);
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiParameterList parameterList = expression2.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiElement firstChild = parameterList.getFirstChild();
        boolean addParenthesis = PsiUtil.isJavaToken(firstChild, JavaTokenType.LPARENTH);
        if (addParenthesis) {
            this.myBuf.append('(');
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeElement typeElement;
            PsiParameter parameter = parameters2[i];
            if (i != 0) {
                this.myBuf.append(", ");
            }
            int formatOptions = 1 | ((typeElement = parameter.getTypeElement()) == null ? 0 : 2);
            this.myBuf.append(PsiFormatUtil.formatVariable(parameter, formatOptions, PsiSubstitutor.EMPTY));
        }
        if (addParenthesis) {
            this.myBuf.append(')');
        }
        this.myBuf.append(" -> {...}");
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        expression2.getCondition().accept(this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression = expression2.getThenExpression();
        if (thenExpression != null) {
            thenExpression.accept(this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression = expression2.getElseExpression();
        if (elseExpression != null) {
            elseExpression.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        expression2.getLExpression().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression rExpression = expression2.getRExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expr) {
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expr) {
        expr.getMethodExpression().accept(this);
        expr.getArgumentList().accept(this);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        PsiElement qualifier = expression2.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
        }
        this.myBuf.append("::");
        this.myBuf.append(expression2.getReferenceName());
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        this.myBuf.append("{");
        boolean first = true;
        for (PsiExpression expr : expression2.getInitializers()) {
            if (!first) {
                this.myBuf.append(", ");
            }
            first = false;
            expr.accept(this);
        }
        this.myBuf.append("}");
    }

    @Override
    public void visitExpressionList(PsiExpressionList list2) {
        PsiExpression[] args = list2.getExpressions();
        if (args.length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expr) {
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList2 = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList2 != null) {
                argumentList2.accept(this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference = expr.getClassReference();
            if (reference != null) {
                PsiArrayInitializerExpression arrayInitializer;
                int dimensions;
                this.myBuf.append("new").append(" ").append(reference.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                PsiType type2 = expr.getType();
                int n = dimensions = type2 != null ? type2.getArrayDimensions() : arrayDimensions.length;
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("[");
                }
                int arrayDimensionsLength = arrayDimensions.length;
                for (int i = 0; i < dimensions; ++i) {
                    PsiExpression dimension;
                    PsiExpression psiExpression = dimension = i < arrayDimensionsLength ? arrayDimensions[i] : null;
                    if (i > 0) {
                        this.myBuf.append("][");
                    }
                    if (dimension == null) continue;
                    dimension.accept(this);
                }
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("]");
                }
                if (argumentList2 != null) {
                    argumentList2.accept(this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    arrayInitializer.accept(this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static String render(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(0);
        }
        return PsiExpressionTrimRenderer.render(expression2, 100);
    }

    public static String render(@NotNull PsiExpression expression2, int maxLength) {
        if (expression2 == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(1);
        }
        StringBuilder buf = new StringBuilder();
        expression2.accept(new PsiExpressionTrimRenderer(buf));
        String text2 = buf.toString();
        int firstNewLinePos = text2.indexOf(10);
        String trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(maxLength, text2.length()));
        if (trimmedText.length() != text2.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer", "render"));
    }

    public static class RenderFunction
    implements NotNullFunction<PsiExpression, String> {
        @Override
        @NotNull
        public String fun(@NotNull PsiExpression psiExpression) {
            if (psiExpression == null) {
                RenderFunction.$$$reportNull$$$0(0);
            }
            String string2 = PsiExpressionTrimRenderer.render(psiExpression);
            if (string2 == null) {
                RenderFunction.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer$RenderFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiExpressionTrimRenderer$RenderFunction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

