/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String fromProperty = System.getProperty("idea.home.path", System.getProperty("idea.home"));
            if (fromProperty != null) {
                result2 = PathManager.getAbsolutePath(fromProperty);
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfo.isWindows) {
                result2 = PathManager.canonicalPath(result2);
            }
            ourBinDirectories = result2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : PathManager.getBinDirectories(new File(result2));
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    private static String[] getBinDirectories() {
        String[] result2 = ourBinDirectories;
        if (result2 == null) {
            PathManager.getHomePath(true);
            return ourBinDirectories;
        }
        return result2;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass2) {
        String rootPath;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root2 = new File(rootPath).getAbsoluteFile();
        while ((root2 = root2.getParentFile()) != null && !PathManager.isIdeaHome(root2)) {
        }
        return root2 != null ? root2.getPath() : null;
    }

    private static boolean isIdeaHome(@NotNull File root2) {
        if (root2 == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        for (String binDir : PathManager.getBinDirectories(root2)) {
            if (!new File(binDir, "idea.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String[] getBinDirectories(@NotNull File root2) {
        if (root2 == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        SmartList<String> binDirs = new SmartList<String>();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root2, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(binDirs);
        if (stringArray == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + "/" + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        for (String binDir : PathManager.getBinDirectories()) {
            File file2 = new File(binDir, fileName);
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            File file3 = file2;
            if (file3 == null) {
                PathManager.$$$reportNull$$$0(9);
            }
            return file3;
        }
        String paths = StringUtil.join(PathManager.getBinDirectories(), "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string2 = PathManager.getHomePath() + "/" + "plugins";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String fromProp = System.getProperty("idea.config.path");
        ourConfigPath = fromProp != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(fromProp)) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + "config");
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        return PathManager.platformPath(selector, "Library/Preferences", "config");
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string2 = ourPluginsPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(19);
            }
            return string2;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + "/" + "plugins");
        String string3 = ourPluginsPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return string3;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string2;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + "system");
        FileUtilRt.createDirectory(new File(ourSystemPath));
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return PathManager.platformPath(selector, "Library/Caches", "system");
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtilRt.createDirectory(indexRoot);
        File file2 = indexRoot;
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context2, @NotNull String path2) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        if ((url = context2.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(@NotNull URL resourceURL, @NotNull String resourcePath) {
        if (resourceURL == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtilRt.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, "/");
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path2 = PathManager.getHomePath();
        if (new File(path2, "community/.idea").isDirectory()) {
            String string2 = path2 + "/community";
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(39);
            }
            return string2;
        }
        if (new File(path2, "ultimate/community/.idea").isDirectory()) {
            String string3 = path2 + "/ultimate/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(40);
            }
            return string3;
        }
        String string4 = path2;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass2) {
        String resourceRoot;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        path2 = FileUtil.expandUserHome(path2);
        String string2 = FileUtil.toCanonicalPath(new File(path2).getAbsolutePath());
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return string2;
    }

    @NotNull
    public static String trimPathQuotes(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        if (path2.length() >= 3 && StringUtil.startsWithChar(path2, '\"') && StringUtil.endsWithChar(path2, '\"')) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        String string2 = path2;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        return string2;
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(51);
        }
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            String string2 = userHome + "/" + macPart + "/" + selector;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(52);
            }
            return string2;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            String string3 = dir + "/" + selector;
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(53);
            }
            return string3;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + "/" + xdgDir;
            }
            String string4 = dir + "/" + selector;
            if (string4 == null) {
                PathManager.$$$reportNull$$$0(54);
            }
            return string4;
        }
        String string5 = userHome + "/." + selector + (!fallback.isEmpty() ? "/" + fallback : "");
        if (string5 == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        return string5;
    }

    @NotNull
    private static String canonicalPath(@NotNull String path2) {
        String string2;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        try {
            string2 = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            String string3 = path2;
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(58);
            }
            return string3;
        }
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 32: 
            case 44: 
            case 46: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceURL";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPathQuotes";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "platformPath";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBinDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractRoot";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "trimPathQuotes";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "canonicalPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

