/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingByteLength;
    final int indexingCharLength;

    public String toString() {
        return "indexed at " + this.indexingFileStamp + " with document " + IndexingStampInfo.dumpSize(this.indexingByteLength, this.indexingCharLength);
    }

    @NotNull
    static String dumpSize(long byteLength, int charLength) {
        String string2 = " byte size = " + byteLength + ", char size = " + charLength;
        if (string2 == null) {
            IndexingStampInfo.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file2, @NotNull PsiFile psi) {
        if (file2 == null) {
            IndexingStampInfo.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            IndexingStampInfo.$$$reportNull$$$0(2);
        }
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance(psi.getProject()).isCommitted(document)) {
            return false;
        }
        return this.indexingFileStamp == file2.getTimeStamp() && this.contentLengthMatches(file2.getLength(), document.getTextLength());
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.indexingCharLength >= 0 && charContentLength >= 0) {
            return this.indexingCharLength == charContentLength;
        }
        return this.indexingByteLength == byteContentLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/IndexingStampInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/IndexingStampInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

